/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import java.sql.SQLException;

public class DocFormReset
extends Thread {
    public static int THREAD_SIZE = 20;
    public static int MIN_DOCID = 0;
    public static int MAX_DOCID = 0;
    public static String FILE_DIRECTORY = "c://";
    public static int OFFSET_DOCID = 100;
    public static int MAX_COUNT_WRITE_FILE = 2000;
    private DBManager m_oDBMgr = DBManager.getDBManager();
    private static int m_nMinDocId = 0;
    private static int m_nMaxDocId = 0;
    private static int m_nNextMaxDocId = 0;

    private static int analyzeDocForm(String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return 1;
        }
        HtmlElementFinder htmlElementFinder = null;
        HtmlElement htmlElement = null;
        try {
            String string2;
            htmlElementFinder = new HtmlElementFinder(string);
            htmlElement = htmlElementFinder.findNextElement("EMBED", true);
            if (htmlElement != null && !CMyString.isEmpty(string2 = htmlElement.getAttributeValue("src"))) {
                return DocFormReset.analyzeExt(string2);
            }
            htmlElementFinder.setPosition(0);
            htmlElement = htmlElementFinder.findNextElement("IMG", true);
            if (htmlElement != null && htmlElement != null) {
                return 2;
            }
        }
        catch (Exception exception) {
            throw new WCMException("\u89e3\u6790\u6587\u6863\u6240\u5c5e\u5173\u7cfb\u53d1\u751f\u9519\u8bef!", exception);
        }
        return 1;
    }

    private static int analyzeExt(String string) {
        if (CMyString.isEmpty(string)) {
            return 1;
        }
        String string2 = "jpg,jpeg,gif,png,bmp";
        String string3 = "wav,mid,midi,mp3,mpa,mp2,ra,ram,rm,wma";
        String string4 = "asf,avi,mpg,mpeg,mpe,mov,rm,rmvb,wmv,swf";
        String[] stringArray = new String[]{string2, string3, string4};
        int[] nArray = new int[]{2, 3, 4};
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].split(",").length; ++j) {
                if (string.indexOf("." + stringArray[i].split(",")[j]) < 0) continue;
                return nArray[i];
            }
        }
        return 1;
    }

    public void run() {
        ContextHelper.initContext(User.getSystem());
        StringBuffer stringBuffer = new StringBuffer(MAX_COUNT_WRITE_FILE * 2 * 100 + 200);
        stringBuffer.append("alter table WCMDocument nologging;\n");
        stringBuffer.append("alter table WCMChnlDoc nologging;\n");
        int n = 0;
        int n2 = 0;
        while (true) {
            DebugTimer debugTimer;
            int[] nArray;
            if ((nArray = DocFormReset.applyDocId()) == null) {
                if (n > 0) {
                    try {
                        stringBuffer.append("commit;");
                        CMyFile.writeFile(FILE_DIRECTORY + n2 + ".sql", stringBuffer.toString());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    stringBuffer.setLength(0);
                }
                return;
            }
            n2 = nArray[0];
            WCMFilter wCMFilter = new WCMFilter("", "DocId>=? and DocId<=?", "", "DocId,DocHTMLCon,DocType,DocFileName");
            wCMFilter.addSearchValues(nArray[0]);
            wCMFilter.addSearchValues(nArray[1]);
            wCMFilter.setMaxRowNumber(OFFSET_DOCID);
            wCMFilter.setPageSize(OFFSET_DOCID);
            Documents documents = null;
            try {
                debugTimer = new DebugTimer();
                debugTimer.start();
                documents = Documents.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
                int n3 = documents.size();
                for (int i = 0; i < n3; ++i) {
                    Document document = (Document)documents.getAt(i);
                    if (document == null) continue;
                    stringBuffer.append(this.resetDocForm(document));
                }
                debugTimer.stop();
                if (debugTimer.getTime() > 10L && !documents.isEmpty()) {
                    System.out.println("Thread[" + this + "] [" + nArray[0] + "-" + nArray[1] + "]  use[" + debugTimer.getTime() + "]ms");
                }
                documents.clear();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            if ((n += documents.size()) < MAX_COUNT_WRITE_FILE) continue;
            n = 0;
            try {
                debugTimer = new DebugTimer();
                debugTimer.start();
                stringBuffer.append("commit;");
                CMyFile.writeFile(FILE_DIRECTORY + nArray[0] + ".sql", stringBuffer.toString());
                debugTimer.stop();
                System.out.println("Thread[" + this + "] write file use[" + debugTimer.getTime() + "]ms");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            stringBuffer.setLength(0);
            stringBuffer.append("alter table WCMDocument nologging;\n");
            stringBuffer.append("alter table WCMChnlDoc nologging;\n");
        }
    }

    private String resetDocForm(Document document) throws WCMException {
        int n = 1;
        int n2 = document.getType();
        n = n2 == 40 ? DocFormReset.analyzeExt(document.getPropertyAsString("DocFileName")) : (n2 == 20 ? DocFormReset.analyzeDocForm(document.getHtmlContent()) : 1);
        if (n == 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        String string = "update wcmdocument set docform=" + n + " where docid=" + document.getId();
        stringBuffer.append(string);
        stringBuffer.append(";\n");
        this.m_oDBMgr.sqlExecuteUpdate(string);
        string = "update wcmchnldoc set docform=" + n + " where docid=" + document.getId();
        stringBuffer.append(string);
        stringBuffer.append(";\n");
        this.m_oDBMgr.sqlExecuteUpdate(string);
        return stringBuffer.toString();
    }

    public static int[] getRecScale(int n, int n2, int n3) {
        int n4 = (n2 - n) / THREAD_SIZE + 1;
        return new int[]{n + (n3 - 1) * n4, n + n3 * n4 - 1};
    }

    public static void parse() throws WCMException, SQLException {
        m_nMinDocId = 0;
        System.out.println("\u5f00\u59cb\u8fdb\u884c\u6570\u636e\u91c7\u96c6\uff1a");
        m_nMinDocId = MIN_DOCID <= 0 ? DBManager.getDBManager().sqlExecuteIntQuery("select min(docid) from wcmdocument") : MIN_DOCID;
        m_nMaxDocId = 0;
        m_nMaxDocId = MAX_DOCID <= 0 ? DBManager.getDBManager().sqlExecuteIntQuery("select max(docid) from wcmdocument") : MAX_DOCID;
        m_nNextMaxDocId = m_nMaxDocId;
        System.out.println("MinDocId--" + m_nMinDocId);
        System.out.println("MaxDocId--" + m_nMaxDocId);
        for (int i = 0; i < THREAD_SIZE; ++i) {
            DocFormReset docFormReset = new DocFormReset();
            docFormReset.start();
        }
    }

    public static synchronized int[] applyDocId() {
        if (m_nNextMaxDocId < m_nMinDocId) {
            return null;
        }
        int n = m_nNextMaxDocId - OFFSET_DOCID + 1;
        int[] nArray = new int[]{n, m_nNextMaxDocId};
        m_nNextMaxDocId = n - 1;
        return nArray;
    }

    public static void main(String[] stringArray) throws WCMException, SQLException {
        DocFormReset.parse();
    }
}

