/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.infoview.InfoViewEmployMgr;
import com.trs.components.infoview.InfoViewMgr;
import com.trs.components.infoview.InfoViewReplyNoticeSender;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewField;
import com.trs.components.infoview.persistent.InfoViewFields;
import com.trs.components.infoview.persistent.InfoViewGroup;
import com.trs.components.infoview.persistent.InfoViewView;
import com.trs.components.infoview.persistent.InfoViews;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.DocReply;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.service.IInfoViewService;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class InfoViewService
implements IInfoViewService {
    private InfoViewMgr m_oInfoViewMgr = (InfoViewMgr)DreamFactory.createObjectById("InfoViewMgr");
    private InfoViewEmployMgr m_oIVEmployMgr = (InfoViewEmployMgr)DreamFactory.createObjectById("InfoViewEmployMgr");

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public void delete(InfoView infoView) throws WCMException {
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label1", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u5220\u9664!"));
        }
        try {
            this.m_oInfoViewMgr.delete(infoView);
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(InfoViewService.class, "InfoViewService.label2", "\u5220\u9664\u8868\u5355\u51fa\u9519!"), wCMException);
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(InfoViewService.class, "InfoViewService.label2", "\u5220\u9664\u8868\u5355\u51fa\u9519!"), exception);
        }
    }

    public void delete(InfoViews infoViews) throws WCMException {
        if (infoViews == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label3", "\u65e0\u6548\u7684\u8868\u5355\u96c6\u5408,\u65e0\u6cd5\u5220\u9664!"));
        }
        for (int i = 0; i < infoViews.size(); ++i) {
            this.delete((InfoView)infoViews.getAt(i));
        }
    }

    public void delete(int n) throws WCMException {
        InfoView infoView = this.findById(n);
        if (infoView != null) {
            this.delete(infoView);
        }
    }

    public void delete(String string) throws WCMException {
        if (string == null || string.length() == 0) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label4", "\u65e0\u6548\u7684\u8868\u5355ID\u5e8f\u5217,\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c!"));
        }
        this.delete(InfoViews.findByIds(this.getLoginUser(), string));
    }

    public InfoView findById(int n) throws WCMException {
        if (n <= 0) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label5", "\u65e0\u6548\u7684InfoViewId[") + n + I18NMessage.get(InfoViewService.class, "InfoViewService.label6", "],Id\u5e94\u8be5\u5927\u4e8e0"));
        }
        return InfoView.findById(n);
    }

    public InfoViewView findViewById(int n) throws WCMException {
        if (n <= 0) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label7", "\u65e0\u6548\u7684\u89c6\u56feID[") + n + I18NMessage.get(InfoViewService.class, "InfoViewService.label8", "],\u89c6\u56feID\u5e94\u8be5\u5927\u4e8e0"));
        }
        return InfoViewView.findById(n);
    }

    public String forFillOut(InfoView infoView, InfoViewView infoViewView) throws WCMException {
        return this.m_oInfoViewMgr.forFillOut(infoView, infoViewView);
    }

    public String forFillOutInner(InfoView infoView, InfoViewView infoViewView) throws WCMException {
        return this.forFillOutInner(infoView, infoViewView, false);
    }

    public String forFillOutInner(InfoView infoView, InfoViewView infoViewView, boolean bl) throws WCMException {
        return this.m_oInfoViewMgr.forFillOutInner(infoView, infoViewView, bl);
    }

    public String forFillOutInFlow(InfoView infoView, InfoViewView infoViewView, int n) throws WCMException, Throwable {
        return this.m_oInfoViewMgr.forFillOutInFlow(infoView, infoViewView, n);
    }

    public String filterContentInFlow(InfoView infoView, String string, int n) throws WCMException, Throwable {
        return this.m_oInfoViewMgr.filterContentInFlow(infoView, string, n);
    }

    public InfoViews getInfoViews(WCMFilter wCMFilter) throws WCMException {
        return this.m_oInfoViewMgr.getInfoViews(wCMFilter);
    }

    public List getInfoViewEmployers(InfoView infoView) throws WCMException {
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label9", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u83b7\u53d6\u5176\u4f7f\u7528\u4f4d\u7f6e!"));
        }
        return this.m_oIVEmployMgr.getInfoViewEmployers(infoView);
    }

    public List getInfoViewEmployers(int n) throws WCMException {
        InfoView infoView = this.findById(n);
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label10", "\u6307\u5b9a\u7684\u8868\u5355\u4e0d\u5b58\uff0cID=[") + n + "]");
        }
        return this.getInfoViewEmployers(infoView);
    }

    public List getEmployedInfoViews(CMSObj cMSObj) throws WCMException {
        return this.m_oIVEmployMgr.getEmployedInfoViews(cMSObj);
    }

    public List getEmployedInfoViews(int n, int n2) throws WCMException {
        return this.m_oIVEmployMgr.getEmployedInfoViews(n, n2);
    }

    public void save(InfoView infoView) throws WCMException {
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label1", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u5220\u9664!"));
        }
        try {
            this.m_oInfoViewMgr.save(infoView);
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(InfoViewService.class, "InfoViewService.label11", "\u4fee\u6539\u8868\u5355\u51fa\u9519!"), wCMException);
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(InfoViewService.class, "InfoViewService.label11", "\u4fee\u6539\u8868\u5355\u51fa\u9519!"), exception);
        }
    }

    public void rebuildXSLT(InfoView infoView) throws WCMException {
        this.m_oInfoViewMgr.rebuildXSLT(infoView);
    }

    public void rebuildXSLTByFields(InfoView infoView, List list) throws WCMException {
        this.m_oInfoViewMgr.rebuildXSLTByFields(infoView, list);
    }

    public void saveViewByFields(InfoView infoView, List list) throws WCMException {
        this.m_oInfoViewMgr.saveViewByFields(infoView, list);
    }

    public void save(InfoViewField infoViewField) throws WCMException {
        this.m_oInfoViewMgr.save(infoViewField);
    }

    public void save(InfoViewGroup infoViewGroup) throws WCMException {
        this.m_oInfoViewMgr.save(infoViewGroup);
    }

    public void save(InfoViewView infoViewView) throws WCMException {
        this.m_oInfoViewMgr.save(infoViewView);
    }

    public void setEmployedInfoView(CMSObj cMSObj, InfoView infoView) throws WCMException {
        if (cMSObj == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label12", "\u9891\u9053\u5bf9\u8c61\u4e3a[null]!"));
        }
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label13", "\u8868\u5355\u5bf9\u8c61\u4e3a[null]!"));
        }
        this.m_oIVEmployMgr.setEmployedInfoView(cMSObj, infoView.getId());
    }

    public void setEmployedInfoViews(CMSObj cMSObj, String string) throws WCMException {
        if (cMSObj == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label12", "\u9891\u9053\u5bf9\u8c61\u4e3a[null]!"));
        }
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label14", "\u8868\u5355ID\u5217\u8868\u4e3a[null]!"));
        }
        if ((string = string.trim()).length() == 0) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label15", "\u8868\u5355ID\u5217\u8868\u4e3a\u7a7a!"));
        }
        int[] nArray = CMyString.splitToInt(string, ",");
        if (nArray.length < 1) {
            throw new WCMException(10, I18NMessage.get(InfoViewService.class, "InfoViewService.label16", "\u8868\u5355ID\u5217\u8868\u4e2d\u6ca1\u6709\u6709\u6548\u7684ID!"));
        }
        this.m_oIVEmployMgr.setEmployedInfoViews(cMSObj, nArray);
    }

    public List getAppendixList(Document document) throws WCMException {
        List list = document.selectNodes("//@trs_is_inline_file");
        List list2 = this.processAppendix(list, 10);
        List list3 = document.selectNodes("//@trs_is_inline_image");
        List list4 = this.processAppendix(list3, 20);
        List list5 = document.selectNodes("//@trs_is_linked_image");
        List list6 = this.processAppendix(list5, 40);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list2);
        arrayList.addAll(list4);
        arrayList.addAll(list6);
        return arrayList;
    }

    private List processAppendix(List list, int n) throws WCMException {
        ArrayList<Appendix> arrayList = new ArrayList<Appendix>(list.size());
        Node node = null;
        String string = null;
        Appendix appendix = null;
        for (int i = 0; i < list.size(); ++i) {
            node = (Node)list.get(i);
            string = node.getParent().getTextTrim();
            node.detach();
            appendix = new Appendix();
            appendix.setFlag(n);
            appendix.setSrcFile(string);
            appendix.setFile(string);
            arrayList.add(appendix);
        }
        return arrayList;
    }

    public List getAppendixList(String string) throws WCMException {
        try {
            Document document = DocumentHelper.parseText((String)string);
            return this.getAppendixList(document);
        }
        catch (DocumentException documentException) {
            throw new WCMException(150, I18NMessage.get(InfoViewService.class, "InfoViewService.label17", "\u89e3\u91caXML\u5b57\u7b26\u5931\u8d25!"), documentException);
        }
    }

    public String getDocumentTitle(InfoView infoView, Document document) throws WCMException {
        return this.m_oInfoViewMgr.getDocumentTitle(infoView, document);
    }

    public String getDocumentTitle(InfoView infoView, String string) throws WCMException {
        return this.getDocumentTitle(infoView, this.getDOM4JDocument(string));
    }

    public String getDocumentTitle(InfoView infoView, Document document, String string) throws WCMException {
        return this.m_oInfoViewMgr.getDocumentTitle(infoView, document, string);
    }

    public String getDocumentTitle(InfoView infoView, String string, String string2) throws WCMException {
        return this.getDocumentTitle(infoView, this.getDOM4JDocument(string), string2);
    }

    public Document getDOM4JDocument(String string) throws WCMException {
        try {
            StringReader stringReader = new StringReader(string);
            SAXReader sAXReader = new SAXReader();
            return sAXReader.read((Reader)stringReader);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(InfoViewService.class, "InfoViewService.label18", "\u6784\u9020DOM4J\u5bf9\u8c61\u5931\u8d25"), exception);
        }
    }

    public String getInfoViewSerial(int n) throws WCMException {
        return this.m_oInfoViewMgr.getInfoViewSerial(n);
    }

    public String getInfoViewSerial(InfoView infoView) throws WCMException {
        return this.m_oInfoViewMgr.getInfoViewSerial(infoView);
    }

    public void sendReplyNotice(int n, int n2, int n3, boolean bl, boolean bl2) throws WCMException {
        InfoView infoView = InfoView.findById(n);
        com.trs.components.wcm.content.persistent.Document document = com.trs.components.wcm.content.persistent.Document.findById(n2);
        DocReply docReply = DocReply.findById(n3);
        this.sendReplyNotice(infoView, document, docReply, bl, bl2);
    }

    public void sendReplyNotice(InfoView infoView, com.trs.components.wcm.content.persistent.Document document, DocReply docReply, boolean bl, boolean bl2) throws WCMException {
        InfoViewReplyNoticeSender infoViewReplyNoticeSender = new InfoViewReplyNoticeSender(infoView, document, docReply);
        infoViewReplyNoticeSender.setSendEmail(bl);
        infoViewReplyNoticeSender.setSendMessage(bl2);
        infoViewReplyNoticeSender.sendNotice();
    }

    public void setFieldsReadOnly(InfoView infoView, InfoViewFields infoViewFields, boolean bl) throws WCMException {
        this.m_oInfoViewMgr.setFieldsReadOnly(infoView, infoViewFields, bl);
    }
}

