/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.domain.GrpUserIdsMan;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyString;
import com.trs.service.IGroupService;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class GroupService
implements IGroupService {
    private static Logger m_oLogger = Logger.getLogger((String)GroupService.class.getName());

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public boolean addUser(User user, Group group) throws WCMException {
        if (this.getLoginUser() == null) {
            throw new WCMException(20, I18NMessage.get(GroupService.class, "GroupService.label1", "\u767b\u5f55\u7528\u6237\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6dfb\u52a0\u7528\u6237\uff01"));
        }
        if (group == null) {
            throw new WCMException(20, I18NMessage.get(GroupService.class, "GroupService.label2", "\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6dfb\u52a0\u7528\u6237\uff01"));
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)group, 13)) {
            throw new WCMException(1002, I18NMessage.get(GroupService.class, "GroupService.label3", "\u60a8\u6682\u65f6\u65e0\u6743\u5728\u7ec4\u7ec7\u4e2d\u6dfb\u52a0\u7528\u6237\uff01"));
        }
        String string = CMyString.format(I18NMessage.get(GroupService.class, "GroupService.label37", "\u5411{0}\u6dfb\u52a0{1}"), new String[]{group.toString(), user.toString()});
        long l = LogServer.startRecord(this.getLoginUserName(), "GROUPUSER_ADD", string, group);
        try {
            this.getGroupMgr().addUser(user, group);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(GroupService.class, "GroupService.label6", "\u5f80\u7ec4\u7ec7\u6dfb\u52a0\u7528\u6237\u5931\u8d25!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return true;
    }

    public boolean removeUser(User user, Group group) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)group, 14)) {
            throw new WCMException(1002, I18NMessage.get(GroupService.class, "GroupService.label7", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5220\u9664\u7ec4\u4e2d\u7684\u7528\u6237"));
        }
        String string = CMyString.format(I18NMessage.get(GroupService.class, "GroupService.label38", "\u5220\u9664{0}\u7684\u7528\u6237{1}"), new String[]{group.toString(), user.toString()});
        long l = LogServer.startRecord(this.getLoginUserName(), "GROUPUSER_DEL", string, user);
        try {
            this.getGroupMgr().removeUser(user, group);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(GroupService.class, "GroupService.label10", "\u4ece\u7ec4\u7ec7\u4e2d\u5220\u9664\u7528\u6237\u5931\u8d25!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return true;
    }

    public boolean removeUser(User user, Group group, boolean bl) throws WCMException {
        if (group == null) {
            return false;
        }
        if (!bl) {
            return this.removeUser(user, group);
        }
        Groups groups = user.getGroups();
        String string = groups.getIdListAsString();
        String string2 = this.getGroupMgr().getOffspringGroupIds(String.valueOf(group.getId()), true);
        String[] stringArray = string2.split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        string = "," + string + ",";
        for (int i = 0; i < stringArray.length; ++i) {
            if (CMyString.isEmpty(stringArray[i]) || string.indexOf("," + stringArray[i] + ",") == -1) continue;
            arrayList.add(stringArray[i]);
        }
        Groups groups2 = Groups.findByIds(this.getLoginUser(), CMyString.join(arrayList, ","));
        boolean bl2 = true;
        for (int i = 0; i < groups2.size(); ++i) {
            Group group2 = (Group)groups2.getAt(i);
            if (group2 == null) continue;
            bl2 = this.removeUser(user, group2) && bl2;
        }
        return bl2;
    }

    public Users getUsers(Group group, WCMFilter wCMFilter) throws WCMException {
        return this.getGroupMgr().getUsers(group, wCMFilter);
    }

    public Users getUsers(Group group, WCMFilter wCMFilter, boolean bl) throws WCMException {
        return this.getGroupMgr().getUsers(group, wCMFilter, bl);
    }

    public boolean moveUser(User user, Group group, Group group2) throws WCMException {
        if (this.getLoginUser() == null || !this.getLoginUser().isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(GroupService.class, "GroupService.label11", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u66f4\u6539\u7528\u6237\u6240\u5c5e\u7684\u7ec4\u7ec7!"));
        }
        String string = CMyString.format(I18NMessage.get(GroupService.class, "GroupService.label39", "\u53d8\u66f4{0}\u7684\u7ec4\u7ec7\u4ece{1}\u5230{2}"), new Object[]{user, group, group2});
        long l = LogServer.startRecord(this.getLoginUserName(), "USER_MOVE", string, user);
        try {
            this.getGroupMgr().moveUser(user, group, group2);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(GroupService.class, "GroupService.label16", "\u6539\u53d8\u7528\u6237\u7684\u7ec4\u7ec7\u5931\u8d25!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return true;
    }

    public boolean moveUser(User user, Group group, Groups groups) throws WCMException {
        if (groups == null || groups.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(GroupService.class, "GroupService.label17", "\u6ca1\u6307\u5b9a\u6709\u6548\u7684\u76ee\u6807\u7ec4\u7ec7,\u65e0\u6cd5\u5b8c\u6210\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u7684\u66f4\u6539!"));
        }
        Group group2 = null;
        for (int i = 0; i < groups.size(); ++i) {
            group2 = (Group)groups.getAt(i);
            if (group2 == null) continue;
            this.moveUser(user, group, group2);
        }
        return true;
    }

    public boolean addManager(User user, Group group) throws WCMException {
        String string = CMyString.format(I18NMessage.get(GroupService.class, "GroupService.label40", "\u6307\u5b9a{0}\u4e3a{1}\u7684\u7ba1\u7406\u5458"), new Object[]{user, group});
        long l = LogServer.startRecord(this.getLoginUserName(), "GROUPUSER_ADMINADD", string, group);
        try {
            this.setManager(user, group, true);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(GroupService.class, "GroupService.label21", "\u6307\u5b9a\u7ec4\u7ba1\u7406\u5458\u5931\u8d25!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return true;
    }

    private String getLoginUserName() {
        return this.getLoginUser().getName();
    }

    public boolean removeManager(User user, Group group) throws WCMException {
        String string = CMyString.format(I18NMessage.get(GroupService.class, "GroupService.label41", "\u53d6\u6d88{0}\u5728{1}\u4e2d\u7684\u7ba1\u7406\u5458\u8eab\u4efd"), new Object[]{user, group});
        long l = LogServer.startRecord(this.getLoginUserName(), "GROUPUSER_ADMINDEL", string, group);
        try {
            this.setManager(user, group, false);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(GroupService.class, "GroupService.label25", "\u53d6\u6d88\u7ec4\u7ba1\u7406\u5458!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return true;
    }

    private boolean setManager(User user, Group group, boolean bl) throws WCMException {
        if (this.getLoginUser() == null || !AuthServer.hasRight(this.getLoginUser(), group)) {
            throw new WCMException(1002, I18NMessage.get(GroupService.class, "GroupService.label26", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u6307\u5b9a\u7ec4\u7ba1\u7406\u5458!"));
        }
        return this.getGroupMgr().setGroupManager(user, group, bl);
    }

    public Groups getChildren(Group group) throws WCMException {
        return this.getGroupMgr().getChildren(group);
    }

    public Groups getChildren(Group group, boolean bl) throws WCMException {
        return this.getChildren(group, bl, null);
    }

    public Groups getChildren(Group group, boolean bl, WCMFilter wCMFilter) throws WCMException {
        if (!bl) {
            return this.getGroupMgr().getChildren(group, wCMFilter);
        }
        return this.getGroupMgr().getOffspringGroups(group, false, wCMFilter);
    }

    public boolean delete(int n) throws WCMException {
        Group group = Group.findById(n);
        if (group == null) {
            throw new WCMException(200006, I18NMessage.get(GroupService.class, "GroupService.label27", "\u6ca1\u627e\u5230\u7ec4\u7ec7[") + n + "]");
        }
        return this.delete(group);
    }

    public boolean delete(String string) throws WCMException {
        Groups groups = Groups.findByIds(this.getLoginUser(), string);
        if (groups.isEmpty()) {
            throw new WCMException(200006, I18NMessage.get(GroupService.class, "GroupService.label28", "\u6ca1\u6709\u627e\u5230\u8981\u5220\u9664\u7684\u7ec4\u7ec7!"));
        }
        return this.delete(groups);
    }

    public boolean delete(Groups groups) throws WCMException {
        if (groups == null || groups.isEmpty()) {
            throw new WCMException(20, I18NMessage.get(GroupService.class, "GroupService.label29", "\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        Groups groups2 = groups;
        for (int i = 0; i < groups2.size(); ++i) {
            Group group = (Group)groups2.getAt(i);
            if (group != null) {
                this.delete(group);
                continue;
            }
            m_oLogger.error((Object)I18NMessage.get(GroupService.class, "GroupService.label30", "\u53d6\u7ec4\u7ec7\u96c6\u5408\u4e2d\u7684\u7ec4\u7ec7\u65f6\u4e3a\u7a7a\uff01"));
        }
        return true;
    }

    public boolean delete(Group group) throws WCMException {
        if (group == null) {
            throw new WCMException(20, I18NMessage.get(GroupService.class, "GroupService.label29", "\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        Group group2 = group;
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)group2, 12)) {
            throw new WCMException(1002, I18NMessage.get(GroupService.class, "GroupService.label31", "\u60a8\u65e0\u6743\u5220\u9664\u7ec4\u7ec7\uff01"));
        }
        String string = I18NMessage.get(GroupService.class, "GroupService.label42", "\u5220\u9664") + "[" + group + "]";
        long l = LogServer.startRecord(this.getLoginUserName(), "GROUP_DEL", string, group);
        try {
            this.getGroupMgr().delete(group2);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(GroupService.class, "GroupService.label32", "\u5220\u9664\u7ec4\u7ec7\u5931\u8d25!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return true;
    }

    public Group save(Group group) throws WCMException {
        Group group2 = group;
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)group2, 11)) {
            throw new WCMException(1002, I18NMessage.get(GroupService.class, "GroupService.label33", "\u60a8\u65e0\u6743\u4fdd\u5b58\u7ec4\u7ec7\uff01"));
        }
        String string = I18NMessage.get(GroupService.class, "GroupService.label43", "\u4fdd\u5b58") + "[" + group + "]";
        String string2 = "GROUP_ADD";
        if (!group.isAddMode()) {
            string2 = "GROUP_EDIT";
        }
        long l = LogServer.startRecord(this.getLoginUserName(), string2, string, group);
        try {
            group2 = this.getGroupMgr().save(group2);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(GroupService.class, "GroupService.label35", "\u4fdd\u5b58\u7ec4\u7ec7\u5931\u8d25!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return group2;
    }

    public Group moveTo(Group group, Group group2) {
        throw new UnsupportedOperationException(I18NMessage.get(GroupService.class, "GroupService.label36", "\u65b9\u6cd5\u672a\u5b9e\u73b0"));
    }

    public Users getAdmins(Group group) throws WCMException {
        return this.getGroupMgr().getAdmins(group);
    }

    private GroupMgr getGroupMgr() {
        return (GroupMgr)DreamFactory.createObjectById("GroupMgr");
    }

    public boolean setGroupUsers(int n, String string) throws WCMException {
        GrpUserIdsMan grpUserIdsMan = new GrpUserIdsMan(n);
        grpUserIdsMan.dowithIds(string);
        return true;
    }
}

