/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service;

import com.trs.cms.auth.persistent.User;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InfoViewContext {
    private int m_nChannelId = 0;
    private int m_nDocumentId = 0;
    private int m_nInfoViewId = 0;
    private int m_nFlowId = 0;
    private User m_oUser;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private static InfoViewContext currInstance;

    private InfoViewContext() {
    }

    public InfoViewContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        currInstance = InfoViewContext.create(httpServletRequest, httpServletResponse);
    }

    public static InfoViewContext create(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        InfoViewContext infoViewContext = new InfoViewContext();
        infoViewContext.request = httpServletRequest;
        infoViewContext.response = httpServletResponse;
        return infoViewContext;
    }

    public static InfoViewContext getCurrentInfoViewContext() {
        if (currInstance == null) {
            currInstance = new InfoViewContext();
        }
        return currInstance;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public int getChannelId() {
        return this.m_nChannelId;
    }

    public Channel getChannel() throws WCMException {
        return Channel.findById(this.getChannelId());
    }

    public void setChannelId(int n) {
        this.m_nChannelId = n;
    }

    public int getDocumentId() {
        return this.m_nDocumentId;
    }

    public Document getDocument() throws WCMException {
        return Document.findById(this.getDocumentId());
    }

    public void setDocumentId(int n) {
        this.m_nDocumentId = n;
    }

    public int getFlowId() {
        return this.m_nFlowId;
    }

    public void setFlowId(int n) {
        this.m_nFlowId = n;
    }

    public int getInfoViewId() {
        return this.m_nInfoViewId;
    }

    public InfoView getInfoView() throws WCMException {
        return InfoView.findById(this.getInfoViewId());
    }

    public void setInfoViewId(int n) {
        this.m_nInfoViewId = n;
    }

    public User getUser() {
        return this.m_oUser;
    }

    public void setUser(User user) {
        this.m_oUser = user;
    }

    public static void main(String[] stringArray) {
    }
}

