/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.wcm.content;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.resource.Status;
import com.trs.components.wcm.resource.Statuses;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.presentation.util.RequestHelper;
import com.trs.service.IChannelService;
import com.trs.service.IDocumentService;
import com.trs.service.IUserService;
import com.trs.service.ServiceHelper;

public class DocumentsPageHelper {
    private static final int[] DEFAULT_RIGHT_INDEXES = new int[]{18, 31, 32, 33, 34, 80, 39, 38, WCMRightTypes.DOC_MOVE, 61, 30};
    private int[] RIGHT_INDEXES = null;
    private static final int DOCUMENT_LIST_OF_CHANNEL = 1;
    private static final int DOCUMENT_LIST_OF_SITE = 2;
    private static final int DOCUMENT_LIST_OF_USER = 3;
    private static final int DOCUMENT_LIST_OF_RECYCLE = 4;
    private int m_nPageType = 0;
    private BaseChannel m_oBaseChannel = null;
    private Channel m_oChannelHost = null;
    private WebSite m_oWebSite = null;
    private RequestHelper m_oRequestHelper = null;
    IChannelService m_oChannelService = null;
    IDocumentService m_oDocumentService = null;
    IUserService m_oUserService = null;
    User loginUser = null;
    private String m_sLogicRightValue = null;
    private Documents m_oDocuments = null;
    IPublishFolder m_oChnlPublishElement = null;

    private void init(User user, RequestHelper requestHelper) throws WCMException {
        int n;
        Statuses statuses = Statuses.openWCMObjs(user, null);
        Status status = null;
        int n2 = DEFAULT_RIGHT_INDEXES.length;
        this.RIGHT_INDEXES = new int[n2 + statuses.size()];
        for (n = 0; n < n2; ++n) {
            this.RIGHT_INDEXES[n] = DEFAULT_RIGHT_INDEXES[n];
        }
        for (n = 0; n < statuses.size(); ++n) {
            status = (Status)statuses.getAt(n);
            this.RIGHT_INDEXES[n2 + n] = status == null || status.getRightIndex() == 0 || !status.isUsed() ? -1 : status.getRightIndex();
        }
        this.loginUser = user;
        this.m_oRequestHelper = requestHelper;
        if (this.m_nPageType != 3) {
            this.m_oChannelService = ServiceHelper.createChannelService();
            this.m_oDocumentService = ServiceHelper.createDocumentService();
        }
    }

    public DocumentsPageHelper(User user, RequestHelper requestHelper, Channel channel) throws WCMException {
        this.m_nPageType = 1;
        this.m_oChannelHost = channel;
        this.init(user, requestHelper);
    }

    public DocumentsPageHelper(User user, RequestHelper requestHelper, WebSite webSite) throws WCMException {
        this.m_nPageType = 2;
        this.m_oWebSite = webSite;
        this.init(user, requestHelper);
    }

    public DocumentsPageHelper(User user, RequestHelper requestHelper) throws WCMException {
        this.m_nPageType = 3;
        this.m_oUserService = ServiceHelper.createUserService();
        this.init(user, requestHelper);
    }

    public DocumentsPageHelper(User user, RequestHelper requestHelper, BaseChannel baseChannel) throws WCMException {
        this.m_nPageType = 4;
        this.m_oBaseChannel = baseChannel;
        this.init(user, requestHelper);
    }

    public void doForwardIfNeed() throws Exception {
        String string;
        if (this.m_oChannelHost == null) {
            return;
        }
        if (this.m_oChannelHost.isLink()) {
            this.m_oRequestHelper.forward("../document/document_list_of_linkchannel.jsp");
        }
        if (!(string = CMyString.showNull(this.m_oChannelHost.getPropertyAsString("ContentListPage"))).equals("") && !string.equals("../document/document_list_of_channel.jsp")) {
            string = string + "?" + CMyString.filterForUrl(this.m_oRequestHelper.toURLParameters());
            this.m_oRequestHelper.forward("../tools/custom_page_redirect.jsp?RedirectUrl=" + string);
        }
    }

    public Documents getDocuments(String string, String string2) throws WCMException {
        if (this.m_oDocuments != null) {
            return this.m_oDocuments;
        }
        return this.getDocuments(new WCMFilter("", "", string, string2));
    }

    private Documents getDocuments(WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = this.m_oRequestHelper.getPageFilter(wCMFilter);
        switch (this.m_nPageType) {
            case 1: {
                this.m_oDocuments = this.m_oChannelService.getDocuments(this.m_oChannelHost, wCMFilter2);
                break;
            }
            case 2: {
                this.m_oDocuments = this.m_oChannelService.getDocuments(this.m_oWebSite, wCMFilter2);
                break;
            }
            case 3: {
                this.m_oDocuments = this.m_oUserService.getDocuments(wCMFilter2);
                break;
            }
            case 4: {
                this.m_oDocuments = this.m_oChannelService.getRecycleDocuments(this.m_oBaseChannel, wCMFilter2);
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(DocumentsPageHelper.class, "DocumentsPageHelper.label1", "[DocumentsPageHelper.getDocuments] \u4f20\u5165\u65e0\u6548\u7684\u9875\u9762\u7c7b\u578b[") + this.m_nPageType + "]");
            }
        }
        return this.m_oDocuments;
    }

    public String getLogicRightValue() throws WCMException {
        if (this.m_sLogicRightValue != null) {
            return this.m_sLogicRightValue;
        }
        switch (this.m_nPageType) {
            case 1: {
                this.m_sLogicRightValue = AuthServer.getLogicalRightValue(this.m_oChannelHost, this.loginUser, this.RIGHT_INDEXES);
                break;
            }
            case 2: {
                this.m_sLogicRightValue = AuthServer.getLogicalRightValue(this.m_oWebSite, this.loginUser, this.RIGHT_INDEXES);
                break;
            }
            case 3: {
                this.m_sLogicRightValue = "1";
                break;
            }
            case 4: {
                this.m_sLogicRightValue = "0";
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(DocumentsPageHelper.class, "DocumentsPageHelper.label2", "[DocumentsPageHelper.getLogicRightValue] \u4f20\u5165\u65e0\u6548\u7684\u9875\u9762\u7c7b\u578b[") + this.m_nPageType + "]");
            }
        }
        return this.m_sLogicRightValue;
    }

    public String getLogicRightValue(Document document) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentsPageHelper.class, "DocumentsPageHelper.label3", "[DocumentsPageHelper.getLogicRightValue]\u4f20\u5165\u7a7a\u7684\u6587\u6863\u5bf9\u8c61\uff01"));
        }
        String string = null;
        string = AuthServer.getLogicalRightValue(document, this.loginUser, this.RIGHT_INDEXES);
        return DocumentAuthServer.formatLogicRightValue(this.loginUser, document, string);
    }

    public boolean canDoAddDoc() throws WCMException {
        switch (this.m_nPageType) {
            case 1: {
                if (!this.m_oChannelHost.isNormType() && this.m_oChannelHost.getType() != 13) {
                    return false;
                }
                return this.hasRight(31);
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return false;
            }
        }
        throw new WCMException(10, I18NMessage.get(DocumentsPageHelper.class, "DocumentsPageHelper.label4", "[DocumentsPageHelper.canDoAddDoc] \u4f20\u5165\u65e0\u6548\u7684\u9875\u9762\u7c7b\u578b[") + this.m_nPageType + "]");
    }

    public boolean canDoPub() throws WCMException {
        if (!this.hasRight(39)) {
            return false;
        }
        switch (this.m_nPageType) {
            case 1: {
                return this.getChnlPublishElement().isValidElement();
            }
            case 2: {
                return ((IPublishFolder)PublishElementFactory.makeElementFrom(this.m_oWebSite)).isValidElement();
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        throw new WCMException(10, I18NMessage.get(DocumentsPageHelper.class, "DocumentsPageHelper.label5", "[DocumentsPageHelper.canDoPub] \u4f20\u5165\u65e0\u6548\u7684\u9875\u9762\u7c7b\u578b[") + this.m_nPageType + "]");
    }

    public boolean canDoOperteOnNotEmpty(int n) throws WCMException {
        return this.hasRight(n);
    }

    public boolean hasRight(int n) throws WCMException {
        if (this.getLogicRightValue().length() == 1) {
            return this.getLogicRightValue().charAt(0) == '1';
        }
        if (n >= this.getLogicRightValue().length()) {
            return false;
        }
        return this.getLogicRightValue().charAt(this.getLogicRightValue().length() - n - 1) == '1';
    }

    public Channel getDocChannel(Document document) throws WCMException {
        if (this.m_oChannelHost != null && document.getChannelId() == this.m_oChannelHost.getId()) {
            return this.m_oChannelHost;
        }
        return document.getChannel();
    }

    public boolean hasRight(int n, Document document) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentsPageHelper.class, "DocumentsPageHelper.label6", "[DocumentsPageHelper.hasRight]\u4f20\u5165\u7a7a\u7684\u6587\u6863\u5bf9\u8c61\uff01"));
        }
        if (this.loginUser.equals(document.getCrUser())) {
            return true;
        }
        return AuthServer.hasRight(this.loginUser, (CMSObj)document, n);
    }

    public boolean canDoPreview(Document document) throws WCMException {
        IPublishContent iPublishContent = null;
        switch (this.m_nPageType) {
            case 1: {
                if (!this.hasRight(38, document)) {
                    return false;
                }
                iPublishContent = PublishElementFactory.makeContentFrom(document, this.getChnlPublishElement());
                break;
            }
            case 2: {
                if (!this.hasRight(38, document)) {
                    return false;
                }
            }
            case 3: {
                this.m_oChnlPublishElement = (IPublishFolder)PublishElementFactory.makeElementFrom(this.getDocChannel(document));
                iPublishContent = PublishElementFactory.makeContentFrom(document, this.m_oChnlPublishElement);
                break;
            }
            case 4: {
                return false;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(DocumentsPageHelper.class, "DocumentsPageHelper.label7", "[DocumentsPageHelper.canDoPreview] \u4f20\u5165\u65e0\u6548\u7684\u9875\u9762\u7c7b\u578b[") + this.m_nPageType + "]");
            }
        }
        return iPublishContent.canDoPreview();
    }

    private IPublishFolder getChnlPublishElement() throws WCMException {
        if (this.m_oChnlPublishElement == null) {
            this.m_oChnlPublishElement = (IPublishFolder)PublishElementFactory.makeElementFrom(this.m_oChannelHost);
        }
        return this.m_oChnlPublishElement;
    }

    public static void main(String[] stringArray) {
        String string = "1011111110000000000001000000000000000000";
        System.out.println(string.charAt(string.length() - 31 - 1) == '1');
    }
}

