/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.presentation.util.PageParameter;
import com.trs.presentation.util.PageParameters;
import com.trs.presentation.util.RequestHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class WhereSQLMaker {
    private static Logger logger = Logger.getLogger(WhereSQLMaker.class);
    public static final int TYPE_STRING_HASHCODE = -891985903;
    public static final int TYPE_INT_HASHCODE = 104431;
    public static final int TYPE_LONG_HASHCODE = 3327612;
    public static final int TYPE_FLOAT_HASHCODE = 97526364;
    public static final int TYPE_DOUBLE_HASHCODE = -1325958191;
    public static final int TYPE_DATE_HASHCODE = 3076014;
    public static final int TYPE_TIME_HASHCODE = 3560141;
    public static final int TYPE_DATETIME_HASHCODE = 1793702779;
    public static final int TYPE_BOOLEAN_HASHCODE = 64711720;
    PageParameters m_oPageParameters = null;
    private String m_sWhereSQL = null;
    private List m_listSearchValues = null;

    public WhereSQLMaker(PageParameters pageParameters) {
        this.m_oPageParameters = pageParameters;
    }

    public void makeWhereSQL(RequestHelper requestHelper) throws WCMException {
        if (this.m_oPageParameters == null) {
            return;
        }
        String string = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = this.m_oPageParameters.size();
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3;
            PageParameter pageParameter = (PageParameter)this.m_oPageParameters.get(i);
            if (pageParameter == null || !pageParameter.isSearch() || (string3 = requestHelper.getString(string2 = pageParameter.getName())) == null || (string3 = string3.trim()).length() == 0 || string3.equals(pageParameter.getExcludeValue())) continue;
            string = string != null ? string + " and (" : "(";
            if (pageParameter.getSearchField() != null) {
                string2 = pageParameter.getSearchField();
            }
            String string4 = this.getSearchOperator(pageParameter);
            String[] stringArray = null;
            stringArray = "datetime".equalsIgnoreCase(pageParameter.getType()) ? new String[]{string3} : CMyString.split(string3, " ");
            boolean bl = true;
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].length() <= 0) continue;
                if (!bl) {
                    string = string + " and ";
                }
                bl = false;
                string = string + string2 + " " + string4 + " ? ";
                try {
                    arrayList.add(this.getSearchValue(pageParameter, stringArray[j], string4));
                    continue;
                }
                catch (Exception exception) {
                    throw new WCMException(I18NMessage.get(WhereSQLMaker.class, "WhereSQLMaker.label1", "\u6784\u9020\u5b57\u6bb5[") + string2 + I18NMessage.get(WhereSQLMaker.class, "WhereSQLMaker.label2", "]\u7684\u67e5\u8be2\u5931\u8d25\uff01\u6570\u636e\u4e3a\uff1a") + string3, exception);
                }
            }
            string = string + ')';
        }
        this.setWhereSQL(string);
        this.setSearchValues(arrayList);
    }

    private String getSearchOperator(PageParameter pageParameter) {
        String string = pageParameter.getSearchOperator();
        if (string != null && (string = string.trim()).length() > 0) {
            return string;
        }
        int n = pageParameter.getType().hashCode();
        switch (n) {
            case -891985903: {
                return "like";
            }
        }
        return "=";
    }

    private Object getSearchValue(PageParameter pageParameter, String string, String string2) throws CMyException {
        int n = pageParameter.getType().hashCode();
        CMyDateTime cMyDateTime = null;
        switch (n) {
            case -891985903: {
                if (string2.equalsIgnoreCase("LIKE")) {
                    return "%" + string + "%";
                }
                return string;
            }
            case 3076014: {
                if (pageParameter.getSearchType() != null && pageParameter.getSearchType().equals("long")) {
                    return this.convertDateToLong(pageParameter, string, "yyyy-MM-dd");
                }
                cMyDateTime = new CMyDateTime();
                cMyDateTime.setDateTimeWithString(string, "yyyy-MM-dd");
                return cMyDateTime;
            }
            case 1793702779: {
                if (pageParameter.getSearchType() != null && pageParameter.getSearchType().equals("long")) {
                    return this.convertDateToLong(pageParameter, string, "yyyy-MM-dd HH:mm:ss");
                }
                cMyDateTime = new CMyDateTime();
                cMyDateTime.setDateTimeWithString(string, "yyyy-MM-dd HH:mm:ss");
                return cMyDateTime;
            }
            case 3560141: {
                cMyDateTime = new CMyDateTime();
                cMyDateTime.setDateTimeWithString(string, "HH:mm:ss");
                return cMyDateTime;
            }
            case 104431: 
            case 64711720: {
                return Integer.valueOf(string);
            }
            case 97526364: {
                return Float.valueOf(string);
            }
            case -1325958191: {
                return Double.valueOf(string);
            }
        }
        return string;
    }

    private Long convertDateToLong(PageParameter pageParameter, String string, String string2) {
        long l = 0L;
        CMyDateTime cMyDateTime = new CMyDateTime();
        try {
            cMyDateTime.setDateTimeWithString(string, string2);
            l = cMyDateTime.getTimeInMillis();
        }
        catch (Exception exception) {
            logger.error((Object)CMyString.format(I18NMessage.get(WhereSQLMaker.class, "WhereSQLMaker.label3", "\u67e5\u8be2\u4fe1\u606f[{0}]\u7684\u503c[{1}]\u4e0d\u662f\u65e5\u671f\u578b."), new String[]{pageParameter.getName(), string}), (Throwable)exception);
        }
        return new Long(l);
    }

    public List getSearchValues() {
        return this.m_listSearchValues;
    }

    private void setSearchValues(List list) {
        this.m_listSearchValues = list;
    }

    public String getWhereSQL() {
        return this.m_sWhereSQL;
    }

    private void setWhereSQL(String string) {
        this.m_sWhereSQL = string;
    }
}

