/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.presentation.util.Parameter;
import org.dom4j.Element;

public class PageParameter
extends Parameter {
    public static final String TYPE_STRING = "string";
    public static final String TYPE_INT = "int";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_TIME = "time";
    public static final String TYPE_DATETIME = "datetime";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final int TYPE_STRING_HASHCODE = -891985903;
    public static final int TYPE_INT_HASHCODE = 104431;
    public static final int TYPE_LONG_HASHCODE = 3327612;
    public static final int TYPE_FLOAT_HASHCODE = 97526364;
    public static final int TYPE_DOUBLE_HASHCODE = -1325958191;
    public static final int TYPE_DATE_HASHCODE = 3076014;
    public static final int TYPE_TIME_HASHCODE = 3560141;
    public static final int TYPE_DATETIME_HASHCODE = 1793702779;
    public static final int TYPE_BOOLEAN_HASHCODE = 64711720;
    public static final String[] TYPES_SUPPORTED = new String[]{"string", "int", "long", "float", "double", "date", "time", "datetime", "boolean"};
    private String m_sName;
    private String m_sDesc;
    private boolean m_bRequired;
    private String m_sType;
    private String m_sDefault;
    private int m_nMaxLength = -1;
    private int m_nMinLength = -1;
    private String m_sMaxValue;
    private String m_sMinValue;
    private boolean m_bSearch;
    private String m_sSearchOperator;
    private String m_sSearchField;
    private String m_sSearchType;
    private String m_sExcludeValue;

    public boolean isRequired() {
        return this.m_bRequired;
    }

    public void setRequired(boolean bl) {
        this.m_bRequired = bl;
    }

    public String getType() {
        if (this.m_sType == null) {
            return TYPE_STRING;
        }
        return this.m_sType;
    }

    public void setType(String string) throws WCMException {
        if (!this.isSupportedType(string)) {
            throw new WCMException(10, I18NMessage.get(PageParameter.class, "PageParameter.label1", "\u7c7b\u578b[") + string + I18NMessage.get(PageParameter.class, "PageParameter.label2", "]\u65e0\u6548!"));
        }
        this.m_sType = string.toLowerCase();
    }

    public String getDesc() {
        return this.m_sDesc;
    }

    public void setDesc(String string) {
        this.m_sDesc = string;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String string) {
        this.m_sName = string;
    }

    public int getMaxLength() {
        return this.m_nMaxLength;
    }

    public void setMaxLength(int n) {
        this.m_nMaxLength = n;
    }

    public int getMinLength() {
        return this.m_nMinLength;
    }

    public void setMinLength(int n) {
        this.m_nMinLength = n;
    }

    public String getDefault() {
        return this.m_sDefault;
    }

    public int getDefaultAsInt(int n) throws WCMException {
        if (this.getDefault() == null) {
            return n;
        }
        try {
            return Integer.parseInt(this.getDefault());
        }
        catch (Exception exception) {
            throw new WCMException(2, CMyString.format(I18NMessage.get(PageParameter.class, "PageParameter.label3", "\u53c2\u6570[{0}]\u7684\u9ed8\u8ba4\u503c[{1}]"), new String[]{this.getName(), this.getDefault()}) + I18NMessage.get(PageParameter.class, "PageParameter.label5", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u6574\u578b!"), exception);
        }
    }

    public long getDefaultAsLong(long l) throws WCMException {
        if (this.getDefault() == null) {
            return l;
        }
        try {
            return Long.parseLong(this.getDefault());
        }
        catch (Exception exception) {
            throw new WCMException(2, CMyString.format(I18NMessage.get(PageParameter.class, "PageParameter.label3", "\u53c2\u6570[{0}]\u7684\u9ed8\u8ba4\u503c[{1}]"), new String[]{this.getName(), this.getDefault()}) + I18NMessage.get(PageParameter.class, "PageParameter.label6", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u957f\u6574\u578b!"), exception);
        }
    }

    public float getDefaultAsFloat(float f) throws WCMException {
        if (this.getDefault() == null) {
            return f;
        }
        try {
            return Float.parseFloat(this.getDefault());
        }
        catch (Exception exception) {
            throw new WCMException(2, CMyString.format(I18NMessage.get(PageParameter.class, "PageParameter.label3", "\u53c2\u6570[{0}]\u7684\u9ed8\u8ba4\u503c[{1}]"), new String[]{this.getName(), this.getDefault()}) + I18NMessage.get(PageParameter.class, "PageParameter.label7", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u6d6e\u70b9\u6570!"), exception);
        }
    }

    public boolean getDefaultAsBoolean(boolean bl) throws WCMException {
        if (this.getDefault() == null) {
            return bl;
        }
        if ("true".equals(this.getDefault())) {
            return true;
        }
        if ("false".equals(this.getDefault())) {
            return true;
        }
        try {
            return this.getDefaultAsInt(0) == 1;
        }
        catch (Exception exception) {
            throw new WCMException(2, CMyString.format(I18NMessage.get(PageParameter.class, "PageParameter.label3", "\u53c2\u6570[{0}]\u7684\u9ed8\u8ba4\u503c[{1}]"), new String[]{this.getName(), this.getDefault()}) + I18NMessage.get(PageParameter.class, "PageParameter.label8", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u5e03\u5c14\u578b!"), exception);
        }
    }

    public double getDefaultAsDouble(double d) throws WCMException {
        if (this.getDefault() == null) {
            return d;
        }
        try {
            return Double.parseDouble(this.getDefault());
        }
        catch (Exception exception) {
            throw new WCMException(2, CMyString.format(I18NMessage.get(PageParameter.class, "PageParameter.label3", "\u53c2\u6570[{0}]\u7684\u9ed8\u8ba4\u503c[{1}]"), new String[]{this.getName(), this.getDefault()}) + I18NMessage.get(PageParameter.class, "PageParameter.label9", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u53cc\u7cbe\u5ea6\u6570!"), exception);
        }
    }

    public CMyDateTime getDefaultAsDateTime() throws WCMException {
        if (this.getDefault() == null) {
            return null;
        }
        try {
            CMyDateTime cMyDateTime = new CMyDateTime();
            cMyDateTime.setDateTimeWithString(this.getDefault());
            return cMyDateTime;
        }
        catch (Exception exception) {
            throw new WCMException(2, CMyString.format(I18NMessage.get(PageParameter.class, "PageParameter.label3", "\u53c2\u6570[{0}]\u7684\u9ed8\u8ba4\u503c[{1}]"), new String[]{this.getName(), this.getDefault()}) + I18NMessage.get(PageParameter.class, "PageParameter.label10", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u65f6\u95f4\u7c7b\u578b!"), exception);
        }
    }

    public void setDefault(String string) {
        this.m_sDefault = string;
    }

    public String getMaxValue() {
        return this.m_sMaxValue;
    }

    public void setMaxValue(String string) {
        this.m_sMaxValue = string;
    }

    public String getMinValue() {
        return this.m_sMinValue;
    }

    public void setMinValue(String string) {
        this.m_sMinValue = string;
    }

    protected void validXMLElement(Element element) throws WCMException {
        String string = element.attributeValue("name");
        if (string == null || (string = string.trim()).length() <= 0) {
            throw new WCMException(10, I18NMessage.get(PageParameter.class, "PageParameter.label11", "\u53c2\u6570\u6ca1\u6709\u6307\u5b9aName\u5c5e\u6027!"));
        }
        String string2 = element.attributeValue("desc");
        if (string2 == null || (string2 = string2.trim()).length() <= 0) {
            throw new WCMException(10, I18NMessage.get(PageParameter.class, "PageParameter.label12", "\u53c2\u6570\u6ca1\u6709\u6307\u5b9aDesc\u5c5e\u6027!"));
        }
    }

    public boolean fromXML(Element element) throws WCMException {
        super.fromXML(element);
        this.setDefault(this.getPropertyAsString("default"));
        this.setName(this.getPropertyAsString("name"));
        this.setDesc(this.getPropertyAsString("desc"));
        this.setType(this.getPropertyAsString("type"));
        this.setRequired("true".equals(this.getPropertyAsString("required")));
        this.setMaxLength(this.getPropertyAsInt("max-length", -1));
        this.setMinLength(this.getPropertyAsInt("min-length", -1));
        this.setMaxValue(this.getPropertyAsString("max-value"));
        this.setMinValue(this.getPropertyAsString("min-value"));
        this.setSearch("true".equals(this.getPropertyAsString("search")));
        this.setSearchOperator(this.getPropertyAsString("search-operator"));
        this.setSearchField(this.getPropertyAsString("search-field"));
        this.setSearchType(this.getPropertyAsString("search-type"));
        this.setExcludeValue(this.getPropertyAsString("exclude-value"));
        return true;
    }

    public static PageParameter createPageParameterFromXML(Element element) throws WCMException {
        PageParameter pageParameter = new PageParameter();
        pageParameter.fromXML(element);
        return pageParameter;
    }

    private boolean isSupportedType(String string) {
        for (int i = 0; i < TYPES_SUPPORTED.length; ++i) {
            if (!TYPES_SUPPORTED[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isSearch() {
        return this.m_bSearch;
    }

    public void setSearch(boolean bl) {
        this.m_bSearch = bl;
    }

    public String getSearchOperator() {
        return this.m_sSearchOperator;
    }

    public void setSearchOperator(String string) {
        this.m_sSearchOperator = string;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < TYPES_SUPPORTED.length; ++i) {
            String string = TYPES_SUPPORTED[i];
            System.out.println(string + ".hashCode:" + string.hashCode());
        }
    }

    public String getSearchField() {
        return this.m_sSearchField;
    }

    public void setSearchField(String string) {
        this.m_sSearchField = string;
    }

    public String getSearchType() {
        return this.m_sSearchType;
    }

    public void setSearchType(String string) {
        this.m_sSearchType = string;
    }

    public String getExcludeValue() {
        return this.m_sExcludeValue;
    }

    public void setExcludeValue(String string) {
        this.m_sExcludeValue = string;
    }
}

