/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.nav;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WebSiteHelper;
import com.trs.ajaxservice.xmlconvertors.ChannelToXML;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.ObjectMember;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.MyPlugin;
import com.trs.components.wcm.content.domain.SiteMemberMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.individuation.IndividuationMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyString;
import com.trs.presentation.locale.LocaleServer;
import com.trs.presentation.nav.TreeNodeCalctor;
import com.trs.presentation.plugin.PluginConfig;
import com.trs.presentation.util.RequestHelper;
import com.trs.service.IUserService;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.jsp.JspWriter;

public class TreeCreator {
    public static final int VIEW_TYPE_NORMAL = 1;
    public static final int VIEW_TYPE_RADIO = 2;
    public static final int VIEW_TYPE_CHECKBOX = 3;
    private User m_oLoginUser = null;
    private Channel m_oCurrChannel = null;
    private WebSite m_oCurrSite = null;
    private int m_nCurrSiteId = 0;
    private CMSObj m_oViewer = null;
    private CMSObj m_oOperator = null;
    private RequestHelper currRequestHelper = null;
    private JspWriter out = null;
    private String m_sDesc = null;
    private boolean m_bInRightSetPage = false;
    private boolean m_bForIndividual = false;
    private boolean m_bSelectMobile = false;
    private boolean m_bInViewOperSetPage = false;
    private boolean m_bGetAllChildren = false;
    private int m_nOperatorId;
    private int m_nOperatorType;
    private int[] m_pObjectTypes = null;
    private int[] m_pObjectIds = null;
    private int m_nRightIndex;
    private int m_nSiteType;
    private String m_sSiteTypes;
    boolean isView = false;
    boolean m_isFirstLevelCustomChannel = false;
    private boolean m_bLoadFromPath = false;
    private IObjectMemberMgr oObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
    private int[] m_pExcludeParentIds = null;
    private Channels m_oSelectedChannels = null;

    public TreeCreator(User user, RequestHelper requestHelper, JspWriter jspWriter) throws WCMException {
        this.m_oLoginUser = user;
        this.currRequestHelper = requestHelper;
        this.out = jspWriter;
        this.isView = requestHelper.getBoolean("isView", false);
        this.m_nOperatorId = requestHelper.getInt("OperatorId", 0);
        if (this.m_nOperatorId > 0) {
            this.m_nOperatorType = requestHelper.getInt("OperatorType", 0);
            this.m_oOperator = (CMSObj)BaseObj.findById(this.m_nOperatorType, this.m_nOperatorId);
            if (this.m_oOperator == null) {
                throw new WCMException(I18NMessage.get(TreeCreator.class, "TreeCreator.label1", "\u627e\u4e0d\u5230\u6307\u5b9a\u7684Operator[Type=") + this.m_nOperatorType + ",Id=" + this.m_nOperatorId + I18NMessage.get(TreeCreator.class, "TreeCreator.label2", "]\u6216\u8bb8\u88ab\u5220\u9664\uff1f"));
            }
            this.validLoginUserIsAdminOfOperator();
        } else {
            this.m_oOperator = this.m_oLoginUser;
        }
        this.m_oViewer = requestHelper.getBoolean("ViewerIsCurrUser", true) ? this.m_oLoginUser : this.m_oOperator;
        this.m_bForIndividual = requestHelper.getBoolean("forIndividual", false);
        this.m_bSelectMobile = requestHelper.getBoolean("SelectMobile", false);
        this.m_bInRightSetPage = requestHelper.getBoolean("InRightSetPage", false);
        this.m_nRightIndex = requestHelper.getInt("RightIndex", 64);
        this.m_nSiteType = requestHelper.getInt("SiteType", 0);
        this.m_sSiteTypes = requestHelper.getString("SiteTypes");
        this.m_bInViewOperSetPage = requestHelper.getBoolean("InViewOperSetPage", false);
        this.m_bGetAllChildren = requestHelper.getBoolean("GetAllChildren", false);
        boolean bl = this.currRequestHelper.getBoolean("FromSelect", false);
        if (bl) {
            int n;
            int n2 = this.currRequestHelper.getInt("CurrChannelId", 0);
            if (n2 > 0) {
                this.m_oCurrChannel = Channel.findById(n2);
                if (this.m_oCurrChannel == null) {
                    throw new WCMException(I18NMessage.get(TreeCreator.class, "TreeCreator.label3", "\u6307\u5b9a\u9891\u9053[") + n2 + I18NMessage.get(TreeCreator.class, "TreeCreator.label4", "]\u4e0d\u5b58\u5728\uff01"));
                }
                this.m_nCurrSiteId = this.m_oCurrChannel.getSiteId();
            }
            if ((n = this.currRequestHelper.getInt("CurrSiteId", 0)) <= 0) {
                n = this.currRequestHelper.getInt("ExpandSiteId", 0);
            }
            if (n > 0) {
                this.m_oCurrSite = WebSite.findById(n);
                if (this.m_oCurrSite == null) {
                    throw new WCMException(I18NMessage.get(TreeCreator.class, "TreeCreator.label5", "\u6307\u5b9a\u7ad9\u70b9[") + n + I18NMessage.get(TreeCreator.class, "TreeCreator.label4", "]\u4e0d\u5b58\u5728\uff01"));
                }
                this.m_nCurrSiteId = n;
            }
        }
    }

    public void writeTopChildrenHTML() throws Exception {
        this.m_sDesc = I18NMessage.get(TreeCreator.class, "TreeCreator.label6", "\u4ea7\u751f\u7b2c\u4e00\u7ea7\u5b50\u8282\u70b9\u7684HTML");
        String string = this.currRequestHelper.getString("ParentType");
        if (string == null || (string = string.trim()).length() == 0) {
            throw new WCMException(this.m_sDesc + I18NMessage.get(TreeCreator.class, "TreeCreator.label7", "\u5931\u8d25\uff1a\u6ca1\u6709\u6307\u5b9a\u7236\u7ed3\u70b9\u7684\u7c7b\u578b\uff01[ParentType]"));
        }
        int n = this.currRequestHelper.getInt("ParentId", 0);
        if (string.equalsIgnoreCase("r")) {
            this.writeSitesHTML(n);
            return;
        }
        if (string.equalsIgnoreCase("s")) {
            this.writeChannelsHTML(n, 0);
            return;
        }
        if (string.equalsIgnoreCase("c")) {
            this.writeChannelsHTML(0, n);
            return;
        }
        if (string.equalsIgnoreCase("i")) {
            this.m_isFirstLevelCustomChannel = true;
            this.writeCustomChannelsHTML(n);
            return;
        }
    }

    public void writeHTMLOfAPath() throws Exception {
        this.m_bLoadFromPath = true;
        this.m_sDesc = I18NMessage.get(TreeCreator.class, "TreeCreator.label8", "\u4ea7\u751f\u6307\u5b9a\u8def\u5f84\u7684HTML");
        String string = this.currRequestHelper.getString("NodeIds");
        if (string == null || (string = string.trim()).length() == 0) {
            throw new WCMException(this.m_sDesc + I18NMessage.get(TreeCreator.class, "TreeCreator.label9", "\u5931\u8d25\uff1a\u6ca1\u6709\u6307\u5b9a\u8def\u5f84\uff01[NodeIds]"));
        }
        String[] stringArray = string.split(",");
        this.extractNodeInfo(stringArray);
        this.writeLevelHTMLOfAPath(0);
    }

    public void writeHTMLContainsChannels() throws Exception {
        this.m_sDesc = I18NMessage.get(TreeCreator.class, "TreeCreator.label10", "\u4ea7\u751f\u5305\u542b\u6307\u5b9a\u680f\u76ee\u7684HTML");
        String string = this.currRequestHelper.getString("ChannelIds");
        if (string == null || (string = string.trim()).length() == 0) {
            throw new WCMException(this.m_sDesc + I18NMessage.get(TreeCreator.class, "TreeCreator.label11", "\u5931\u8d25\uff1a\u6ca1\u6709\u6307\u5b9a\u76f8\u5173\u7684\u9891\u9053ID\uff01[ChannelIds]"));
        }
        this.m_oSelectedChannels = Channels.findByIds(this.m_oLoginUser, string);
        int[] nArray = this.getSiteTypesOfChannels(string);
        this.m_nSiteType = nArray[0];
        if (this.m_nSiteType == -1) {
            throw new WCMException(this.m_sDesc + I18NMessage.get(TreeCreator.class, "TreeCreator.label12", "\u5931\u8d25\uff1a\u6ca1\u6709\u660e\u786e\u7ad9\u70b9\u7c7b\u578b\uff01[SiteType=") + this.m_nSiteType + "]");
        }
        TreeNodeCalctor treeNodeCalctor = new TreeNodeCalctor(string, this.m_oLoginUser);
        WebSites webSites = this.getWebSites(this.m_nSiteType);
        String string2 = this.makeTabContent(0);
        int n = webSites.size();
        for (int i = 0; i < n; ++i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            this.writeSingleNodeHTML(webSite, string2);
            List list = this.getChildren(webSite, 64);
            if (list == null || list.isEmpty()) continue;
            this.out.println(string2 + "<ul>");
            TreeNodeCalctor treeNodeCalctor2 = treeNodeCalctor.getExpandNodeById(webSite.getId());
            if (treeNodeCalctor2 != null) {
                this.writeHTMLContainsChannels(list, treeNodeCalctor2, 1);
            }
            this.out.println(string2 + "</ul>");
        }
        this.writeSelectedChannelsWithoutPriv();
    }

    protected void writeSelectedChannelsWithoutPriv() throws IOException, WCMException, Exception {
        if (!this.m_oSelectedChannels.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("<div id='selectedChnlsWithoutPriv' style='display:none'>");
            int n = this.m_oSelectedChannels.size();
            for (int i = 0; i < n; ++i) {
                Channel channel = (Channel)this.m_oSelectedChannels.getAt(i);
                if (channel == null) continue;
                stringBuffer.append("<span cid='");
                stringBuffer.append(channel.getId());
                stringBuffer.append("'>");
                stringBuffer.append(CMyString.transDisplay(channel.getDispDesc()));
                stringBuffer.append("</span>");
            }
            stringBuffer.append("</div>");
            this.out.println(stringBuffer.toString());
        }
    }

    private void writeHTMLContainsChannels(List list, TreeNodeCalctor treeNodeCalctor, int n) throws Exception {
        String string = this.makeTabContent(n);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Channel channel = (Channel)list.get(i);
            if (channel == null) continue;
            this.m_oSelectedChannels.remove(channel, false);
            this.writeSingleNodeHTML(channel, string);
            List list2 = this.getChildren(channel, 64);
            if (list2 == null || list2.isEmpty()) continue;
            TreeNodeCalctor treeNodeCalctor2 = treeNodeCalctor.getExpandNodeById(channel.getId());
            if (treeNodeCalctor2 != null) {
                this.out.println(string + "<ul>");
                this.writeHTMLContainsChannels(list2, treeNodeCalctor2, n + 1);
                this.out.println(string + "</ul>");
                continue;
            }
            this.out.println(string + "<ul></ul>");
        }
    }

    private void validLoginUserIsAdminOfOperator() throws WCMException {
        IUserService iUserService = (IUserService)DreamFactory.createObjectById("IUserService");
        if (this.m_oLoginUser.isAdministrator()) {
            return;
        }
        if (iUserService.isManagerOfRole(this.m_oLoginUser)) {
            return;
        }
        switch (this.m_oOperator.getWCMType()) {
            case 204: {
                User user = (User)this.m_oOperator;
                if (user.getId() == this.m_oLoginUser.getId() && this.isView) {
                    return;
                }
                Groups groups = user.getGroups();
                int n = groups.size();
                for (int i = 0; i < n; ++i) {
                    Group group = (Group)groups.getAt(i);
                    if (group == null || !this.isAdminOfGroup(this.m_oLoginUser, group)) continue;
                    return;
                }
                break;
            }
            case 201: {
                if (this.isAdminOfGroup(this.m_oLoginUser, (Group)this.m_oOperator)) {
                    return;
                }
            }
            case 203: {
                if (!this.m_oLoginUser.getName().equals(this.m_oOperator.getCrUserName())) break;
                return;
            }
        }
        throw new WCMException(I18NMessage.get(TreeCreator.class, "TreeCreator.label13", "\u7528\u6237[") + this.m_oLoginUser.getName() + I18NMessage.get(TreeCreator.class, "TreeCreator.label14", "]\u6ca1\u6709\u6743\u9650\u7ba1\u7406") + this.m_oOperator + "\uff01");
    }

    private boolean isAdminOfGroup(User user, Group group) throws WCMException {
        if (group == null) {
            return false;
        }
        if (group.isAdministrator(user)) {
            return true;
        }
        return this.isAdminOfGroup(user, group.getParent());
    }

    private void writeSitesHTML(int n) throws Exception {
        Object object;
        switch (n) {
            case 1: {
                if (PluginConfig.isStartPhoto()) break;
                this.out.println("<font color=\"red\"" + I18NMessage.get(TreeCreator.class, "TreeCreator.label15", ">\u60a8\u6ca1\u6709\u8d2d\u4e70\u56fe\u7247\u9009\u4ef6\uff01</font>"));
                return;
            }
            case 2: {
                if (PluginConfig.isStartVideo()) break;
                this.out.println("<font color=\"red\"" + I18NMessage.get(TreeCreator.class, "TreeCreator.label16", ">\u60a8\u6ca1\u6709\u8d2d\u4e70\u6d41\u5a92\u4f53\u9009\u4ef6\uff01</font>"));
                return;
            }
            case 4: {
                object = new CMyBitsValue(MyPlugin.getPluginCode());
                if (((CMyBitsValue)object).getBit(2)) break;
                this.out.println("<font color=\"red\"" + I18NMessage.get(TreeCreator.class, "TreeCreator.label17", ">\u60a8\u6ca1\u6709\u8d2d\u4e70\u5143\u6570\u636e\u7ba1\u7406\u9009\u4ef6\uff01</font>"));
                return;
            }
        }
        object = this.getWebSites(n);
        this.writeHTMLFromObjects((BaseObjs)object);
    }

    private void writeChannelsHTML(int n, int n2) throws Exception {
        BaseChannel baseChannel = null;
        if (n > 0) {
            baseChannel = WebSite.findById(n);
        } else if (n2 > 0) {
            baseChannel = Channel.findById(n2);
        }
        List list = this.getChildren(baseChannel, 64);
        this.writeHTMLFromObjects(list);
    }

    private void writeCustomChannelsHTML(int n) throws Exception {
        if (n == 3) {
            IndividuationMgr individuationMgr = new IndividuationMgr();
            String string = individuationMgr.getObjectIdsAsString(101);
            this.writeHTMLFromObjects(Channels.findByIds(this.m_oLoginUser, string));
        }
    }

    public WebSites getWebSites(int n) throws WCMException {
        String string = "Status>=0";
        if (n >= 0) {
            string = string + " and SiteType=?";
        }
        boolean bl = this.currRequestHelper.getBoolean("MultiSites", false);
        if (this.m_nCurrSiteId > 0 && !bl) {
            string = string + " and SiteId=?";
        }
        WCMFilter wCMFilter = new WCMFilter("", string, "SiteOrder Desc");
        if (n >= 0) {
            wCMFilter.addSearchValues(n);
        }
        if (this.m_nCurrSiteId > 0 && !bl) {
            wCMFilter.addSearchValues(this.m_nCurrSiteId);
        }
        SiteMemberMgr siteMemberMgr = (SiteMemberMgr)DreamFactory.createObjectById("SiteMemberMgr");
        WebSites webSites = null;
        webSites = WebSites.openWCMObjs(null, wCMFilter);
        boolean bl2 = this.currRequestHelper.getBoolean("FromSelect", false);
        Hashtable hashtable = null;
        hashtable = this.currRequestHelper.getRequest() != null ? (Hashtable)this.currRequestHelper.getRequest().getSession().getAttribute("customSite") : new Hashtable(1);
        for (int i = webSites.size() - 1; i >= 0; --i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null) continue;
            if (this.m_bSelectMobile && !webSite.isMobile()) {
                webSites.removeAt(i, false);
                continue;
            }
            if (this.m_oViewer instanceof User) {
                if (!this.hasSuperRight(webSite, this.m_oViewer) && !AuthServer.hasRight(this.m_oViewer, (CMSObj)webSite, 64)) {
                    webSites.removeAt(i, false);
                    continue;
                }
            } else if (!this.hasSuperRight(webSite, this.m_oViewer) && !siteMemberMgr.isVisible(this.m_oViewer, webSite)) {
                webSites.removeAt(i, false);
                continue;
            }
            if (this.m_bInRightSetPage || !this.m_bForIndividual || hashtable == null || hashtable.size() <= 0 || hashtable.get(String.valueOf(webSite.getId())) != null) continue;
            webSites.removeAt(i, false);
        }
        return webSites;
    }

    private boolean hasRight(BaseChannel baseChannel, int n) throws WCMException {
        if (this.m_nRightIndex == 42) {
            for (int i = 0; i < WCMRightTypes.SET_FLOW_EMPLOY_RIGHTS.length; ++i) {
                if (!AuthServer.hasRight(this.m_oViewer, (CMSObj)baseChannel.getSite(), WCMRightTypes.SET_FLOW_EMPLOY_RIGHTS[i])) continue;
                return true;
            }
            return false;
        }
        if (this.m_oViewer.getWCMType() != 204 && this.isView && n == 64) {
            ObjectMember objectMember = this.oObjectMemberMgr.getObjectMember(this.m_oViewer.getWCMType(), this.m_oViewer.getId(), baseChannel.getWCMType(), baseChannel.getId());
            return objectMember != null && objectMember.isVisible();
        }
        return AuthServer.hasRight(this.m_oViewer, (CMSObj)baseChannel, n);
    }

    private void writeHTMLFromObjects(BaseObjs baseObjs) throws Exception {
        this.writeHTMLFromObjects(baseObjs, false, 0);
    }

    private void writeHTMLFromObjects(BaseObjs baseObjs, boolean bl, int n) throws Exception {
        int n2 = baseObjs.size();
        for (int i = 0; i < n2; ++i) {
            BaseChannel baseChannel = (BaseChannel)baseObjs.getAt(i);
            if (baseChannel == null || !this.isVisibleOnLoadFromPath(baseChannel)) continue;
            if (this.m_bInRightSetPage) {
                if (this.m_bInViewOperSetPage) {
                    this.writeBaseChannelHTMLOfViewOperSet(baseChannel);
                    continue;
                }
                this.writeBaseChannelHTMLOfRightSet(baseChannel);
                continue;
            }
            this.writeBaseChannelHTML(baseChannel, bl, n, "");
        }
    }

    private void writeBaseChannelHTML(BaseChannel baseChannel, boolean bl, int n, String string) throws Exception {
        String string2 = CMyString.showNull(string);
        this.writeSingleNodeHTML(baseChannel, string2);
        if (this.m_isFirstLevelCustomChannel) {
            return;
        }
        boolean bl2 = this.currRequestHelper.getBoolean("ExcludeChildren", false);
        if (bl2 && this.isExcludeChildren(baseChannel)) {
            return;
        }
        List list = baseChannel.getChildren(null);
        if (list != null && !list.isEmpty()) {
            if (this.isNeedWriteChildrenHTML(baseChannel, bl, n)) {
                this.out.println(string2 + "<ul>");
                this.writeHTMLFromObjects(list, bl, n + 1);
                this.out.println(string2 + "</ul>");
            } else {
                this.out.println(string2 + "<ul></ul>");
            }
        }
    }

    private boolean isExcludeChildren(BaseChannel baseChannel) throws WCMException {
        if (baseChannel.isSite()) {
            return false;
        }
        String string = this.currRequestHelper.getString("ExcludeParentIds");
        if (this.m_pExcludeParentIds == null) {
            this.m_pExcludeParentIds = CMyString.splitToInt(string, ",");
        }
        if (this.m_pExcludeParentIds.length > 0) {
            for (int i = 0; i < this.m_pExcludeParentIds.length; ++i) {
                if (this.m_pExcludeParentIds[i] != baseChannel.getId()) continue;
                return true;
            }
            return false;
        }
        return this.m_oCurrChannel != null && this.m_oCurrChannel.getId() == baseChannel.getId();
    }

    private void writeSingleNodeHTML(BaseChannel baseChannel, String string) throws IOException, WCMException, Exception {
        String string2 = (baseChannel.isSite() ? "s" : "c") + "_" + baseChannel.getId();
        String string3 = this.m_isFirstLevelCustomChannel ? " SiteType=" + this.getSiteType(baseChannel) + " " : " ";
        this.out.println(string + "<div title=\"" + CMyString.filterForHTMLValue(baseChannel.getDispDesc()) + "\" classPre=\"" + this.getClassPre(baseChannel) + "\"" + string3 + this.getExtraHTMLAttribute(baseChannel) + " id=\"" + string2 + "\">" + this.getNodeInnerHTML(baseChannel, string2) + "</div>");
    }

    private boolean isNeedWriteChildrenHTML(BaseChannel baseChannel, boolean bl, int n) {
        return bl && n < this.m_pObjectIds.length && this.m_pObjectIds[n] == baseChannel.getId();
    }

    private String getClassPre(BaseChannel baseChannel) {
        if (baseChannel.isSite()) {
            return "site";
        }
        Channel channel = (Channel)baseChannel;
        if (channel.isNormType()) {
            return "channel";
        }
        return "channel" + channel.getType();
    }

    private String getNodeInnerHTML(BaseChannel baseChannel, String string) throws Exception {
        if (this.currRequestHelper.getBoolean("FromSelect", false)) {
            return "<a href=\"#\"  name=\"a" + string + "\" " + this.getExtraAttrOfA(baseChannel) + ">" + "<label For=\"c" + string + "\" style=\"cursor:hand\">" + CMyString.transDisplay(baseChannel.getDispDesc()) + "</label>" + "</a>";
        }
        return "<a href=\"#\"  name=\"a" + string + "\" " + this.getExtraAttrOfA(baseChannel) + ">" + CMyString.transDisplay(baseChannel.getDispDesc()) + "</a>";
    }

    private String getExtraAttrOfA(BaseChannel baseChannel) {
        String string = LocaleServer.getString("tree.label.bianhao", I18NMessage.get(TreeCreator.class, "TreeCreator.label18", "\u7f16\u53f7\uff1a")) + baseChannel.getId() + " \n" + LocaleServer.getString("tree.label.biaoshi", I18NMessage.get(TreeCreator.class, "TreeCreator.label19", "\u552f\u4e00\u6807\u8bc6\uff1a")) + CMyString.filterForHTMLValue(baseChannel.getName()) + " \n" + LocaleServer.getString("tree.label.cruser", I18NMessage.get(TreeCreator.class, "TreeCreator.label20", "\u521b\u5efa\u8005\uff1a")) + CMyString.filterForHTMLValue(baseChannel.getCrUserName()) + " \n" + LocaleServer.getString("tree.label.crtime", I18NMessage.get(TreeCreator.class, "TreeCreator.label21", "\u521b\u5efa\u65f6\u95f4\uff1a")) + baseChannel.getCrTime();
        return " title=\"" + string + "\" ";
    }

    private String getExtraHTMLAttribute(BaseChannel baseChannel) throws WCMException {
        String string = "";
        if (this.currRequestHelper.getBoolean("unNotSelectDisabledNoRight", false)) {
            string = " unNotSel=\"true\" ";
        }
        if (!this.currRequestHelper.getBoolean("FromSelect", false)) {
            Cloneable cloneable;
            String string2 = "";
            if (!baseChannel.isSite()) {
                cloneable = (Channel)baseChannel;
                if (!((Channel)cloneable).isNormType()) {
                    string2 = " ChannelType=" + ((Channel)cloneable).getType() + " ";
                }
                if (((Channel)cloneable).isVirtual()) {
                    string2 = string2 + " IsV=1 ";
                }
            }
            cloneable = null;
            cloneable = this.hasSuperRight(baseChannel, this.m_oOperator) ? new RightValue(RightValue.getAdministratorValues()) : (this.oObjectMemberMgr.canOperate(this.m_oOperator, baseChannel.getWCMType(), baseChannel.getId()) ? AuthServer.getRightValue((CMSObj)baseChannel, this.m_oOperator) : new RightValue());
            if (baseChannel instanceof Channel) {
                Channel channel = (Channel)baseChannel;
                ChannelToXML.doFilterRight((RightValue)cloneable, channel);
            }
            string2 = string2 + " RV=" + ((CMyBitsValue)cloneable).toString() + " ";
            return string2 + string;
        }
        if (baseChannel.isSite()) {
            if (!this.currRequestHelper.getBoolean("ShowSiteCheckBox", false)) {
                return " OnlyNode=\"true\" " + string;
            }
            return "" + string;
        }
        if (this.hasRight((Channel)baseChannel)) {
            return "" + string;
        }
        return " SDisabled=\"true\" " + string;
    }

    private String getSiteType(BaseChannel baseChannel) throws WCMException {
        if (!baseChannel.isSite()) {
            baseChannel = WebSite.findById(baseChannel.getSiteId());
        }
        Number number = (Number)((WebSite)baseChannel).getProperty("SiteType");
        return number.toString();
    }

    public boolean hasSuperRight(BaseChannel baseChannel, CMSObj cMSObj) throws WCMException {
        switch (cMSObj.getWCMType()) {
            case 204: {
                User user = (User)cMSObj;
                if (user.isAdministrator()) {
                    return true;
                }
                if (baseChannel == null || !user.getName().equalsIgnoreCase(baseChannel.getCrUserName())) break;
                return true;
            }
            case 203: {
                Role role = (Role)cMSObj;
                if (!role.isAdministrators()) break;
                return true;
            }
        }
        return false;
    }

    public boolean hasRight(Channel channel) throws WCMException {
        boolean bl;
        boolean bl2 = this.currRequestHelper.getBoolean("ExcludeSelf", false);
        if (this.m_oCurrChannel != null && bl2 && channel.getId() == this.m_oCurrChannel.getId()) {
            return false;
        }
        String string = this.currRequestHelper.getString("ExcludeChannelIds");
        if (string != null && string.length() > 0 && ("," + string + ",").indexOf("," + channel.getId() + ",") >= 0) {
            return false;
        }
        boolean bl3 = this.currRequestHelper.getBoolean("ExcludeVirtual", false);
        if (bl3 && channel.isVirtual()) {
            return false;
        }
        boolean bl4 = this.currRequestHelper.getBoolean("OnlyMyChildren", false);
        int n = this.currRequestHelper.getInt("CurrChannelId", 0);
        if (bl4 && n > 0) {
            bl = true;
            for (Channel channel2 = channel; channel2 != null; channel2 = channel2.getParent()) {
                if (channel2.getId() == n) {
                    bl = false;
                    break;
                }
                if (channel2.getParentId() <= 0) break;
            }
            if (bl) {
                return false;
            }
        }
        bl = channel.getType() == 11;
        boolean bl5 = this.currRequestHelper.getBoolean("ExcludeLink", false);
        if (bl5 && bl) {
            return false;
        }
        boolean bl6 = channel.getType() == 13;
        boolean bl7 = this.currRequestHelper.getBoolean("ExcludeInfoview", true);
        if (bl7 && bl6) {
            return false;
        }
        boolean bl8 = channel.getType() == 2 || channel.getType() == 1;
        boolean bl9 = this.currRequestHelper.getBoolean("ExcludeTop", false);
        if (bl9 && bl8) {
            return false;
        }
        boolean bl10 = this.currRequestHelper.getBoolean("ExcludeOnlySearch", false);
        if (bl10 && channel.isVirtual() && !bl8) {
            return false;
        }
        boolean bl11 = this.currRequestHelper.getBoolean("ExcludeParent", false);
        if (this.m_oCurrChannel != null && bl11 && channel.getId() == this.m_oCurrChannel.getParentId()) {
            return false;
        }
        if (this.hasSuperRight(channel, this.m_oViewer)) {
            return true;
        }
        return this.hasRight(channel, this.m_nRightIndex);
    }

    private void writeHTMLFromObjects(List list) throws Exception {
        this.writeHTMLFromObjects(list, false, 0);
    }

    private void writeHTMLFromObjects(List list, boolean bl, int n) throws Exception {
        String string = this.makeTabContent(n);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            BaseChannel baseChannel = (BaseChannel)list.get(i);
            if (baseChannel == null || !this.isVisibleOnLoadFromPath(baseChannel)) continue;
            if (this.m_bInRightSetPage) {
                if (this.m_bInViewOperSetPage) {
                    this.writeBaseChannelHTMLOfViewOperSet(baseChannel);
                    continue;
                }
                this.writeBaseChannelHTMLOfRightSet(baseChannel);
                continue;
            }
            this.writeBaseChannelHTML(baseChannel, bl, n, string);
        }
    }

    private boolean isVisibleOnLoadFromPath(BaseChannel baseChannel) throws WCMException {
        if (!this.m_bLoadFromPath) {
            return true;
        }
        if (baseChannel.isSite()) {
            return WebSiteHelper.isVisible(this.m_oLoginUser, (WebSite)baseChannel);
        }
        if (this.m_nRightIndex == 42) {
            for (int i = 0; i < WCMRightTypes.SET_FLOW_EMPLOY_RIGHTS.length; ++i) {
                if (!AuthServer.hasRight(this.m_oViewer, (CMSObj)baseChannel.getSite(), WCMRightTypes.SET_FLOW_EMPLOY_RIGHTS[i])) continue;
                return true;
            }
            return false;
        }
        return AuthServer.hasRight(this.m_oLoginUser, (CMSObj)baseChannel, 64);
    }

    private void writeBaseChannelHTMLOfRightSet(BaseChannel baseChannel) throws Exception {
        boolean bl = true;
        if (this.m_oViewer == this.m_oLoginUser) {
            if (baseChannel.getWCMType() == 103) {
                if (!AuthServer.hasRight(this.m_oViewer, (CMSObj)baseChannel, 7)) {
                    bl = false;
                }
            } else if (!AuthServer.hasRight(this.m_oViewer, (CMSObj)baseChannel, 55)) {
                bl = false;
            }
        }
        List list = baseChannel.getChildren(null);
        this.out.print("<span id=\"" + (baseChannel.isSite() ? "s" : "c") + "_" + baseChannel.getId() + "\"" + " desc=\"" + CMyString.transDisplay(baseChannel.getDispDesc()) + "\"" + " hasChild=\"" + (list != null && !list.isEmpty()) + "\"" + " classPre =\"" + this.getClassPre(baseChannel) + "\"" + this.getExtraHTMLAttribute(baseChannel) + this.getExtraAttrOfA(baseChannel) + "canSetRight = \"" + bl + "\"" + this.getRightIdAttribute(baseChannel) + "></span>");
    }

    private String getRightIdAttribute(BaseChannel baseChannel) throws Exception {
        int n;
        int n2 = baseChannel.isSite() ? 103 : 101;
        Right right = Right.findBy(n2, n = baseChannel.getId(), this.m_nOperatorType, this.m_nOperatorId);
        if (right != null) {
            return " RightId='" + right.getId() + "'";
        }
        return "";
    }

    private List getChildren(BaseChannel baseChannel, int n) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(TreeCreator.class, "TreeCreator.label22", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u5f97\u5176\u5b50\u9891\u9053\uff01"));
        }
        List list = baseChannel.getChildren(null);
        if (this.hasSuperRight(null, this.m_oViewer)) {
            return list;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            BaseChannel baseChannel2 = (BaseChannel)list.get(i);
            if (baseChannel2 != null && this.hasRight(baseChannel2, n)) continue;
            list.remove(i);
        }
        return list;
    }

    private void writeLevelHTMLOfAPath(int n) throws Exception {
        if (n >= this.m_pObjectTypes.length) {
            return;
        }
        switch (this.m_pObjectTypes[n]) {
            case 1: {
                WebSites webSites = this.getWebSites(this.m_pObjectIds[n]);
                this.writeHTMLFromObjects(webSites, true, n + 1);
                break;
            }
            case 103: {
                WebSite webSite = WebSite.findById(this.m_pObjectIds[n]);
                List list = this.getChildren(webSite, 64);
                this.writeHTMLFromObjects(list, true, n + 1);
                break;
            }
            case 101: {
                Channel channel = Channel.findById(this.m_pObjectIds[n]);
                this.writeHTMLFromObjects(this.getChildren(channel, 64), true, n + 1);
                break;
            }
        }
    }

    private void extractNodeInfo(String[] stringArray) throws WCMException {
        this.m_pObjectTypes = new int[stringArray.length];
        this.m_pObjectIds = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(95);
            if (n <= 0) {
                throw new WCMException(I18NMessage.get(TreeCreator.class, "TreeCreator.label23", "\u548c\u7ea6\u5b9a\u7684\u6570\u636e\u4e0d\u4e00\u81f4\uff01"));
            }
            this.m_pObjectIds[i] = Integer.parseInt(stringArray[i].substring(n + 1));
            String string = stringArray[i].substring(0, n);
            if (string.equalsIgnoreCase("r")) {
                this.m_pObjectTypes[i] = 1;
                continue;
            }
            if (string.equalsIgnoreCase("s")) {
                this.m_pObjectTypes[i] = 103;
                continue;
            }
            if (string.equalsIgnoreCase("c")) {
                this.m_pObjectTypes[i] = 101;
                continue;
            }
            throw new WCMException(I18NMessage.get(TreeCreator.class, "TreeCreator.label24", "\u4e0d\u80fd\u8bc6\u522b\u7684\u7c7b\u578b[") + string + "]\uff01");
        }
    }

    private String makeTabContent(int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n & 4);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("   ");
        }
        return stringBuffer.toString();
    }

    private int[] getSiteTypesOfChannels(String string) throws Exception {
        return new int[]{this.getSiteTypeOfChannel(CMyString.splitToInt(string, ",")[0])};
    }

    private int getSiteTypeOfChannel(int n) throws Exception {
        int n2 = DBManager.getDBManager().sqlExecuteIntQuery("select SiteType from WCMWebSite where exists(select WCMChannel.ChannelId from WCMChannel  where WCMChannel.ChannelId=? and WCMChannel.SiteId=WCMWebSite.SiteId)", new int[]{n});
        return n2;
    }

    private void writeBaseChannelHTMLOfViewOperSet(BaseChannel baseChannel) throws Exception {
        boolean bl = true;
        if (this.m_oViewer == this.m_oLoginUser) {
            if (baseChannel.getWCMType() == 103) {
                if (!AuthServer.hasRight(this.m_oViewer, (CMSObj)baseChannel, 7)) {
                    bl = false;
                }
            } else if (!AuthServer.hasRight(this.m_oViewer, (CMSObj)baseChannel, 55)) {
                bl = false;
            }
        }
        List list = baseChannel.getChildren(null);
        ObjectMember objectMember = this.oObjectMemberMgr.getObjectMember(this.m_nOperatorType, this.m_nOperatorId, baseChannel.getWCMType(), baseChannel.getId());
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (objectMember != null) {
            n = objectMember.getId();
            bl2 = objectMember.isVisible();
            bl3 = objectMember.isDoOperation();
        }
        this.out.print("<span id=\"" + (baseChannel.isSite() ? "s" : "c") + "_" + baseChannel.getId() + "\"" + " desc=\"" + CMyString.transDisplay(baseChannel.getDispDesc()) + "\"" + " hasChild=\"" + (list != null && !list.isEmpty()) + "\"" + " classPre =\"" + this.getClassPre(baseChannel) + "\"" + this.getExtraHTMLAttribute(baseChannel) + this.getExtraAttrOfA(baseChannel) + " canSetRight = \"" + bl + "\"" + " visible = \"" + bl2 + "\"" + " doOperation = \"" + bl3 + "\"" + " objectMemberId = \"" + n + "\"" + "></span>");
        if (!this.m_bGetAllChildren) {
            return;
        }
        List list2 = this.getChildren(baseChannel, 64);
        int n2 = list2.size();
        for (int i = 0; i < n2; ++i) {
            BaseChannel baseChannel2 = (BaseChannel)list2.get(i);
            if (baseChannel2 == null) continue;
            this.writeBaseChannelHTMLOfViewOperSet(baseChannel2);
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(System.currentTimeMillis());
    }
}

