/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.nav;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.WCMDiscoveryFactory;
import com.trs.presentation.nav.INavHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class NavHandlerFactory {
    private static Logger logger = Logger.getLogger(NavHandlerFactory.class);
    private static Map handlerMap = null;

    private static synchronized void init() throws WCMException {
        if (handlerMap != null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        Iterator iterator = WCMDiscoveryFactory.getDiscovery().getImplementors(INavHandler.class.getName());
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                INavHandler iNavHandler = (INavHandler)Class.forName(string).newInstance();
                hashMap.put(iNavHandler.toHandlerkey().toLowerCase(), string);
            }
            catch (Throwable throwable) {
                String string2 = I18NMessage.get(NavHandlerFactory.class, "NavHandlerFactory.label1", "\u6ce8\u518c\u5bfc\u822a\u6784\u9020\u5668[ClassName=") + string + I18NMessage.get(NavHandlerFactory.class, "NavHandlerFactory.label2", "]\u5931\u8d25\uff01");
                logger.error((Object)string2, throwable);
                throw new WCMException(string2, throwable);
            }
        }
        handlerMap = hashMap;
    }

    public static INavHandler getNavHandler(String string) throws WCMException {
        String string2;
        if (handlerMap == null) {
            NavHandlerFactory.init();
        }
        if ((string2 = (String)handlerMap.get(string.toLowerCase())) == null) {
            throw new WCMException(I18NMessage.get(NavHandlerFactory.class, "NavHandlerFactory.label3", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684Handler\uff01(Key=") + string + ")");
        }
        try {
            return (INavHandler)Class.forName(string2).newInstance();
        }
        catch (Throwable throwable) {
            throw new WCMException(I18NMessage.get(NavHandlerFactory.class, "NavHandlerFactory.label1", "\u6ce8\u518c\u5bfc\u822a\u6784\u9020\u5668[ClassName=") + string2 + I18NMessage.get(NavHandlerFactory.class, "NavHandlerFactory.label2", "]\u5931\u8d25\uff01"), throwable);
        }
    }
}

