/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.locale;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.customize.UserSetting;
import com.trs.components.wcm.customize.UserSettings;
import com.trs.infra.BaseServer;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.presentation.locale.LocaleDefinitions;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public final class LocaleServer
extends BaseServer {
    private static final int FAVOR_LOCALE_IDENTY = -10000;
    private static final String BUNDLE_BASENAME = "locale.presentation";
    private static Map m_allBundles;
    private static Map m_allLocales;
    private static Map m_cachedFavorLocales;

    protected void doShutdown() {
    }

    protected boolean doStart() throws WCMException {
        this.loadBundlesAndLocales();
        this.cacheFavorLocaleSetting();
        Locale.setDefault(Locale.CHINA);
        return true;
    }

    public static String getString(String string, String string2) {
        try {
            String string3 = LocaleServer.getServer().getBundle().getString(string);
            return new String(string3.getBytes("8859_1"), "GBK");
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string2;
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public static CMyDateTime getDateTime(String string) {
        CMyDateTime cMyDateTime = CMyDateTime.now();
        try {
            cMyDateTime.setDateTimeWithString(LocaleServer.getServer().getBundle().getString(string), "yyyy-MM-dd");
            return cMyDateTime;
        }
        catch (Exception exception) {
            return cMyDateTime;
        }
    }

    public static Locale getCurrentLocale() {
        return LocaleServer.getServer().getFavorLocale();
    }

    public static void setFavorLanguage(User user, String string) throws WCMException {
        Locale locale = LocaleServer.getServer().getLoaleByLanguageKey(string);
        LocaleServer.setFavorLocale(user, locale);
    }

    public static void setFavorLocale(User user, Locale locale) throws WCMException {
        LocaleServer.getServer().deleteLocaleSettingIfExists(user);
        LocaleServer.getServer().saveFavorLocaleSetting(user, locale);
        LocaleServer.getServer().refreshFavorLocaleCached(user, locale);
    }

    public static String getFavorLanguageKey() {
        return LocaleServer.getServer().getFavorLocale().toString();
    }

    public static String[] getLanguageKeys() {
        LocaleServer.getServer();
        Object[] objectArray = m_allLocales.keySet().toArray();
        String[] stringArray = new String[objectArray.length - 1];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = (String)objectArray[i];
            if (string.length() == 0) continue;
            stringArray[i] = string;
        }
        return stringArray;
    }

    private Locale getLoaleByLanguageKey(String string) {
        return (Locale)m_allLocales.get(string);
    }

    private void loadBundlesAndLocales() {
        LocaleDefinitions localeDefinitions = new LocaleDefinitions();
        Map map = localeDefinitions.caculateLocales();
        m_allBundles = new HashMap(map.size());
        m_allLocales = new HashMap(map.size());
        Set set = map.keySet();
        ResourceBundle resourceBundle = null;
        for (String string : set) {
            Locale locale = (Locale)map.get(string);
            m_allLocales.put(locale.toString(), locale);
            resourceBundle = ResourceBundle.getBundle(BUNDLE_BASENAME, locale);
            m_allBundles.put(locale, resourceBundle);
        }
    }

    private void cacheFavorLocaleSetting() throws WCMException {
        UserSettings userSettings = this.findFavorLocaleSettings();
        m_cachedFavorLocales = new HashMap(userSettings.size());
        UserSetting userSetting = null;
        for (int i = 0; i < userSettings.size(); ++i) {
            userSetting = (UserSetting)userSettings.getAt(i);
            if (userSetting == null) continue;
            User user = userSetting.getOwner();
            String string = userSetting.getValue();
            Locale locale = (Locale)m_allLocales.get(string);
            if (user == null) continue;
            m_cachedFavorLocales.put(user.getKey(), locale);
        }
    }

    private UserSettings findFavorLocaleSettings() throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "ObjType=-10000", "");
        UserSettings userSettings = UserSettings.openWCMObjs(User.getSystem(), wCMFilter);
        return userSettings;
    }

    private void deleteLocaleSettingIfExists(User user) throws WCMException {
        String string = "DELETE FROM WCMUserSetting WHERE UserId=" + user.getId() + " AND ObjType=" + -10000;
        DBManager.getDBManager().sqlExecuteUpdate(string);
    }

    private void saveFavorLocaleSetting(User user, Locale locale) throws WCMException {
        UserSetting userSetting = UserSetting.createNewInstance();
        userSetting.setObjId(10000);
        userSetting.setObjType(-10000);
        userSetting.setValue(locale.toString());
        userSetting.setUser(user);
        userSetting.insert(user);
    }

    private void refreshFavorLocaleCached(User user, Locale locale) {
        m_cachedFavorLocales.put(user.getKey(), locale);
    }

    private ResourceBundle getBundle() {
        return (ResourceBundle)m_allBundles.get(this.getFavorLocale());
    }

    private Locale getFavorLocale() {
        Locale locale = null;
        try {
            User user = ContextHelper.getLoginUser();
            locale = (Locale)m_cachedFavorLocales.get(user.getKey());
        }
        catch (Exception exception) {
            locale = Locale.getDefault();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private static LocaleServer getServer() {
        LocaleServer localeServer = (LocaleServer)DreamFactory.createObjectById("LocaleServer");
        if (!localeServer.isStarted()) {
            localeServer.startup();
        }
        return localeServer;
    }
}

