/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.sql;

import com.trs.infra.util.upgrade.DbConfig;
import com.trs.infra.util.upgrade.dbcompare.MetaDataLoader;
import com.trs.infra.util.upgrade.dbcompare.SchemaCompare;
import com.trs.infra.util.upgrade.dbcompare.TableDiff;
import com.trs.infra.util.upgrade.sql.SchemaUpdSqlMaker;
import com.trs.infra.util.upgrade.sql.SchemaUpdSqlMakerFactory;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DiffSqlMaker {
    private String dbconf;
    private String output;

    public DiffSqlMaker(String string, String string2) {
        this.dbconf = string;
        this.output = string2;
    }

    public void make() throws Exception {
        DbConfig dbConfig = new DbConfig();
        dbConfig.load(this.dbconf);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.output), "GBK"));
        Class.forName(dbConfig.getJdbcDriver());
        Connection connection = DriverManager.getConnection(dbConfig.getOldUrl(), dbConfig.getOldUser(), dbConfig.getOldPasswd());
        Connection connection2 = DriverManager.getConnection(dbConfig.getNewUrl(), dbConfig.getNewUser(), dbConfig.getNewPasswd());
        MetaDataLoader metaDataLoader = new MetaDataLoader(connection, dbConfig.getOldSchema());
        MetaDataLoader metaDataLoader2 = new MetaDataLoader(connection2, dbConfig.getNewSchema());
        SchemaCompare schemaCompare = new SchemaCompare(metaDataLoader, metaDataLoader2);
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                TableDiff tableDiff = (TableDiff)object;
                TableDiff tableDiff2 = (TableDiff)object2;
                return tableDiff.getTableName().compareTo(tableDiff2.getTableName());
            }
        };
        List list = schemaCompare.getDiff4Source();
        Collections.sort(list, comparator);
        SchemaUpdSqlMaker schemaUpdSqlMaker = SchemaUpdSqlMakerFactory.makeSqlMaker(dbConfig.getDbtype());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            for (String string : schemaUpdSqlMaker.getSql((TableDiff)list.get(i))) {
                if (string == null || string.length() <= 0) continue;
                bufferedWriter.write(string);
                bufferedWriter.write("\n\r");
            }
            bufferedWriter.flush();
        }
        bufferedWriter.close();
        connection.close();
        connection2.close();
    }

    public static void main(String[] stringArray) throws Exception {
        DiffSqlMaker diffSqlMaker = new DiffSqlMaker(stringArray[0], stringArray[1]);
        diffSqlMaker.make();
    }
}

