/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.dbcompare;

import com.trs.infra.util.upgrade.dbcompare.TypeInfo;
import com.trs.infra.util.upgrade.dbcompare.TypeInfoMap;

public class Column {
    public String name;
    public int type;
    public String typeName;
    public boolean nullAble;
    public String defaultValue;
    public int length;
    public int scale;
    public int order;
    public boolean useNull = true;

    public Column(String string, int n, String string2) {
        this.name = string.toUpperCase();
        this.type = n;
        this.typeName = string2.toLowerCase();
    }

    public int hashCode() {
        if (this.name == null) {
            return super.hashCode();
        }
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != Column.class) {
            return false;
        }
        Column column = (Column)object;
        boolean bl = this.length > column.length || this.scale != column.scale;
        return !bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        stringBuffer.append(this.name);
        stringBuffer.append('\"');
        stringBuffer.append(' ').append(this.typeName);
        TypeInfo typeInfo = TypeInfoMap.get(this.typeName);
        if (typeInfo == null) {
            stringBuffer.append(" (");
            stringBuffer.append(this.length);
            if (this.scale != 0) {
                stringBuffer.append(", ").append(this.scale);
            }
            stringBuffer.append(")");
        } else if (typeInfo.getCrtParamsCount() != 0) {
            stringBuffer.append(" (");
            stringBuffer.append(this.length);
            if (typeInfo.getCrtParamsCount() == 2) {
                stringBuffer.append(',').append(this.scale);
            }
            stringBuffer.append(')');
        }
        if (this.defaultValue != null && this.defaultValue.length() > 0) {
            stringBuffer.append(" default ");
            stringBuffer.append(this.defaultValue);
        }
        if (this.useNull) {
            if (!this.nullAble) {
                stringBuffer.append(" not");
            }
            stringBuffer.append(" null");
        }
        return stringBuffer.toString();
    }
}

