/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.job;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyDateTime;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class JobScheduler {
    private static Logger s_logger = Logger.getLogger(JobScheduler.class);
    private Scheduler m_oScheduler = null;

    public void restart() throws WCMException {
        this.shutDown();
        this.start();
    }

    public void shutDown() {
        if (this.m_oScheduler == null) {
            return;
        }
        try {
            this.m_oScheduler.shutdown();
        }
        catch (Exception exception) {
            s_logger.error((Object)I18NMessage.get(JobScheduler.class, "JobScheduler.label1", "\u5173\u95ed\u8c03\u5ea6\u7ba1\u7406\u5668\u5931\u8d25\uff01"), (Throwable)exception);
        }
        this.m_oScheduler = null;
    }

    public boolean start() throws WCMException {
        if (this.m_oScheduler == null) {
            return false;
        }
        this.initScheduler();
        return true;
    }

    public void addJob(String string, Class clazz, String string2, CMyDateTime cMyDateTime) throws WCMException {
        JobDetail jobDetail = this.createJobDetail(string, clazz, string2);
        SimpleTrigger simpleTrigger = new SimpleTrigger(string + "[Trigger]", "DEFAULT", (Date)cMyDateTime.toDate());
        this.scheduleJob(jobDetail, (Trigger)simpleTrigger);
    }

    public void addJob(String string, Class clazz, String string2, CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2, long l) throws WCMException {
        JobDetail jobDetail = this.createJobDetail(string, clazz, string2);
        SimpleTrigger simpleTrigger = new SimpleTrigger(string + "[Trigger]", "DEFAULT", (Date)cMyDateTime.toDate(), (Date)cMyDateTime2.toDate(), SimpleTrigger.REPEAT_INDEFINITELY, l);
        this.scheduleJob(jobDetail, (Trigger)simpleTrigger);
    }

    public void addJob(String string, Class clazz, String string2, long l) throws WCMException {
        JobDetail jobDetail = this.createJobDetail(string, clazz, string2);
        SimpleTrigger simpleTrigger = new SimpleTrigger(string + "[Trigger]", "DEFAULT", SimpleTrigger.REPEAT_INDEFINITELY, l);
        this.scheduleJob(jobDetail, (Trigger)simpleTrigger);
    }

    public void addJob(String string, Class clazz, String string2, String string3) throws WCMException {
        JobDetail jobDetail = this.createJobDetail(string, clazz, string2);
        CronTrigger cronTrigger = null;
        try {
            cronTrigger = new CronTrigger(string + "[Trigger]", "DEFAULT", string3);
        }
        catch (ParseException parseException) {
            throw new WCMException(1100, I18NMessage.get(JobScheduler.class, "JobScheduler.label2", "\u63a7\u5236\u8868\u8fbe\u5f0f\u6709\u8bef[") + string3 + "].", parseException);
        }
        this.scheduleJob(jobDetail, (Trigger)cronTrigger);
    }

    public void addJob(String string, Class clazz, String string2, String[] stringArray) throws WCMException {
        if (stringArray.length == 1) {
            this.addJob(string, clazz, string2, stringArray[0]);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addJob(string + "-" + (i + 1), clazz, string2, stringArray[i]);
        }
    }

    public void deleteJob(String string) throws WCMException {
        try {
            this.getScheduler().deleteJob(string, "DEFAULT");
        }
        catch (SchedulerException schedulerException) {
            throw new WCMException(1100, I18NMessage.get(JobScheduler.class, "JobScheduler.label3", "\u5220\u9664JOB[") + string + I18NMessage.get(JobScheduler.class, "JobScheduler.label4", "]\u5931\u8d25\uff01"), schedulerException);
        }
    }

    private void scheduleJob(JobDetail jobDetail, Trigger trigger) throws WCMException {
        try {
            this.getScheduler().scheduleJob(jobDetail, trigger);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(JobScheduler.class, "JobScheduler.label5", "\u6dfb\u52a0\u6307\u5b9a\u7684\u4efb\u52a1[") + jobDetail.getName() + I18NMessage.get(JobScheduler.class, "JobScheduler.label4", "]\u5931\u8d25\uff01"), exception);
        }
    }

    private void initScheduler() throws WCMException {
        if (this.m_oScheduler != null) {
            return;
        }
        try {
            StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
            this.m_oScheduler = stdSchedulerFactory.getScheduler();
            this.m_oScheduler.start();
        }
        catch (Throwable throwable) {
            throw new WCMException(1100, I18NMessage.get(JobScheduler.class, "JobScheduler.label6", "\u6784\u9020\u8ba1\u5212\u7ba1\u7406\u5668\u51fa\u73b0\u5f02\u5e38\uff01"), throwable);
        }
    }

    private Scheduler getScheduler() throws WCMException {
        if (this.m_oScheduler == null) {
            this.initScheduler();
        }
        return this.m_oScheduler;
    }

    private JobDetail createJobDetail(String string, Class clazz, String string2) {
        JobDetail jobDetail = new JobDetail(string, "DEFAULT", clazz);
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            AttributesString attributesString = new AttributesString(string2);
            int n = attributesString.size();
            for (int i = 0; i < n; ++i) {
                String string3 = attributesString.getNameAt(i);
                jobDetail.getJobDataMap().put(string3.toUpperCase(), attributesString.getAttributeValue(string3));
            }
        }
        return jobDetail;
    }

    public void addJob(String string, Class clazz, String string2, Trigger trigger) throws WCMException {
        JobDetail jobDetail = this.createJobDetail(string, clazz, string2);
        trigger.setJobGroup(jobDetail.getGroup());
        trigger.setJobName(jobDetail.getName());
        this.scheduleJob(jobDetail, trigger);
        try {
            if (s_logger.isDebugEnabled()) {
                JobDetail jobDetail2 = this.getScheduler().getJobDetail(jobDetail.getName(), jobDetail.getGroup());
                Trigger trigger2 = this.getScheduler().getTrigger(trigger.getName(), trigger.getGroup());
                s_logger.debug((Object)("job:" + jobDetail2));
                s_logger.debug((Object)("trigger" + trigger2));
                s_logger.debug((Object)("start:" + trigger2.getStartTime()));
                s_logger.debug((Object)("end:" + trigger2.getEndTime()));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void registerCalendar(String string, Calendar calendar) throws WCMException {
        try {
            Scheduler scheduler = this.getScheduler();
            if (scheduler.getCalendar(string) != null) {
                scheduler.deleteCalendar(string);
            }
            scheduler.addCalendar(string, calendar, false, false);
        }
        catch (SchedulerException schedulerException) {
            throw new WCMException(1100, "fail to add calendar:" + string, schedulerException);
        }
    }

    public Iterator listTirggers() throws Exception {
        Scheduler scheduler = this.getScheduler();
        String[] stringArray = scheduler.getJobNames("DEFAULT");
        ArrayList<Trigger> arrayList = new ArrayList<Trigger>(stringArray.length);
        JobDetail jobDetail = null;
        Trigger trigger = null;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            jobDetail = scheduler.getJobDetail(stringArray[i], "DEFAULT");
            trigger = scheduler.getTrigger(jobDetail.getName() + "[Trigger]", "DEFAULT");
            arrayList.add(trigger);
        }
        return arrayList.iterator();
    }
}

