/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DataType;
import com.trs.infra.util.database.SybaseASEText;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class SybaseASE
extends DBType {
    public static final DataType BIT = new DataType("BIT", -7, 1);
    public static final DataType TINYINT = new DataType("TINYINT", -6, 1);
    public static final DataType SMALLINT = new DataType("SMALLINT", 5, 2);
    public static final DataType INT = new DataType("INT", 4, 4);
    public static final DataType NUMERIC = new DataType("NUMERIC", 2, 9);
    public static final DataType REAL = new DataType("REAL", 7, 4);
    public static final DataType FLOAT = new DataType("FLOAT", 6, 8);
    public static final DataType DECIMAL = new DataType("DECIMAL", 3, 9);
    public static final DataType MONEY = new DataType("MONEY", 3, 8);
    public static final DataType SMALLMONEY = new DataType("SMALLMONEY", 3, 4);
    public static final DataType BINARY = new DataType("BINARY", -2);
    public static final DataType VARBINARY = new DataType("VARBINARY", -3);
    public static final DataType IMAGE = new DataType("IMAGE", -4, 16);
    public static final DataType CHAR = new DataType("CHAR", 1, -8000);
    public static final DataType NCHAR = new DataType("NCHAR", 1, -4000);
    public static final DataType VARCHAR = new DataType("VARCHAR", 12, -8000);
    public static final DataType NVARCHAR = new DataType("NVARCHAR", 12, -4000);
    public static final DataType TEXT = new DataType("TEXT", -1, 16);
    public static final DataType TIMESTAMP = new DataType("TIMESTAMP", 93, 8);
    public static final DataType DATETIME = new DataType("DATETIME", 93, 8);
    public static final DataType SMALLDATETIME = new DataType("SMALLDATETIME", 93, 4);
    static final DataType[] m_allDataTypes = new DataType[]{BINARY, BIT, CHAR, DATETIME, DECIMAL, FLOAT, IMAGE, INT, MONEY, NCHAR, NUMERIC, NVARCHAR, REAL, SMALLDATETIME, SMALLINT, SMALLMONEY, TEXT, TIMESTAMP, TINYINT, VARBINARY, VARCHAR};
    static final DataType[] m_supportedDataTypes = new DataType[]{SMALLINT, TINYINT, INT, NUMERIC, NVARCHAR, DATETIME, FLOAT, NUMERIC};

    public SybaseASE() {
        super("Sybase ASE", "com.sybase.jdbc2.jdbc.SybDriver", true);
    }

    public SybaseASE(String string, String string2, boolean bl) {
        super(string, string2, true);
    }

    protected void registerDBInfo() {
        this.registerColumnType(-7, "tinyint");
        this.registerColumnType(-5, "numeric(19,0)");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(4, "int");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "datetime");
        this.registerColumnType(92, "datetime");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(2004, "image");
        this.registerColumnType(2005, "text");
    }

    public String sqlFilterForClob(String string, String string2) {
        return " patindex('%" + CMyString.filterForSQL(string2) + "%'," + string + ")>0 ";
    }

    public String sqlConcatStr(String string, String string2) {
        return string + "+" + string2;
    }

    public String sqlAddField(String string, String string2, String string3, int n, boolean bl, String string4, int n2) {
        String string5 = "ALTER TABLE " + string + " ADD " + string2 + " " + string3;
        DataType dataType = this.getDataType(string3);
        if (dataType == null) {
            return null;
        }
        if (dataType.isLengthDefinedByUser()) {
            string5 = n2 > 0 ? string5 + "(" + n + ", " + n2 + ")" : string5 + "(" + n + ")";
        }
        if (bl) {
            string5 = string5 + " NULL";
        } else {
            if (string4 != null) {
                string5 = string5 + " DEFAULT ";
                string5 = dataType.isCharData() ? string5 + "'" + CMyString.filterForSQL(string4) + "'" : string5 + string4;
            }
            string5 = string5 + " NOT NULL ";
        }
        return string5;
    }

    public String sqlConcatStr(String[] stringArray) {
        String string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string = string + "+" + stringArray[i];
        }
        return string;
    }

    public boolean canWriteTextDirectly() {
        return true;
    }

    public String sqlDateField(String string) {
        return string;
    }

    public String sqlFilterOneDay(String string, String string2, String string3) {
        return "DateDiff(day," + string + ",'" + string2 + "')=0";
    }

    public String sqlDateTime(String string, String string2) {
        return "'" + string + "'";
    }

    public String sqlConcatStr(String string, String string2, String string3) {
        return string + "+" + string2 + "+" + string3;
    }

    public String sqlDate(String string) {
        return "'" + string + "'";
    }

    public DataType[] getAllDataTypes() {
        return m_allDataTypes;
    }

    public DataType[] getSupportedDataTypes() {
        return m_supportedDataTypes;
    }

    public String sqlGetSysDate() {
        return "GETDATE()";
    }

    public String sqlDropField(String string, String string2) throws Exception {
        return "ALTER TABLE " + string + " DROP " + string2;
    }

    public String encodeStrToWrite(String string) {
        return string;
    }

    public String initQuerySQL(String string, int n, int n2) {
        return string;
    }

    public String sqlQueryTableInfos(String string) {
        String string2 = "SELECT * FROM WCM_ViewCOLUMNS ORDER BY TABLE_NAME, COLUMN_ID";
        return string2;
    }

    public String sqlQueryTableInfo(String string, String string2) {
        String string3 = "SELECT * FROM WCM_ViewCOLUMNS WHERE TABLE_NAME='" + string2.toUpperCase() + "' ORDER BY TABLE_NAME, COLUMN_ID";
        return string3;
    }

    public String getClob(ResultSet resultSet, boolean bl, int n) throws CMyException {
        return SybaseASEText.getClob(resultSet, bl, n);
    }

    public String getClob(ResultSet resultSet, boolean bl, String string) throws CMyException {
        return SybaseASEText.getClob(resultSet, bl, string);
    }

    public boolean setClob(Connection connection, String string, String string2, String string3, String string4, String string5) throws CMyException {
        return SybaseASEText.setClob(connection, string, string2, string3, string4, string5);
    }

    public boolean setClob(Connection connection, String string, String string2, String string3, String[] stringArray) throws CMyException {
        return SybaseASEText.setClob(connection, string, string2, string3, stringArray);
    }

    public String sqlGetNextId() {
        return "{call sp_getNextId(?,?,?)}";
    }

    public int getType() {
        return 4;
    }

    public boolean canDropField() {
        return false;
    }

    public void setStringFieldValue(PreparedStatement preparedStatement, int n, String string) throws Exception {
        if ("".equals(string)) {
            preparedStatement.setString(n, null);
        } else {
            preparedStatement.setString(n, string);
        }
    }
}

