/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;

public class DataType {
    public static final int LENGTH_UNKOWN = 0;
    private String name;
    private int type;
    private int maxLength;

    public DataType(String string, int n) {
        this(string, n, 0);
    }

    public DataType(String string, int n, int n2) {
        this.name = string;
        this.type = n;
        this.maxLength = n2;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getMaxLength() {
        return this.maxLength >= 0 ? this.maxLength : -this.maxLength;
    }

    public boolean isCharData() {
        int n = this.getType();
        return n == 12 || n == 1 || n == -1 || n == 2005;
    }

    public boolean isLengthDefinedByUser() {
        return this.maxLength < 0;
    }

    public String toString() {
        return "Name=" + this.name + " Type=" + this.type;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataType)) {
            return false;
        }
        int n = ((DataType)object).getType();
        if (n == this.getType()) {
            return true;
        }
        if (n == 2 && this.getType() == 4) {
            return true;
        }
        return n == 4 && this.getType() == 2;
    }

    public static String toTypeDescription(DataType dataType) {
        if (dataType == null) {
            return "";
        }
        int n = dataType.getType();
        switch (n) {
            case 6: {
                return I18NMessage.get(DataType.class, "DataType.label1", "\u5c0f\u6570\u578b");
            }
            case 2: 
            case 4: {
                return I18NMessage.get(DataType.class, "DataType.label2", "\u6574\u6570\u578b");
            }
            case 12: {
                return I18NMessage.get(DataType.class, "DataType.label3", "\u6587\u672c\u578b");
            }
            case 93: {
                return I18NMessage.get(DataType.class, "DataType.label4", "\u65f6\u95f4\u578b");
            }
        }
        return dataType.getName();
    }
}

