/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CAS400CLOB;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DataType;
import java.sql.Connection;
import java.sql.ResultSet;

public class DB2AS400DB
extends DBType {
    private static final String DRIVER_NAME = "com.ibm.as400.access.AS400JDBCDriver";
    private static final int NUMERIC_MAX_LEN = 31;
    public static final DataType SMALLINT = new DataType("SMALLINT", 5, 2);
    public static final DataType INT = new DataType("INTEGER", 4, 4);
    public static final DataType BIGINT = new DataType("BIGINT", -5, 8);
    public static final DataType NUMERIC = new DataType("NUMERIC", 2, -38);
    public static final DataType DECIMAL = new DataType("DECIMAL", 3, 9);
    public static final DataType REAL = new DataType("REAL", 7, 4);
    public static final DataType FLOAT = new DataType("FLOAT", 6, 8);
    public static final DataType CHAR = new DataType("CHAR", 1, -254);
    public static final DataType VARCHAR = new DataType("VARCHAR", 12, -32672);
    public static final DataType CLOB = new DataType("CLOB", 2005, 16);
    public static final DataType DBCLOB = new DataType("DBCLOB", 2005, 16);
    public static final DataType BLOB = new DataType("BLOB", -4, 16);
    public static final DataType DATE = new DataType("DATE", 93, 8);
    public static final DataType TIME = new DataType("TIME", 93, 8);
    public static final DataType TIMESTAMP = new DataType("TIMESTAMP", 93, 8);
    public static final DataType UNIQUEIDENTIFIER = new DataType("UNIQUEIDENTIFIER", -5, 16);
    public static final DataType SQL_VARIRANT = new DataType("SQL_VARIRANT", -3);
    public static final DataType NVARCHAR = new DataType("NVARCHAR", 12, -32672);
    public static final DataType NINT = new DataType("INT", 4, 4);
    public static final DataType DATETIME = new DataType("DATETIME", 93, 8);
    static final DataType[] m_allDataTypes = new DataType[]{SMALLINT, INT, BIGINT, DECIMAL, REAL, FLOAT, CHAR, VARCHAR, CLOB, DBCLOB, BLOB, DATE, TIME, TIMESTAMP, NUMERIC, NVARCHAR, NINT};
    static final DataType[] m_supportedDataTypes = new DataType[]{SMALLINT, INT, DECIMAL, VARCHAR, CLOB, TIMESTAMP};

    public DB2AS400DB() {
        super("DB2 UDB AS400", DRIVER_NAME, false);
    }

    public DB2AS400DB(String string, String string2, boolean bl) {
        super(string, string2, false);
    }

    protected void registerDBInfo() {
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "varchar($l) for bit data");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(2004, "blob($l)");
        this.registerColumnType(2005, "clob($l)");
    }

    public String sqlFilterForClob(String string, String string2) {
        String string3 = null;
        string3 = "?".equals(string2) ? "?" : "'%" + CMyString.filterForSQL(string2) + "%'";
        return string + " like " + string3;
    }

    public String sqlConcatStr(String string, String string2) {
        return "CONCAT(" + string + "," + string2 + ")";
    }

    public String sqlAddField(String string, String string2, String string3, int n, boolean bl, String string4, int n2) {
        DataType dataType = this.getDataType(string3);
        if (dataType == null) {
            return null;
        }
        String string5 = string3;
        int n3 = n;
        boolean bl2 = false;
        switch (dataType.getType()) {
            case 5: {
                string5 = "integer";
                n3 = dataType.getMaxLength();
                break;
            }
            case 4: {
                string5 = "bigint";
                n3 = dataType.getMaxLength();
                break;
            }
            case 6: {
                string5 = "float";
                n3 = dataType.getMaxLength();
                break;
            }
            case 2: {
                string5 = "decimal";
                n3 = dataType.getMaxLength();
                break;
            }
            case 91: 
            case 93: {
                string5 = "timestamp";
                break;
            }
            case 12: {
                string5 = "varchar";
                bl2 = true;
                break;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("alter table ").append(string.toUpperCase());
        stringBuffer.append(" add ").append(string2.toUpperCase());
        stringBuffer.append(' ').append(string5);
        if (dataType.isLengthDefinedByUser()) {
            if (bl2) {
                // empty if block
            }
            stringBuffer.append('(').append(n3);
            if (n2 > 0) {
                stringBuffer.append(',').append(n2);
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public String sqlAddField(String string, String string2, int n, int n2, boolean bl, String string3, int n3) throws WCMException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("alter table ");
        stringBuffer.append(string.toUpperCase());
        stringBuffer.append(" add ");
        stringBuffer.append(string2.toUpperCase());
        stringBuffer.append(' ');
        stringBuffer.append(this.getTypeName(n, n2, n2, n3));
        return stringBuffer.toString();
    }

    public String getTypeName(int n, int n2, int n3, int n4) throws WCMException {
        if (2 == n && n3 > 31) {
            n3 = 31;
        }
        return super.getTypeName(n, n2, n3, n4);
    }

    public String sqlConcatStr(String[] stringArray) {
        String string = "CONCAT(" + stringArray[0] + "," + stringArray[1] + ")";
        for (int i = 2; i < stringArray.length; ++i) {
            string = "CONCAT(" + string + "," + stringArray[i] + ")";
        }
        return string;
    }

    public boolean canWriteTextDirectly() {
        return false;
    }

    public DataType[] getAllDataTypes() {
        return m_allDataTypes;
    }

    public DataType[] getSupportedDataTypes() {
        return m_supportedDataTypes;
    }

    public String sqlFilterOneDay(String string, String string2, String string3) {
        return "(DATE(" + string + ")-DATE('" + string2 + "'))=0";
    }

    public String sqlDateTime(String string, String string2) {
        String string3 = string.replace(' ', '-');
        string3 = string3.replace(':', '.');
        return "TIMESTAMP('" + string3 + "')";
    }

    public String sqlDate(String string) {
        return this.sqlDateTime(string, "yyyy-MM-dd HH:mm:ss");
    }

    public String sqlDateField(String string) {
        return "DATE(" + string + ")";
    }

    public String sqlConcatStr(String string, String string2, String string3) {
        return "CONCAT(CONCAT(" + string + "," + string2 + ")," + string3 + ")";
    }

    public String sqlGetSysDate() {
        return "(CURRENT TIMESTAMP)";
    }

    public String sqlDropField(String string, String string2) throws Exception {
        throw new Exception(I18NMessage.get(DB2AS400DB.class, "DB2AS400DB.label1", "DB2 UDB AS400 \u4e0d\u652f\u6301\u5b57\u6bb5\u5220\u9664\uff01"));
    }

    public String encodeStrToWrite(String string) {
        return string;
    }

    public String initQuerySQL(String string, int n, int n2) {
        return string;
    }

    public String sqlQueryTableInfos(String string) {
        return null;
    }

    public String sqlQueryTableInfo(String string, String string2) {
        return null;
    }

    public String sqlGetNextId() {
        return null;
    }

    public String getClob(ResultSet resultSet, boolean bl, int n) throws CMyException {
        return CAS400CLOB.getClob(resultSet, n);
    }

    public String getClob(ResultSet resultSet, boolean bl, String string) throws CMyException {
        return CAS400CLOB.getClob(resultSet, string);
    }

    public boolean setClob(Connection connection, String string, String string2, String string3, String string4, String string5) throws CMyException {
        return CAS400CLOB.setClob(connection, string, string2, string3, string4, string5);
    }

    public boolean setClob(Connection connection, String string, String string2, String string3, String[] stringArray) throws CMyException {
        return CAS400CLOB.setClob(connection, string, string2, string3, stringArray);
    }

    public int getType() {
        return 6;
    }

    public boolean canDropField() {
        return false;
    }
}

