/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import com.trs.cms.content.HTMLContent;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.html.HtmlElement;
import java.io.File;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpenOfficeConverter {
    private static String OpenOffice_Host = "127.0.0.1";
    private static int OpenOffic_Port = 8100;

    public void convert(File file, File file2) throws Exception {
        String string = ConfigServer.getServer().getSysConfigValue("OCR_OPENOFFICE_HOST", OpenOffice_Host);
        String string2 = ConfigServer.getServer().getSysConfigValue("OCR_OPENOFFICE_PORT", String.valueOf(OpenOffic_Port));
        SocketOpenOfficeConnection socketOpenOfficeConnection = new SocketOpenOfficeConnection(string, Integer.parseInt(string2));
        socketOpenOfficeConnection.connect();
        OpenOfficeDocumentConverter openOfficeDocumentConverter = new OpenOfficeDocumentConverter((OpenOfficeConnection)socketOpenOfficeConnection);
        openOfficeDocumentConverter.convert(file, file2);
        socketOpenOfficeConnection.disconnect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String convert(String string, String string2) throws Exception {
        String string3;
        File file = null;
        try {
            try {
                if (string2 == null) {
                    throw new Exception("\u9700\u8981\u8f6c\u5316\u7684\u76ee\u6807\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                File file2 = new File(string);
                if (!file2.exists()) {
                    throw new Exception("\u9700\u8981\u8f6c\u5316\u7684\u6587\u4ef6\u6ca1\u6709\u627e\u5230\uff01");
                }
                file = File.createTempFile("document", "." + string2);
                this.convert(file2, file);
                String string4 = file.getAbsolutePath();
                HashMap hashMap = (HashMap)this.getExtFile(string4);
                String string5 = CharsetDetector.detect(string4);
                String string6 = HTMLContent.saveHTMLContentFromOut(CMyFile.readFile(string4, string5), hashMap);
                HTMLContent hTMLContent = new HTMLContent(string6);
                string3 = string6 = hTMLContent.parseHTMLContent(null);
                Object var12_13 = null;
            }
            catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                throw new WCMException("\u60a8\u7684JDK\u7248\u672c\u8fc7\u4f4e\uff0c\u4f7f\u7528OpenOffice\u670d\u52a1\u9700\u8981\u5347\u7ea7JDK\u7248\u672c\u52301.5\u53ca\u4ee5\u4e0a\u7248\u672c\uff01", unsupportedClassVersionError);
            }
            catch (Exception exception) {
                if (!(exception instanceof ConnectException)) throw new WCMException("\u5728\u8f6c\u5316\u6587\u4ef6[" + string + "]\u5230\u683c\u5f0f[" + string2 + "]\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef\uff01", exception);
                throw new ConnectException("\u8fde\u63a5OpenOffice\u670d\u52a1\u5668\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5OpenOffice\u662f\u5426\u5df2\u5b89\u88c5\u6216\u8005\u662f\u5426\u5df2\u7ecf\u542f\u52a8\u8be5\u670d\u52a1\uff01");
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (file == null) throw throwable;
                file.delete();
                throw throwable;
            }
            catch (Exception exception) {
                throw new WCMException("\u4eceOpenOffice\u4e2d\u521b\u5efa\u6587\u6863\uff0c\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u51fa\u73b0\u9519\u8bef\uff01", exception);
            }
        }
        try {}
        catch (Exception exception) {
            throw new WCMException("\u4eceOpenOffice\u4e2d\u521b\u5efa\u6587\u6863\uff0c\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u51fa\u73b0\u9519\u8bef\uff01", exception);
        }
        if (file == null) return string3;
        file.delete();
        return string3;
    }

    private Map getExtFile(String string) throws CMyException {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        String string2 = CMyFile.readFile(string);
        String string3 = CMyString.setStrEndWith(CMyFile.extractFilePath(string), File.separatorChar);
        HtmlElement htmlElement = new HtmlElement();
        htmlElement.fromString(string2);
        List list = htmlElement.getElementsByName("img");
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            HtmlElement htmlElement2 = (HtmlElement)list.get(i);
            String string4 = htmlElement2.getAttributeValue("src");
            if (string4 != null && string4.indexOf("../") != -1) {
                object = string4.split("/");
                string4 = object[((String[])object).length - 1];
            }
            object = string3 + string4;
            hashMap.put(string4.toLowerCase(), (String[])object);
        }
        return hashMap;
    }

    public String convert2Html(String string) throws Exception {
        return this.convert(string, "html");
    }

    public static void main(String[] stringArray) throws Exception {
        OpenOfficeConverter openOfficeConverter = new OpenOfficeConverter();
        System.out.println(openOfficeConverter.convert2Html("D:\\test.doc"));
    }
}

