/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.ExceptionNumber;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class CMyException
extends Exception {
    protected int errNo = 0;
    protected Throwable rootCause = null;

    public CMyException(int n) {
        this.errNo = n;
    }

    public CMyException(int n, String string) {
        super(string);
        this.errNo = n;
    }

    public CMyException(String string) {
        super(string);
    }

    public CMyException(int n, String string, Throwable throwable) {
        super(string);
        this.errNo = n;
        this.rootCause = throwable;
    }

    public CMyException(String string, Throwable throwable) {
        super(string);
        this.rootCause = throwable;
    }

    public int getErrNo() {
        return this.errNo;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public String getErrNoMsg() {
        return ExceptionNumber.getErrNoMsg(this.errNo);
    }

    public String getMyMessage() {
        return super.getMessage();
    }

    public String toString() {
        String string = "[ERR-" + this.errNo + "] " + this.getMyMessage();
        return string;
    }

    public String getMessage() {
        String string = this.toString();
        if (this.rootCause != null) {
            string = string + "\r\n<-- " + this.rootCause.toString();
        }
        return string;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        if (this.rootCause == null) {
            super.printStackTrace(printStream);
        } else {
            Throwable throwable = this.rootCause;
            PrintStream printStream2 = printStream;
            synchronized (printStream2) {
                printStream.println(this.toString());
                Throwable throwable2 = null;
                while (throwable instanceof CMyException) {
                    printStream.println("<-- " + throwable.toString());
                    throwable2 = throwable;
                    if ((throwable = ((CMyException)throwable).getRootCause()) != null) continue;
                    throwable2.printStackTrace(printStream);
                    break;
                }
                if (throwable != null) {
                    printStream.print("<-- ");
                    throwable.printStackTrace(printStream);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        if (this.rootCause == null) {
            super.printStackTrace(printWriter);
        } else {
            Throwable throwable = this.rootCause;
            PrintWriter printWriter2 = printWriter;
            synchronized (printWriter2) {
                printWriter.println(this.toString());
                Throwable throwable2 = null;
                while (throwable instanceof CMyException) {
                    printWriter.print("<-- ");
                    throwable2 = throwable;
                    throwable = ((CMyException)throwable).getRootCause();
                    if (throwable == null) {
                        throwable2.printStackTrace(printWriter);
                        break;
                    }
                    printWriter.println(throwable2.toString());
                }
                if (throwable != null) {
                    printWriter.print("<-- ");
                    throwable.printStackTrace(printWriter);
                }
            }
        }
    }

    public String getStackTraceText() {
        return CMyException.getStackTraceText(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTraceText(Throwable throwable) {
        StringWriter stringWriter = null;
        PrintWriter printWriter = null;
        try {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            String string = stringWriter.toString();
            return string;
        }
        catch (Exception exception) {
            String string = throwable.getMessage();
            return string;
        }
        finally {
            if (stringWriter != null) {
                try {
                    stringWriter.close();
                }
                catch (Exception exception) {}
            }
            if (printWriter != null) {
                try {
                    printWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static final void main(String[] stringArray) {
        CMyException cMyException = new CMyException(1, "my exception 0");
        CMyException cMyException2 = new CMyException(1, "my exception 1", cMyException);
        CMyException cMyException3 = new CMyException(10, "my exception 2", cMyException2);
        cMyException3.printStackTrace(System.out);
        System.out.println("-------------------");
        System.out.println(cMyException3.getMessage());
        System.out.println("-------------------");
        System.out.println(cMyException3.getStackTraceText());
        try {
            int n = 0;
            int n2 = 1 / n;
            System.out.println(n2);
        }
        catch (Exception exception) {
            System.out.println(CMyException.getStackTraceText(exception));
        }
    }
}

