/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class AttributesString {
    public static final String ATTRIBUTE_DELIM = "&";
    private HashMap m_hAttributesMap = null;
    private ArrayList m_arNameList = null;
    private String m_sDelim = null;

    public AttributesString() {
    }

    public AttributesString(String string) {
        this.setAttributes(string);
    }

    public String toString() {
        return this.getAttributes();
    }

    public String getAttributes() {
        int n = this.getNameList().size();
        if (n == 0) {
            return null;
        }
        String string = "";
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                string = string + this.getDelim();
            }
            string = string + this.getAttribute((String)this.getNameList().get(i));
        }
        return string;
    }

    public void setAttributes(String string) {
        if (string == null) {
            return;
        }
        this.clear();
        StringTokenizer stringTokenizer = null;
        stringTokenizer = new StringTokenizer(string, this.getDelim());
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n <= 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            this.putAttributeValue(string3, string4, true);
        }
    }

    public String getAttributeValue(String string) {
        Object object = this.getValue(string = string.toUpperCase());
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            return stringArray[0];
        }
        return null;
    }

    public String[] getAttributeValues(String string) {
        Object object = this.getValue(string = string.toUpperCase());
        if (object == null) {
            return null;
        }
        String[] stringArray = null;
        if (object instanceof String) {
            stringArray = new String[]{(String)object};
        }
        if (object instanceof String[]) {
            stringArray = (String[])object;
        }
        return stringArray;
    }

    private String getAttribute(String string) {
        String string2 = string.toUpperCase();
        Object object = this.getValue(string2);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return string + "=" + (String)object;
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            String string3 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    string3 = string3 + this.getDelim();
                }
                string3 = string3 + string + "=" + stringArray[i];
            }
            return string3;
        }
        return null;
    }

    public void putAttributeValue(String string, String string2) {
        this.putAttributeValue(string, string2, false);
    }

    public HashMap getAttributesMap() {
        if (this.m_hAttributesMap == null) {
            this.m_hAttributesMap = new HashMap(5);
        }
        return this.m_hAttributesMap;
    }

    protected void clear() {
        if (this.m_hAttributesMap == null) {
            return;
        }
        this.m_arNameList.clear();
        this.m_hAttributesMap.clear();
        this.m_hAttributesMap = null;
    }

    private Object getValue(String string) {
        string = string.toUpperCase();
        return this.getAttributesMap().get(string);
    }

    public void putAttributeValue(String string, String string2, boolean bl) {
        String string3 = string.toUpperCase();
        Object object = this.getValue(string3);
        if (object == null) {
            this.getAttributesMap().put(string3, string2);
            this.getNameList().add(string);
            return;
        }
        if (!bl) {
            this.getAttributesMap().put(string3, string2);
            return;
        }
        String[] stringArray = null;
        if (object instanceof String) {
            stringArray = new String[]{(String)object, string2};
        }
        if (object instanceof String[]) {
            String[] stringArray2 = (String[])object;
            stringArray = new String[stringArray2.length + 1];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray[i] = stringArray2[i];
            }
            stringArray[stringArray2.length] = string2;
        }
        if (stringArray != null) {
            this.getAttributesMap().put(string3, stringArray);
        }
    }

    public List getNameList() {
        if (this.m_arNameList == null) {
            this.m_arNameList = new ArrayList(5);
        }
        return this.m_arNameList;
    }

    public String getDelim() {
        if (this.m_sDelim == null) {
            return ATTRIBUTE_DELIM;
        }
        return this.m_sDelim;
    }

    public void setDelim(String string) {
        this.m_sDelim = string;
    }

    public int size() {
        if (this.m_arNameList == null) {
            return 0;
        }
        return this.getNameList().size();
    }

    public boolean containsName(String string) {
        if (string == null) {
            return false;
        }
        return this.getAttributesMap().containsKey(string.toUpperCase());
    }

    public String getNameAt(int n) {
        return (String)this.getNameList().get(n);
    }

    public static void main(String[] stringArray) {
        AttributesString attributesString = new AttributesString("a=1&b=2&c=3");
        System.out.println("a=" + attributesString.getAttributeValue("a"));
        System.out.println("b=" + attributesString.getAttributeValue("b"));
        System.out.println("c=" + attributesString.getAttributeValue("c"));
        System.out.println("Attributelist:" + attributesString.getAttributes());
        System.out.println("Test for pub attribute value:");
        attributesString.putAttributeValue("b", "22");
        attributesString.putAttributeValue("d", "4");
        System.out.println("Attributelist:" + attributesString.getAttributes());
    }
}

