/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.security;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.security.SecureKeys;
import com.trs.infra.util.BASE64DecoderStream;
import com.trs.infra.util.BASE64EncoderStream;
import com.trs.infra.util.CMyString;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class SecureKey
extends BaseObj {
    public static final int OBJ_TYPE = 559084253;
    public static final String DB_TABLE_NAME = "WCMSECUREKEY";
    public static final String DB_ID_NAME = "SECUREKEYID";
    static final String KEYTYPE_DES = "DES";
    static final String KEYTYPE_DSA = "DSA";
    private static Logger s_logger = Logger.getLogger(SecureKey.class);

    public int getWCMType() {
        return 559084253;
    }

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            String string = this.getKeyName();
            if (CMyString.isEmpty(string)) {
                throw new WCMException(1106, I18NMessage.get(SecureKey.class, "SecureKey.label1", "\u5c5e\u6027[KeyName]\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (SecureKey.findByName(string) != null) {
                throw new WCMException(1108, I18NMessage.get(SecureKey.class, "SecureKey.label2", "\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u540d\u4e3a[") + string + I18NMessage.get(SecureKey.class, "SecureKey.label3", "]\u7684SecureKey\u5bf9\u8c61!"));
            }
        }
        return true;
    }

    public static final SecureKey findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (SecureKey)BaseObj.findById(SecureKey.class, n);
    }

    public static final SecureKey createNewInstance() throws WCMException {
        return (SecureKey)BaseObj.createNewInstance(SecureKey.class);
    }

    public static final SecureKey findByKey(Object object) throws WCMException {
        return (SecureKey)BaseObj.findByKey(SecureKey.class, object);
    }

    public static final SecureKey findByName(String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter(DB_TABLE_NAME, "KEYNAME=?", "");
        wCMFilter.addSearchValues(0, CMyString.filterForSQL(string));
        SecureKeys secureKeys = new SecureKeys();
        secureKeys.open(wCMFilter);
        if (secureKeys.isEmpty()) {
            return null;
        }
        return (SecureKey)secureKeys.getAt(0);
    }

    public void update() throws WCMException {
        throw new WCMException(1100, "Unsuport modify");
    }

    public String getKeyName() {
        return this.getPropertyAsString("KEYNAME");
    }

    public boolean setKeyName(String string) throws WCMException {
        return this.setProperty("KEYNAME", string);
    }

    public String getAlgorithm() {
        return this.getPropertyAsString("ALGORITHM");
    }

    public boolean setAlgorithm(String string) throws WCMException {
        return this.setProperty("ALGORITHM", string);
    }

    public int getKeySize() {
        return this.getPropertyAsInt("KEYSIZE", 0);
    }

    public boolean setKeySize(int n) throws WCMException {
        return this.setProperty("KEYSIZE", n);
    }

    public Key getPrivateKey() {
        String string = this.getPropertyAsString("PRIVATEKEY");
        return this.decodeKey(string, true);
    }

    boolean setPrivateKey(Key key) throws WCMException {
        String string = this.encodeKey(key);
        return this.setProperty("PRIVATEKEY", string);
    }

    public Key getPublicKey() {
        String string = this.getPropertyAsString("PUBLICKEY");
        return this.decodeKey(string, false);
    }

    boolean setPublicKey(Key key) throws WCMException {
        String string = this.encodeKey(key);
        return this.setProperty("PUBLICKEY", string);
    }

    private Key decodeKey(String string, boolean bl) {
        try {
            byte[] byArray = BASE64DecoderStream.decode(string);
            if (KEYTYPE_DSA.equals(this.getAlgorithm())) {
                KeyFactory keyFactory = KeyFactory.getInstance(KEYTYPE_DSA);
                if (bl) {
                    PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                    PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                    return privateKey;
                }
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
                PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
                return publicKey;
            }
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, KEYTYPE_DES);
            return secretKeySpec;
        }
        catch (Exception exception) {
            s_logger.error((Object)"decode key failed!", (Throwable)exception);
            return null;
        }
    }

    private String encodeKey(Key key) {
        return new String(BASE64EncoderStream.encode(key.getEncoded()));
    }

    public String toString() {
        return this.getKeyName() + "[Alg-" + this.getAlgorithm() + "]";
    }

    public static void main(String[] stringArray) {
        System.out.println("OBJ_TYPE:" + "com.trs.infra.support.security.SecureKey".hashCode());
    }
}

