/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.infra.persistent.IObjTypeLookup;
import com.trs.infra.util.CMyFile;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ObjTypeLookupImpl
implements IObjTypeLookup {
    public static String CONFIG_FILE = "wcmtypes.ini";
    private static final Logger logger = Logger.getLogger((String)ObjTypeLookupImpl.class.getName());
    private HashMap m_types = new HashMap();
    private boolean m_bLoaded = false;

    public int lookupByClassName(String string) {
        try {
            this.insureLoaded();
            Integer n = (Integer)this.m_types.get(string);
            if (n == null) {
                logger.error((Object)("Type for class " + string + " is required in " + CONFIG_FILE));
                return 0;
            }
            return n;
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to lookup the object type of " + string), (Throwable)exception);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insureLoaded() throws Exception {
        if (this.m_bLoaded) {
            return;
        }
        HashMap hashMap = this.m_types;
        synchronized (hashMap) {
            Map.Entry<Object, Object> entry;
            Properties properties;
            block10: {
                if (this.m_bLoaded) {
                    return;
                }
                logger.debug((Object)("to load " + CONFIG_FILE + " ..."));
                String string = CMyFile.mapResouceFullPath(CONFIG_FILE);
                properties = null;
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(string);
                    properties = new Properties();
                    properties.load(fileInputStream);
                    entry = null;
                    if (fileInputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (fileInputStream == null) throw throwable;
                    fileInputStream.close();
                    throw throwable;
                }
                fileInputStream.close();
            }
            logger.debug((Object)("to parse " + CONFIG_FILE + " ..."));
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    logger.debug((Object)(CONFIG_FILE + " has been loaded successfully!"));
                    this.m_bLoaded = true;
                    return;
                }
                entry = iterator.next();
                try {
                    int n = Integer.parseInt((String)entry.getValue());
                    this.m_types.put(entry.getKey(), new Integer(n));
                }
                catch (Exception exception) {
                    logger.error((Object)("Integer value is required: " + entry.getKey() + "=" + entry.getValue()));
                    continue;
                }
                break;
            }
        }
    }
}

