/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.DreamFactory;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.cache.ICachedPOMgr;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.DebugTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class BaseObjs {
    public static final Integer ID_NOT_LOAD = new Integer(0);
    private static Logger logger = Logger.getLogger(BaseObjs.class);
    public static boolean IS_DEBUG = false;
    protected static final int MODE_NORM = 0;
    protected static final int MODE_ADD = 1;
    protected static final int MODE_EDIT = 2;
    protected static final int POS_UNKNOWN = -1;
    protected static final int POS_BOF = -2;
    protected static final int POS_EOF = -3;
    public static final int BOOKMARK_CURRENT = 0;
    public static final int BOOKMARK_FIRST = 1;
    public static final int BOOKMARK_LAST = 2;
    protected Hashtable m_oObjsBuffer = null;
    protected BaseObjs parentObjs = null;
    protected int maxSize = 0;
    protected Vector vIdList = null;
    protected WCMFilter filter = null;
    protected int currIndex = -1;
    protected int currMode = 0;
    protected BaseObj objNew = null;
    protected int pageSize = 20;
    protected int currPage = -1;
    private int maxBufferSize = 0;
    private int[] oldPages = null;
    private int oldestPageAt = -1;
    private int loadedPageCount = 0;
    protected WCMFilter pageFilterMum = null;
    private boolean bIsLoadText = false;
    private static final int FLAG_NOT_INIT_CACHE_INDEX = -1000;
    private int m_nCacheIndex = -1000;
    public static long DEBUG_USE_TIME = 700L;
    private int m_nRecCount = -1;

    public BaseObjs() {
        this.vIdList = new Vector();
    }

    public BaseObjs(int n, int n2) {
        this.vIdList = new Vector(n, n2);
    }

    protected void finalize() {
        if (this.size() > 0) {
            this.clear();
        }
    }

    public boolean isCached() {
        return this.getCacheIndex() >= 0;
    }

    public int getCacheIndex() {
        if (this.m_nCacheIndex != -1000) {
            return this.m_nCacheIndex;
        }
        try {
            this.m_nCacheIndex = BaseObjs.getCachedPOMgr().getCacheIndex(this.getElementClass());
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(BaseObjs.class, "BaseObjs.label1", "\u83b7\u53d6\u7f13\u51b2\u5bf9\u8c61\u7ba1\u7406\u5668\u5931\u8d25\uff01"), (Throwable)exception);
            this.m_nCacheIndex = -1;
        }
        return this.m_nCacheIndex;
    }

    protected abstract String getDbTableName();

    public abstract String getIdFieldName();

    public abstract Class getElementClass();

    public abstract BaseObjs newInstance() throws Exception;

    public String getClassName(boolean bl) {
        int n;
        String string = this.getClass().getName();
        if (!bl && (n = string.lastIndexOf(46)) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public BaseObjs getParent() {
        return this.parentObjs;
    }

    protected Hashtable getObjsBuffer() {
        if (this.isCached()) {
            try {
                return BaseObjs.getCachedPOMgr().getBuffer(this.getCacheIndex());
            }
            catch (Exception exception) {
                logger.error((Object)I18NMessage.get(BaseObjs.class, "BaseObjs.label2", "\u83b7\u53d6\u7f13\u51b2\u533a\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)exception);
            }
        }
        if (this.m_oObjsBuffer == null) {
            this.m_oObjsBuffer = new Hashtable();
        }
        return this.m_oObjsBuffer;
    }

    public WCMFilter getFilter() {
        if (this.filter == null) {
            this.filter = new WCMFilter();
        }
        return this.filter;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int n) {
        this.maxSize = n > 0 ? n : 0;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public boolean setMaxBufferSize(int n) {
        if (n < 0) {
            n = 0;
        } else if (this.maxSize > 0 && n > this.maxSize) {
            n = this.maxSize;
        }
        if (this.maxBufferSize == n) {
            return false;
        }
        this.maxBufferSize = n;
        this.resetBufferLimit();
        return true;
    }

    private void resetBufferLimit() {
        if (this.oldPages == null) {
            return;
        }
        if (this.maxBufferSize == 0) {
            this.oldPages = null;
        } else {
            int n = this.maxBufferSize / this.pageSize + 1;
            if (n > this.oldPages.length) {
                int[] nArray = new int[n];
                int n2 = this.loadedPageCount;
                if (n2 > this.oldPages.length) {
                    n2 = this.oldPages.length;
                }
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = this.oldPages[i];
                }
                this.oldPages = nArray;
                nArray = null;
            }
        }
    }

    public int size() {
        if (this.m_nRecCount <= 0) {
            return this.vIdList.size();
        }
        return this.m_nRecCount;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.vIdList.clear();
        this.currIndex = -2;
        this.currPage = -1;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean setPageSize(int n) {
        if (this.pageSize == n) {
            return false;
        }
        this.pageSize = n;
        if (this.currPage >= 0) {
            this.currPage = -1;
        }
        return true;
    }

    public int getPageCount() {
        int n = this.size();
        int n2 = n / this.pageSize;
        if (this.pageSize * n2 < n) {
            ++n2;
        }
        return n2;
    }

    public int getCurrPage() {
        return this.currPage;
    }

    public void setCurrPage(int n) {
        if (n <= 0) {
            n = 0;
        }
        this.currPage = n;
    }

    protected boolean ensurePageLoaded(int n) throws WCMException {
        try {
            if (this.isPageLoaded(n)) {
                return true;
            }
            boolean bl = false;
            if (this.maxBufferSize > 0) {
                if (this.getObjsBuffer().size() >= this.maxBufferSize) {
                    this.unloadOldestPage(n);
                } else {
                    bl = true;
                }
            }
            this.loadPage(n);
            if (bl) {
                if (this.oldPages == null) {
                    this.oldPages = new int[this.maxBufferSize / this.pageSize + 1];
                    this.oldestPageAt = 0;
                }
                this.oldPages[this.loadedPageCount++] = n;
            }
            return true;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label3", "\u88c5\u8f7d\u6307\u5b9a\u9875\uff08") + n + I18NMessage.get(BaseObjs.class, "BaseObjs.label4", "\uff09\u5931\u8d25(") + this.getClass().getName() + ".ensurePageLoaded)", exception);
        }
    }

    private boolean loadPage(int n) throws WCMException {
        DebugTimer debugTimer = new DebugTimer();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ResultSetMetaData resultSetMetaData = null;
        String string = "";
        try {
            string = this.makePageSQL(n);
            if (string == null) {
                boolean bl = false;
                return bl;
            }
            connection = this.getDBManager().getConnection();
            statement = connection.prepareStatement(string);
            statement.setMaxRows(this.pageSize);
            if (this.pageSize > 1000) {
                statement.setFetchSize(1000);
            } else {
                statement.setFetchSize(this.pageSize);
            }
            this.setPagePreStmtParams(n, (PreparedStatement)statement);
            debugTimer.start();
            resultSet = statement.executeQuery();
            debugTimer.stop();
            if (logger.isDebugEnabled() && debugTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] executeQuery from db use [" + debugTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + string));
            }
            debugTimer.start();
            while (resultSet.next()) {
                if (resultSetMetaData == null) {
                    resultSetMetaData = resultSet.getMetaData();
                }
                this.loadAObjFromRs(resultSet, resultSetMetaData);
            }
            debugTimer.stop();
            if (logger.isDebugEnabled() && debugTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] get data from db use [" + debugTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + string));
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException sQLException) {
            throw new WCMException(40, I18NMessage.get(BaseObjs.class, "BaseObjs.label5", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + string, sQLException);
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(BaseObjs.class, "BaseObjs.label5", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + string, exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                this.getDBManager().freeConnection(connection);
            }
        }
    }

    private void setPagePreStmtParams(int n, PreparedStatement preparedStatement) throws SQLException {
        int n2;
        int n3 = this.getStartPos(n);
        if (n3 >= (n2 = this.getEndPos(n3)) || n3 < 0) {
            return;
        }
        int n4 = n3;
        int n5 = 1;
        while (n4 < n2) {
            preparedStatement.setInt(n5, this.getIdAt(n4));
            ++n4;
            ++n5;
        }
    }

    private String makePageSQL(int n) throws WCMException {
        int n2;
        int n3 = this.getStartPos(n);
        if (n3 >= (n2 = this.getEndPos(n3)) || n3 < 0) {
            return null;
        }
        if (n2 - n3 > 2000) {
            throw new WCMException(I18NMessage.get(BaseObjs.class, "BaseObjs.label6", "\u6570\u636e\u5e93\u4e0d\u652f\u6301\u4e00\u6b21\u62fc\u51fa2000\u6761\u4ee5\u4e0a\u8bb0\u5f55\u7684\u5206\u9875\u8f7d\u5165SQL\uff01"));
        }
        WCMFilter wCMFilter = this.preparePageFilter(n);
        String string = this.getIdFieldName() + " in(";
        string = string + "?";
        for (int i = n3 + 1; i < n2; ++i) {
            string = string + ", ?";
        }
        string = string + ")";
        wCMFilter.setWhere(string);
        return wCMFilter.toSQL();
    }

    private boolean isPageLoaded(int n) {
        if (this.isCached()) {
            return true;
        }
        int n2 = this.getStartPos(n);
        Object e = this.vIdList.elementAt(n2);
        return this.getObjFromBuffer(e) != null;
    }

    protected BaseObj loadAObjFromRs(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws WCMException {
        try {
            BaseObj baseObj = this.createElementInstance();
            baseObj.setLoadText(this.bIsLoadText);
            baseObj.readFromRs(resultSet, resultSetMetaData);
            int n = this.indexOf(baseObj.getId());
            if (n < 0) {
                return null;
            }
            if (this.getObjsBuffer().containsKey(baseObj.getKey())) {
                BaseObj baseObj2 = (BaseObj)this.getObjsBuffer().get(baseObj.getKey());
                if (baseObj2 == null) {
                    return null;
                }
                baseObj2.resetProperties(baseObj.getAllProperty());
                baseObj.clearProperties();
                baseObj = null;
                return baseObj2;
            }
            this.getObjsBuffer().put(baseObj.getKey(), baseObj);
            return baseObj;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label7", "\u4ece\u8bb0\u5f55\u96c6\u4e2d\u88c5\u8f7d\u5bf9\u8c61\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".loadAObjFromRs\uff09", exception);
        }
    }

    protected BaseObj createElementInstance() throws WCMException {
        return BaseObj.createNewInstance(this.getElementClass());
    }

    protected WCMFilter preparePageFilter(int n) throws WCMException {
        String string = this.getIdListOfPage(n);
        if (string == null) {
            return null;
        }
        if (this.pageFilterMum != null) {
            return this.pageFilterMum;
        }
        this.pageFilterMum = new WCMFilter();
        String string2 = this.getFilter().getSelect();
        if (string2 == null || string2.trim().length() == 0) {
            string2 = "*";
        }
        if (string2.toUpperCase().indexOf("*") < 0 && string2.toUpperCase().indexOf(this.getIdFieldName().toUpperCase()) < 0) {
            string2 = string2 + "," + this.getDbTableName() + "." + this.getIdFieldName();
        }
        this.pageFilterMum.setSelect(string2);
        this.pageFilterMum.setFrom(this.getDbTableName());
        return this.pageFilterMum;
    }

    protected String getIdListOfPage(int n) throws WCMException {
        String string = null;
        try {
            int n2 = this.getStartPos(n);
            int n3 = this.getEndPos(n2);
            if (n3 <= n2) {
                return null;
            }
            string = "?";
            for (int i = n2 + 1; i < n3; ++i) {
                string = ",?";
            }
            return string;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label8", "\u63d0\u53d6\u6307\u5b9a\u9875\u5185\u7684\u5143\u7d20ID\u5931\u8d25\uff08") + this.getClass().getName() + ".getIdListOfPage\uff09", exception);
        }
    }

    protected int getEndPos(int n) {
        int n2 = n + this.pageSize;
        int n3 = this.size();
        if (n2 > n3) {
            n2 = n3;
        }
        return n2;
    }

    protected int getStartPos(int n) {
        return n * this.pageSize;
    }

    protected BaseObj getObjFromBuffer(Object object) {
        return (BaseObj)this.getObjsBuffer().get(object);
    }

    protected BaseObj getObjFromBuffer(int n) {
        return this.getObjFromBuffer(new Integer(n));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void isValidSQL() throws WCMException {
        if (this.isCached()) {
            return;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "";
        try {
            if (this.currMode == 2) {
                throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label9", "\u7f16\u8f91\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u5237\u65b0\u96c6\u5408\uff01") + this.getClass().getName());
            }
            this.clear();
            String string2 = this.getDbTableName();
            String string3 = this.getIdFieldName().toUpperCase();
            String string4 = this.filter.getSelect().toUpperCase();
            if (string4.length() == 0) {
                string4 = string2 + ".*";
            } else if (string4.indexOf("*") < 0 && string4.indexOf(string3) < 0) {
                string4 = string4 + "," + string2 + "." + string3;
            }
            this.filter.setSelect(string4);
            string4 = this.filter.getFrom().toUpperCase();
            if (string4.length() == 0) {
                this.filter.setFrom(string2);
            } else if (string4.indexOf(string2) < 0) {
                this.filter.setFrom(string4 + "," + string2);
            }
            string = this.filter.toSQL();
            connection = this.getDBManager().getConnection();
            statement = connection.createStatement();
            statement.setMaxRows(1);
            resultSet = statement.executeQuery(string);
            resultSet.close();
        }
        catch (SQLException sQLException) {
            try {
                throw new WCMException(40, I18NMessage.get(BaseObjs.class, "BaseObjs.label10", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".isValidSQL)\uff1aSQL=" + string, sQLException);
                catch (Exception exception) {
                    throw new WCMException(0, I18NMessage.get(BaseObjs.class, "BaseObjs.label10", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".isValidSQL)\uff1aSQL=" + string, exception);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (connection == null) throw throwable;
                this.getDBManager().freeConnection(connection);
                throw throwable;
            }
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (connection == null) return;
        this.getDBManager().freeConnection(connection);
    }

    private String getSelectSql(String string, String string2) {
        if (string != null && string.trim().length() > 0) {
            Object object;
            Vector<Object> vector = new Vector<Object>(4);
            string2 = string2.toUpperCase();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreElements()) {
                object = ((String)stringTokenizer.nextElement()).trim();
                int n = ((String)object).indexOf(46);
                if (n > 0) {
                    object = ((String)object).substring(n + 1);
                }
                vector.add(object);
            }
            string = string.toUpperCase();
            object = new StringTokenizer(string, ",");
            while (((StringTokenizer)object).hasMoreElements()) {
                String string3 = ((String)((StringTokenizer)object).nextElement()).trim();
                int n = string3.indexOf(32);
                if (n > 0) {
                    string3 = string3.substring(0, n);
                }
                String string4 = string3;
                n = string3.indexOf(46);
                if (n > 0) {
                    string4 = string3.substring(n + 1);
                }
                if (vector.indexOf(string4) >= 0) continue;
                string2 = string2 + "," + string3;
            }
        }
        return string2;
    }

    private WCMFilter getIdFilter() {
        String string;
        boolean bl;
        String string2 = this.getDbTableName();
        String string3 = this.getIdFieldName();
        WCMFilter wCMFilter = new WCMFilter(this.filter);
        String string4 = this.filter.getFrom();
        String string5 = this.filter.getSelect();
        if (string4 == null || (string4 = string4.trim()).length() == 0) {
            wCMFilter.setFrom(string2);
        }
        boolean bl2 = bl = string4.indexOf(44) >= 0;
        if (string5 == null || (string5 = string5.trim()).length() == 0) {
            string = bl ? string2 + "." + string3 : string3;
        } else if (string5.indexOf(42) >= 0) {
            string = bl ? string2 + "." + string3 : string3;
        } else {
            string = this.filter.findSelectField(string3);
            if (string == null) {
                string = bl ? string2 + "." + string3 : string3;
            } else if (bl && (string = string.trim()).equalsIgnoreCase(string3)) {
                string = string2 + "." + string3;
            }
        }
        string = this.getFilter().getOderSelect().length() == 0 ? this.getSelectSql(this.filter.getOrder(), string) : string + "," + this.getFilter().getOderSelect();
        if ((" " + string.toUpperCase()).indexOf(" DISTINCT ") < 0) {
            wCMFilter.setSelect(" distinct " + string);
        } else {
            wCMFilter.setSelect(string);
        }
        if (this.filter.getMaxRowNumber() > 0) {
            wCMFilter.setMaxRowNumber(this.filter.getMaxRowNumber());
        }
        return wCMFilter;
    }

    private WCMFilter getCurrDataFilter() {
        String string = this.getDbTableName();
        String string2 = this.getIdFieldName();
        WCMFilter wCMFilter = new WCMFilter(this.filter);
        String string3 = this.filter.getFrom();
        String string4 = this.filter.getSelect();
        if (string3 == null || (string3 = string3.trim()).length() == 0) {
            wCMFilter.setFrom(string);
        }
        if (string4 == null || (string4 = string4.trim()).length() == 0) {
            string4 = string3.indexOf(44) >= 0 ? string + ".*" : "*";
        } else if (string4.indexOf(42) < 0 && wCMFilter.findSelectField(string2) == null) {
            string4 = string + "." + string2 + "," + string4;
        }
        wCMFilter.setSelect(string4);
        return wCMFilter;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void refresh() throws WCMException {
        DebugTimer debugTimer = new DebugTimer();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "";
        WCMFilter wCMFilter = null;
        try {
            if (this.currMode == 2) {
                throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label9", "\u7f16\u8f91\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u5237\u65b0\u96c6\u5408\uff01") + this.getClass().getName());
            }
            this.clear();
            wCMFilter = this.getIdFilter();
            string = wCMFilter.toSQL();
            connection = this.getDBManager().getConnection();
            statement = connection.prepareStatement(string);
            if (wCMFilter.getMaxRowNumber() > 0) {
                statement.setMaxRows(wCMFilter.getMaxRowNumber());
                if (wCMFilter.getMaxRowNumber() > 1000) {
                    statement.setFetchSize(1000);
                } else {
                    statement.setFetchSize(wCMFilter.getMaxRowNumber());
                }
            }
            this.setParameters((PreparedStatement)statement);
            debugTimer.start();
            resultSet = statement.executeQuery();
            debugTimer.stop();
            if (logger.isDebugEnabled() && debugTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("get id from db use [" + debugTimer.getTime() + "]ms"));
                logger.debug((Object)wCMFilter);
            }
            while (resultSet.next()) {
                int n = resultSet.getInt(this.getIdFieldName());
                Integer n2 = new Integer(n);
                if (this.vIdList.indexOf(n2) >= 0) continue;
                this.vIdList.addElement(n2);
            }
            resultSet.close();
            this.currIndex = this.size() > 0 ? 0 : -2;
        }
        catch (SQLException sQLException) {
            try {
                throw new WCMException(40, I18NMessage.get(BaseObjs.class, "BaseObjs.label11", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff08") + this.getClass().getName() + ".refresh)\uff1a\n" + wCMFilter, sQLException);
                catch (Exception exception) {
                    throw new WCMException(0, I18NMessage.get(BaseObjs.class, "BaseObjs.label10", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)", exception);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (connection == null) throw throwable;
                this.getDBManager().freeConnection(connection);
                throw throwable;
            }
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (connection == null) return;
        this.getDBManager().freeConnection(connection);
    }

    public int getSelectCount() throws WCMException {
        WCMFilter wCMFilter = new WCMFilter();
        wCMFilter.copy(this.getIdFilter());
        wCMFilter.setSelect("count(*)");
        wCMFilter.setOrder("");
        wCMFilter.setMaxRowNumber(0);
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getDBManager().getConnection();
            statement = connection.prepareStatement(wCMFilter.toSQL());
            statement.setFetchSize(1);
            ResultSet resultSet = statement.executeQuery();
            resultSet.next();
            int n = resultSet.getInt(1);
            resultSet.close();
            int n2 = n;
            return n2;
        }
        catch (Exception exception) {
            throw new WCMException(40, I18NMessage.get(BaseObjs.class, "BaseObjs.label12", "\u83b7\u53d6count\u5931\u8d25\uff01"), exception);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                this.getDBManager().freeConnection(connection);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void loadCurrentData(int n) throws WCMException {
        DebugTimer debugTimer = new DebugTimer();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "";
        try {
            if (this.currMode == 2) {
                throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label9", "\u7f16\u8f91\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u5237\u65b0\u96c6\u5408\uff01") + this.getClass().getName());
            }
            this.clear();
            WCMFilter wCMFilter = this.getCurrDataFilter();
            string = wCMFilter.toSQL();
            connection = this.getDBManager().getConnection();
            statement = connection.prepareStatement(string);
            statement.setFetchSize(n);
            statement.setMaxRows(n);
            this.setParameters((PreparedStatement)statement);
            debugTimer.start();
            resultSet = statement.executeQuery();
            debugTimer.stop();
            if (logger.isDebugEnabled() && debugTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadCurrentData[MaxSize=" + n + "] execute query from db use [" + debugTimer.getTime() + "]ms"));
                logger.debug((Object)wCMFilter);
            }
            debugTimer.start();
            ResultSetMetaData resultSetMetaData = null;
            while (resultSet.next()) {
                int n2 = resultSet.getInt(this.getIdFieldName());
                Integer n3 = new Integer(n2);
                if (this.vIdList.indexOf(n3) < 0) {
                    this.vIdList.addElement(n3);
                }
                if (resultSetMetaData == null) {
                    resultSetMetaData = resultSet.getMetaData();
                }
                this.loadAObjFromRs(resultSet, resultSetMetaData);
            }
            resultSet.close();
            debugTimer.stop();
            if (logger.isDebugEnabled() && debugTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadCurrentData[MaxSize=" + n + "] read data from db use [" + debugTimer.getTime() + "]ms"));
                logger.debug((Object)wCMFilter);
            }
            this.currIndex = this.size() > 0 ? 0 : -2;
        }
        catch (SQLException sQLException) {
            try {
                throw new WCMException(40, I18NMessage.get(BaseObjs.class, "BaseObjs.label10", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)\uff1aSQL=" + string, sQLException);
                catch (Exception exception) {
                    throw new WCMException(0, I18NMessage.get(BaseObjs.class, "BaseObjs.label10", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)\uff1aSQL=" + string, exception);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (connection == null) throw throwable;
                this.getDBManager().freeConnection(connection);
                throw throwable;
            }
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (connection == null) return;
        this.getDBManager().freeConnection(connection);
    }

    private void setParameters(PreparedStatement preparedStatement) throws WCMException {
        if (preparedStatement == null || this.filter == null) {
            return;
        }
        List list = this.filter.getSearchValues();
        DBManager.setParameters(preparedStatement, list);
    }

    public synchronized void open(WCMFilter wCMFilter) throws WCMException {
        if (this.filter == null) {
            this.filter = new WCMFilter();
        }
        this.filter.copy(wCMFilter);
        this.setPageSize(this.filter.getPageSize());
        this.setMaxBufferSize(this.filter.getPageSize());
        if (this.getMaxSize() > 0) {
            this.filter.setMaxRowNumber(this.getMaxSize());
        } else if (this.filter.getMaxRowNumber() > 0) {
            this.setMaxSize(this.filter.getMaxRowNumber());
        }
        int n = this.getMaxSize();
        if (this.filter.isForceFirstLoadIds() || n <= 0 || n > 20 && n > this.getMaxBufferSize() || this.isCached()) {
            this.refresh();
        } else {
            this.loadCurrentData(this.getMaxSize());
        }
    }

    public synchronized BaseObjs filter(WCMFilter wCMFilter) throws WCMException {
        try {
            WCMFilter wCMFilter2 = new WCMFilter(this.filter);
            wCMFilter2.mergeWith(wCMFilter);
            BaseObjs baseObjs = this.newInstance();
            baseObjs.open(wCMFilter2);
            return baseObjs;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label13", "\u7b5b\u9009\u96c6\u5408\u751f\u6210\u5b50\u96c6\u5931\u8d25\uff08") + this.getClass().getName() + ".filter\uff09", exception);
        }
    }

    public int getIdAt(int n) {
        Object e = this.vIdList.elementAt(n);
        return e == null ? 0 : (Integer)e;
    }

    public BaseObj getAt(int n) {
        try {
            Object e = this.vIdList.elementAt(n);
            if (e == null) {
                this.currIndex = n >= 0 ? -3 : -2;
                return null;
            }
            this.currIndex = n;
            BaseObj baseObj = this.getObjFromBuffer(e);
            if (this.isCached()) {
                return baseObj;
            }
            if (baseObj != null) {
                return baseObj;
            }
            if (!this.ensurePageLoaded(n / this.pageSize)) {
                return null;
            }
            return this.getObjFromBuffer(e);
        }
        catch (Exception exception) {
            logger.error((Object)("Fail to get the [" + n + "] obj!"), (Throwable)exception);
            return null;
        }
    }

    public synchronized int indexOf(int n) {
        return this.vIdList.indexOf(new Integer(n));
    }

    public synchronized int indexOf(int n, int n2) {
        return this.vIdList.indexOf(new Integer(n), n2);
    }

    public synchronized int indexOf(Integer n) {
        return this.vIdList.indexOf(n);
    }

    public synchronized int indexOf(BaseObj baseObj) {
        int n = this.size();
        int n2 = this.currIndex;
        BaseObj baseObj2 = null;
        for (int i = 0; i < n; ++i) {
            baseObj2 = this.getAt(i);
            if (baseObj2 == null || !baseObj2.equals(baseObj)) continue;
            this.currIndex = n2;
            return i;
        }
        this.currIndex = n2;
        return -1;
    }

    public synchronized BaseObj getById(int n) {
        int n2 = this.indexOf(n);
        if (n2 < 0) {
            this.currIndex = -3;
            return null;
        }
        return this.getAt(n2);
    }

    public boolean isBOF() {
        return this.currIndex == -2 || this.size() == 0;
    }

    public boolean isEOF() {
        return this.currIndex == -3 || this.size() == 0;
    }

    public int position() {
        return this.currIndex;
    }

    public int moveNext() {
        if (this.currIndex != -3) {
            int n = this.size();
            this.currIndex = n == 0 ? -3 : (this.currIndex == -2 ? 0 : (this.currIndex >= n - 1 ? -3 : this.currIndex + 1));
        }
        return this.currIndex;
    }

    public int movePrevious() {
        if (this.currIndex != -2) {
            this.currIndex = this.size() == 0 ? -2 : (this.currIndex == -3 ? this.size() - 1 : (this.currIndex == 0 ? -2 : this.currIndex - 1));
        }
        return this.currIndex;
    }

    public int moveFirst() {
        this.currIndex = this.size() == 0 ? -2 : 0;
        return this.currIndex;
    }

    public int moveLast() {
        int n = this.size();
        this.currIndex = n == 0 ? -3 : n - 1;
        return this.currIndex;
    }

    public int moveTo(int n) {
        this.currIndex = n < 0 ? -2 : (n >= this.size() ? -2 : n);
        return this.currIndex;
    }

    public int move(int n) {
        if (n == 0) {
            return this.currIndex;
        }
        switch (this.currIndex) {
            case -2: {
                if (n <= 0) break;
                this.moveTo(n - 1);
                break;
            }
            case -3: {
                if (n >= 0) break;
                this.moveTo(this.size() + n);
                break;
            }
            default: {
                this.moveTo(this.currIndex + n);
            }
        }
        return this.currIndex;
    }

    public int move(int n, int n2) {
        if (n == 0) {
            return this.currIndex;
        }
        switch (n2) {
            case 1: {
                this.moveTo(n);
                break;
            }
            case 2: {
                if (n > 0) {
                    this.currIndex = -3;
                    break;
                }
                int n3 = this.size();
                if (n3 == 0) {
                    this.currIndex = -2;
                    break;
                }
                this.moveTo(n3 - 1 + n);
                break;
            }
            default: {
                this.move(n);
            }
        }
        return this.currIndex;
    }

    public BaseObj getCurrent() {
        return this.getAt(this.currIndex);
    }

    public final BaseObj addNew() throws WCMException {
        if (this.currMode != 0) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label15", "\u5f53\u524d\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u65b0\u589e\u5143\u7d20(") + this.getClass().getName() + ".addNew)");
        }
        try {
            this.objNew = BaseObj.createNewInstance(this.getElementClass());
            this.currMode = 1;
            return this.objNew;
        }
        catch (Exception exception) {
            this.currMode = 0;
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label16", "\u521b\u5efa\u65b0\u5143\u7d20\u65f6\u5931\u8d25\uff08") + this.getClassName(false) + ".addNew\uff09", exception);
        }
    }

    public synchronized boolean addElement(BaseObj baseObj) throws WCMException {
        if (baseObj == null) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label17", "\u6307\u5b9a\u6dfb\u52a0\u7684\u5143\u7d20\u4e3a\u7a7a(") + this.getClass().getName() + ".addElement)");
        }
        try {
            if (!baseObj.isValidInstance()) {
                baseObj.insert();
            } else if (this.indexOf(baseObj.getId()) >= 0) {
                return false;
            }
            this.vIdList.addElement(new Integer(baseObj.getId()));
            if (!this.isCached()) {
                this.getObjsBuffer().put(baseObj.getKey(), baseObj);
            }
            this.currIndex = this.size() - 1;
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label18", "\u6dfb\u52a0\u5143\u7d20\u5230\u96c6\u5408\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".addElement).", exception);
        }
    }

    public synchronized boolean addElement(BaseObj baseObj, int n) throws WCMException {
        if (baseObj == null) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label17", "\u6307\u5b9a\u6dfb\u52a0\u7684\u5143\u7d20\u4e3a\u7a7a(") + this.getClass().getName() + ".addElement)");
        }
        if (this.size() <= n) {
            return this.addElement(baseObj);
        }
        try {
            if (!baseObj.isValidInstance()) {
                baseObj.insert();
            } else if (this.indexOf(baseObj.getId()) >= 0) {
                return false;
            }
            this.vIdList.add(n, new Integer(baseObj.getId()));
            if (!this.isCached()) {
                this.getObjsBuffer().put(baseObj.getKey(), baseObj);
            }
            this.currIndex = n;
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label18", "\u6dfb\u52a0\u5143\u7d20\u5230\u96c6\u5408\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".addElement).", exception);
        }
    }

    protected void updateElement(BaseObj baseObj) throws WCMException {
        if (baseObj == null) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label19", "\u6307\u5b9a\u66f4\u65b0\u7684\u5143\u7d20\u4e3a\u7a7a(") + this.getClass().getName() + ".updateElement)");
        }
        baseObj.update();
    }

    public boolean set(String string, Object object) throws WCMException {
        switch (this.currMode) {
            case 1: {
                if (this.objNew == null) {
                    throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label20", "\u65b0\u589e\u5bf9\u8c61\u4e3a\u7a7a(") + this.getClass().getName() + ".set)");
                }
                return this.objNew.setProperty(string, object);
            }
            case 2: {
                BaseObj baseObj = this.getCurrent();
                if (baseObj == null) {
                    throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label21", "\u4fee\u6539\u7684\u5bf9\u8c61\u4e3a\u7a7a(") + this.getClass().getName() + ".set)");
                }
                return baseObj.setProperty(string, object);
            }
        }
        throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label22", "\u5f53\u524d\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u4fee\u6539\u5143\u7d20\u5c5e\u6027(") + this.getClass().getName() + ".set)");
    }

    public void update() throws WCMException {
        switch (this.currMode) {
            case 1: {
                this.addElement(this.objNew);
                this.objNew = null;
                this.currMode = 0;
                break;
            }
            case 2: {
                this.updateElement(this.getCurrent());
                this.currMode = 0;
                break;
            }
            default: {
                throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label23", "\u975e\u66f4\u65b0\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u6267\u884c\u66f4\u65b0\u64cd\u4f5c(") + this.getClass().getName() + ".update)");
            }
        }
    }

    protected boolean removeElement(BaseObj baseObj, int n, boolean bl) throws WCMException {
        try {
            if (bl) {
                baseObj.delete();
                if (!baseObj.isCached() && this.getObjsBuffer().remove(baseObj.getKey()) == null) {
                    return false;
                }
            }
            this.vIdList.removeElementAt(n);
            this.currIndex = n >= this.size() ? -3 : n;
            return true;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label24", "\u4ece\u96c6\u5408\u4e2d\u5220\u9664\u5143\u7d20\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".removeElement).", exception);
        }
    }

    public synchronized boolean remove(BaseObj baseObj, boolean bl) throws WCMException {
        if (this.currMode != 0) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label25", "\u975e\u666e\u901a\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u6267\u884c\u5220\u9664\u64cd\u4f5c(") + this.getClass().getName() + ".remove)");
        }
        int n = this.indexOf(baseObj);
        if (n < 0) {
            return false;
        }
        return this.removeElement(baseObj, n, bl);
    }

    public synchronized boolean remove(BaseObj baseObj) throws WCMException {
        return this.remove(baseObj, true);
    }

    public synchronized boolean remove(int n, boolean bl) throws WCMException {
        if (this.currMode != 0) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label25", "\u975e\u666e\u901a\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u6267\u884c\u5220\u9664\u64cd\u4f5c(") + this.getClass().getName() + ".remove)");
        }
        int n2 = this.indexOf(n);
        if (n2 < 0) {
            return false;
        }
        BaseObj baseObj = this.getAt(n2);
        return this.removeElement(baseObj, n2, bl);
    }

    public synchronized boolean remove(int n) throws WCMException {
        return this.remove(n, true);
    }

    public synchronized boolean remove(boolean bl) throws WCMException {
        if (this.currMode != 0) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label25", "\u975e\u666e\u901a\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u6267\u884c\u5220\u9664\u64cd\u4f5c(") + this.getClass().getName() + ".remove)");
        }
        BaseObj baseObj = this.getCurrent();
        if (baseObj == null) {
            return false;
        }
        return this.removeElement(baseObj, this.currIndex, bl);
    }

    public synchronized boolean remove() throws WCMException {
        return this.remove(true);
    }

    public synchronized boolean removeAt(int n, boolean bl) throws WCMException {
        if (this.currMode != 0) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label25", "\u975e\u666e\u901a\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u6267\u884c\u5220\u9664\u64cd\u4f5c(") + this.getClass().getName() + ".remove)");
        }
        BaseObj baseObj = this.getAt(n);
        if (baseObj == null) {
            this.vIdList.remove(n);
            return true;
        }
        return this.removeElement(baseObj, n, bl);
    }

    public synchronized boolean removeAt(int n) throws WCMException {
        return this.removeAt(n, true);
    }

    public synchronized void removeAll(boolean bl) throws WCMException {
        if (this.currMode != 0) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label25", "\u975e\u666e\u901a\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u6267\u884c\u5220\u9664\u64cd\u4f5c(") + this.getClass().getName() + ".remove)");
        }
        if (this.isEmpty()) {
            return;
        }
        BaseObj baseObj = null;
        for (int i = this.size() - 1; i >= 0; --i) {
            baseObj = this.getAt(i);
            if (baseObj == null) continue;
            this.removeElement(baseObj, i, bl);
        }
    }

    public synchronized void removeAll() throws WCMException {
        this.removeAll(true);
    }

    public synchronized void addWith(BaseObjs baseObjs) throws WCMException {
        if (!baseObjs.getClass().equals(this.getClass())) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label26", "\u6307\u5b9a\u96c6\u5408\u5bf9\u8c61\u7c7b\u578b\u4e0d\u5339\u914d\uff08") + this.getClass().getName() + ".addWith\uff09");
        }
        if (baseObjs == null || baseObjs.isEmpty()) {
            return;
        }
        for (int i = 0; i < baseObjs.size(); ++i) {
            BaseObj baseObj = baseObjs.getAt(i);
            if (baseObj == null) continue;
            this.addElement(baseObj);
        }
    }

    public synchronized void minusWith(BaseObjs baseObjs) throws WCMException {
        if (!baseObjs.getClass().equals(this.getClass())) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label26", "\u6307\u5b9a\u96c6\u5408\u5bf9\u8c61\u7c7b\u578b\u4e0d\u5339\u914d\uff08") + this.getClass().getName() + ".addWith\uff09");
        }
        if (baseObjs == null || baseObjs.isEmpty()) {
            return;
        }
        for (int i = 0; i < baseObjs.size(); ++i) {
            int n;
            BaseObj baseObj = baseObjs.getAt(i);
            if (baseObj == null || (n = this.indexOf(baseObj)) < 0) continue;
            this.removeAt(n, false);
        }
    }

    public String getIdListAsString(char c) {
        String string = null;
        Object var3_3 = null;
        for (int i = 0; i < this.vIdList.size(); ++i) {
            var3_3 = this.vIdList.elementAt(i);
            if (var3_3 == null) continue;
            int n = var3_3;
            string = string == null ? String.valueOf(n) : string + c + String.valueOf(n);
        }
        return string;
    }

    public String getIdListAsString() {
        return this.getIdListAsString(',');
    }

    public synchronized void setFilter(WCMFilter wCMFilter) {
        if (this.filter == null) {
            this.filter = new WCMFilter();
        }
        this.filter.copy(wCMFilter);
    }

    public synchronized void setSelect(String string) {
        if (this.filter == null) {
            this.filter = new WCMFilter();
        }
        this.filter.setSelect(string);
    }

    public synchronized void setOrder(String string) {
        if (this.filter == null) {
            this.filter = new WCMFilter();
        }
        this.filter.setOrder(string);
    }

    public static BaseObjs createInstance(String string) throws WCMException {
        try {
            return BaseObjs.createInstance(Class.forName(string));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new WCMException(1351, I18NMessage.get(BaseObjs.class, "BaseObjs.label28", "\u521b\u5efa\u5bf9\u8c61[") + string + I18NMessage.get(BaseObjs.class, "BaseObjs.label29", "]\u5b9e\u4f8b\u5931\u8d25!"), exception);
        }
    }

    public static BaseObjs createInstance(Class clazz) throws WCMException {
        try {
            return (BaseObjs)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new WCMException(1351, I18NMessage.get(BaseObjs.class, "BaseObjs.label28", "\u521b\u5efa\u5bf9\u8c61[") + clazz.getName() + I18NMessage.get(BaseObjs.class, "BaseObjs.label29", "]\u5b9e\u4f8b\u5931\u8d25!"), exception);
        }
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager dBManager = DBManager.getDBManager();
        if (dBManager == null) {
            throw new WCMException(10, I18NMessage.get(BaseObjs.class, "BaseObjs.label30", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(BaseObjs.class, "BaseObjs.label31", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return dBManager;
    }

    private int unloadOldestPage(int n) {
        if (this.oldPages == null || this.oldestPageAt < 0) {
            return -1;
        }
        int n2 = this.oldPages[this.oldestPageAt];
        this.oldPages[this.oldestPageAt] = n;
        ++this.oldestPageAt;
        if (this.oldestPageAt >= this.oldPages.length) {
            this.oldestPageAt = 0;
        }
        int n3 = this.getStartPos(n2);
        Object var4_4 = null;
        int n4 = this.size();
        if (n4 > n3 + this.pageSize) {
            n4 = n3 + this.pageSize;
        }
        for (int i = n3; i < n4; ++i) {
            var4_4 = this.vIdList.elementAt(i);
            this.getObjsBuffer().remove(var4_4);
        }
        return n2;
    }

    public int getQueryCount() throws WCMException {
        int n = this.size();
        if (this.maxSize <= 0 || n < this.maxSize) {
            return n;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        int n2 = 0;
        String string = "";
        try {
            connection = this.getDBManager().getConnection();
            statement = connection.createStatement();
            WCMFilter wCMFilter = new WCMFilter(this.filter);
            wCMFilter.setSelect("count(" + this.getDbTableName() + "." + this.getIdFieldName() + ")");
            wCMFilter.setOrder("");
            string = wCMFilter.toSQL();
            resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            throw new WCMException(40, I18NMessage.get(BaseObjs.class, "BaseObjs.label32", "\u8f7d\u5165\u672c\u6b21\u96c6\u5408\u67e5\u8be2\u7684\u8bb0\u5f55\u6570\u5931\u8d25\uff08") + this.getClass().getName() + ".loadRecCount)\uff1aSQL=" + string, sQLException);
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(BaseObjs.class, "BaseObjs.label32", "\u8f7d\u5165\u672c\u6b21\u96c6\u5408\u67e5\u8be2\u7684\u8bb0\u5f55\u6570\u5931\u8d25\uff08") + this.getClass().getName() + ".loadRecCount)\uff1aSQL=" + string, exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                this.getDBManager().freeConnection(connection);
            }
        }
        return n2;
    }

    public void cancelUpdateAll(int n) {
        if (n <= 0) {
            return;
        }
        switch (this.currMode) {
            case 1: {
                this.objNew = null;
                this.currMode = 0;
                break;
            }
            case 2: {
                int n2 = this.size() > n ? n : this.size();
                for (int i = 0; i < n2; ++i) {
                    try {
                        this.getAt(i).cancelUpdate();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break;
            }
        }
    }

    public void cancelUpdateAll() {
        this.cancelUpdateAll(this.size());
    }

    public void cancelUpdate() {
        switch (this.currMode) {
            case 1: {
                this.objNew = null;
                this.currMode = 0;
                break;
            }
            case 2: {
                try {
                    BaseObj baseObj = this.getCurrent();
                    if (baseObj != null) {
                        baseObj.cancelUpdate();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.currMode = 0;
            }
        }
    }

    public void setLoadText(boolean bl) {
        this.bIsLoadText = bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reloadSpecailData(String string, String string2, String string3) throws WCMException {
        boolean bl;
        Statement statement;
        Connection connection;
        block28: {
            if (this.isCached()) {
                logger.error((Object)I18NMessage.get(BaseObjs.class, "BaseObjs.label33", "\u7f13\u51b2\u5bf9\u8c61\u6267\u884creloadSpecailData!"));
                return true;
            }
            connection = null;
            statement = null;
            ResultSet resultSet = null;
            ResultSetMetaData resultSetMetaData = null;
            String string4 = "";
            try {
                WCMFilter wCMFilter = new WCMFilter();
                String string5 = this.getDbTableName() + "." + this.getIdFieldName();
                if (string3 != null && string3.toUpperCase().indexOf("*") < 0) {
                    ArrayList<String> arrayList = new ArrayList<String>(20);
                    StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken().trim().toUpperCase());
                    }
                    stringTokenizer = new StringTokenizer(string3, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string6 = stringTokenizer.nextToken().trim().toUpperCase();
                        if (arrayList.indexOf(string6) >= 0) continue;
                        string5 = string5 + "," + string6;
                        arrayList.add(string6);
                    }
                    stringTokenizer = null;
                    arrayList.clear();
                }
                wCMFilter.setSelect(string5);
                wCMFilter.setWhere(string2);
                if (string == null || string.trim().length() <= 0) {
                    wCMFilter.setFrom(this.getDbTableName());
                } else if (string.indexOf(this.getDbTableName()) >= 0) {
                    wCMFilter.setFrom(string);
                } else {
                    wCMFilter.setFrom(this.getDbTableName() + "," + string);
                }
                string4 = wCMFilter.toSQL();
                connection = this.getDBManager().getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string4);
                while (resultSet.next()) {
                    if (resultSetMetaData == null) {
                        resultSetMetaData = resultSet.getMetaData();
                    }
                    this.loadAObjFromRs(resultSet, resultSetMetaData);
                }
                bl = true;
                if (resultSet == null) break block28;
            }
            catch (SQLException sQLException) {
                try {
                    throw new WCMException(40, I18NMessage.get(BaseObjs.class, "BaseObjs.label34", " \u91cd\u65b0\u88c5\u8f7d\u6307\u5b9a\u7684\u6570\u636e\u5931\u8d25\uff08") + this.getClass().getName() + ".reloadSpecailData)\uff1aSQL=" + string4, sQLException);
                    catch (Exception exception) {
                        throw new WCMException(0, I18NMessage.get(BaseObjs.class, "BaseObjs.label35", "\u91cd\u65b0\u88c5\u8f7d\u6307\u5b9a\u7684\u6570\u636e\u5931\u8d25\uff08") + this.getClass().getName() + ".reloadSpecailData)\uff1aSQL=" + string4, exception);
                    }
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        this.getDBManager().freeConnection(connection);
                    }
                    throw throwable;
                }
            }
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (connection != null) {
            this.getDBManager().freeConnection(connection);
        }
        return bl;
    }

    public void addElement(String string) {
        int[] nArray = CMyString.splitToInt(string, ",");
        int n = nArray.length;
        if (n <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.addElement(nArray[i]);
        }
        this.currIndex = 0;
    }

    public void addElements(BaseObjs baseObjs) {
        if (baseObjs == null || baseObjs.isEmpty()) {
            return;
        }
        int n = baseObjs.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.addElement(baseObjs.getAt(i));
                continue;
            }
            catch (Exception exception) {
                logger.warn((Object)("Exception to add element![Index=" + i + "]"), (Throwable)exception);
            }
        }
    }

    public void addElement(int n) {
        this.addElement(new Integer(n));
    }

    public void addElement(Integer n) {
        if (this.vIdList.indexOf(n) >= 0) {
            return;
        }
        this.vIdList.addElement(n);
    }

    public void addElement(int n, int n2) {
        if (this.size() <= n2) {
            this.addElement(n);
            return;
        }
        Integer n3 = new Integer(n);
        if (this.vIdList.indexOf(n3) >= 0) {
            return;
        }
        this.vIdList.add(n2, n3);
        this.currIndex = n2;
    }

    protected static ICachedPOMgr getCachedPOMgr() throws WCMException {
        ICachedPOMgr iCachedPOMgr = (ICachedPOMgr)DreamFactory.createObjectById("ICachedPOMgr");
        if (iCachedPOMgr == null) {
            throw new WCMException(10, "ICachedPOMgr Config Error!");
        }
        return iCachedPOMgr;
    }

    public void loadObjsOfCurrPage(int n, int n2, WCMFilter wCMFilter, String string) throws WCMException {
        int n3;
        DBManager dBManager = DBManager.getDBManager();
        String string2 = "select count(" + wCMFilter.getSelect() + ") from " + wCMFilter.getFrom();
        if (!CMyString.isEmpty(wCMFilter.getWhere())) {
            string2 = string2 + " where " + wCMFilter.getWhere();
        }
        if ((n3 = dBManager.sqlExecuteIntQuery(string2, wCMFilter.getSearchValues())) <= 0) {
            return;
        }
        CPager cPager = new CPager(n2);
        cPager.setItemCount(n3);
        cPager.setCurrentPageIndex(n);
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl = this.isCached();
        String string3 = this.getIdFieldName();
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement(wCMFilter.toSQL());
            preparedStatement.setFetchSize(n2);
            DBManager.setParameters(preparedStatement, wCMFilter);
            resultSet = preparedStatement.executeQuery();
            this.setRecCount(n3);
            int n4 = 0;
            int n5 = 0;
            while (resultSet.next()) {
                if (++n4 < cPager.getFirstItemIndex()) {
                    this.vIdList.add(ID_NOT_LOAD);
                    continue;
                }
                int n6 = resultSet.getInt(string3);
                if (bl) {
                    this.addElement(n6);
                } else {
                    BaseObj baseObj = (BaseObj)this.getElementClass().newInstance();
                    baseObj.loadById(n6, string);
                    if (baseObj == null) continue;
                    this.addElement(baseObj);
                }
                if (++n5 <= n2) continue;
                break;
            }
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to Desc!", exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close result", (Throwable)exception);
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)exception);
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
        }
    }

    public void setRecCount(int n) {
        if (n < 0) {
            return;
        }
        this.m_nRecCount = n;
    }

    public int getRecCount() {
        if (this.m_nRecCount < 0) {
            return this.size();
        }
        return this.m_nRecCount;
    }
}

