/*
 * Decompiled with CFR 0.152.
 */
package com.trs.database.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;

public class AllDDLMaker {
    private String conf = null;
    private String dbtype = null;
    private BufferedWriter writer = null;
    private Connection conn = null;
    private String tableNamePattern = null;
    private boolean doublelen = false;
    private boolean useNull = true;
    private Properties props = new Properties();

    public AllDDLMaker(String[] stringArray) {
        this.conf = stringArray[0];
        if (stringArray.length > 1) {
            this.dbtype = stringArray[1];
        }
        if (stringArray.length > 2) {
            File file = new File(stringArray[2]);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try {
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "GBK"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void make() throws Exception {
        Exception exception3;
        block16: {
            try {
                this.loadAndInit();
                if ("mysql.".equals(this.dbtype)) {
                    this.makeTableDDL4MySql();
                } else {
                    this.makeTableDDL();
                }
                this.makeIndexDDL();
                Object var2_1 = null;
                if (this.conn == null) break block16;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var2_2 = null;
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (this.writer != null) {
                    try {
                        this.writer.flush();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                    try {
                        this.writer.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                this.conn.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            try {
                this.writer.close();
            }
            catch (Exception exception3) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadAndInit() throws Exception {
        Object object2;
        String string;
        block7: {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.conf);
                this.props.load(fileInputStream);
                string = null;
                if (fileInputStream == null) break block7;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (fileInputStream == null) throw throwable;
                try {
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception object2) {}
            ((InputStream)fileInputStream).close();
        }
        if (this.dbtype == null || this.dbtype.trim().length() == 0) {
            this.dbtype = this.props.getProperty("media.sql.dbtarget");
        }
        this.doublelen = "true".equals(this.props.getProperty("media.sql.doublelen"));
        this.doublelen = this.doublelen && !this.dbtype.equals("mssql");
        this.dbtype = this.dbtype.toLowerCase() + ".";
        this.useNull = "true".equals(this.props.getProperty(this.dbtype + "useNull"));
        this.tableNamePattern = this.props.getProperty("media.sql.tableNamePattern");
        if (this.tableNamePattern == null) {
            this.tableNamePattern = "%";
        }
        String string2 = this.props.getProperty("media.sql.dbuser");
        string = this.props.getProperty("media.sql.dbpwd");
        object2 = this.props.getProperty("media.sql.dburl");
        String string3 = this.props.getProperty("media.sql.dbdriver");
        Class.forName(string3);
        this.conn = DriverManager.getConnection((String)object2, string2, string);
    }

    private void makeTableDDL() throws Exception {
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(null, null, this.tableNamePattern, new String[]{"TABLE"});
        ResultSet resultSet2 = null;
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        String string3 = null;
        ResultSet resultSet3 = null;
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer(128);
        boolean bl = false;
        boolean bl2 = false;
        String string5 = null;
        while (resultSet.next()) {
            string = resultSet.getString(3).toUpperCase();
            stringBuffer.setLength(0);
            stringBuffer.append("CREATE TABLE ");
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
            stringBuffer.append("(\n");
            string4 = "";
            resultSet3 = databaseMetaData.getPrimaryKeys(null, null, string);
            while (resultSet3.next()) {
                string4 = string4 + ",\"" + resultSet3.getString("COLUMN_NAME") + "\"";
            }
            resultSet3.close();
            resultSet2 = databaseMetaData.getColumns(null, null, string, null);
            bl = false;
            while (resultSet2.next()) {
                if (bl) {
                    stringBuffer.append(",\n");
                }
                string2 = resultSet2.getString("COLUMN_NAME").toUpperCase();
                stringBuffer.append("\t");
                stringBuffer.append('\"');
                stringBuffer.append(string2);
                stringBuffer.append('\"');
                stringBuffer.append(" ");
                string5 = resultSet2.getString("TYPE_NAME").toUpperCase();
                string5 = (String)this.props.get(this.dbtype + string5);
                if (string5 == null) {
                    string5 = resultSet2.getString("TYPE_NAME").toUpperCase();
                }
                stringBuffer.append(string5.toUpperCase());
                n = resultSet2.getInt("DATA_TYPE");
                boolean bl3 = bl2 = 1 == n || 12 == n;
                if (bl2) {
                    stringBuffer.append("(");
                    n2 = resultSet2.getInt("COLUMN_SIZE");
                    if (this.doublelen) {
                        n2 = Math.min(n2 * 2, 4000);
                    }
                    stringBuffer.append(n2);
                    stringBuffer.append(")");
                } else if (n == 2) {
                    stringBuffer.append("(");
                    stringBuffer.append(resultSet2.getInt("COLUMN_SIZE"));
                    stringBuffer.append(',');
                    stringBuffer.append(resultSet2.getInt("DECIMAL_DIGITS"));
                    stringBuffer.append(")");
                }
                string3 = resultSet2.getString("COLUMN_DEF");
                if (string3 != null) {
                    string3 = string3.substring(1, string3.length() - 1);
                    if (!bl2) {
                        if (string3.charAt(0) == 'g') {
                            string3 = this.props.getProperty(this.dbtype + "getdate");
                        } else {
                            while (string3.indexOf(40) != -1) {
                                string3 = string3.substring(1, string3.length() - 1);
                            }
                        }
                    } else if (string3.indexOf(39) == -1) {
                        string3 = '\'' + string3 + '\'';
                    }
                    stringBuffer.append(" DEFAULT ").append(string3);
                }
                if (!"YES".equals(resultSet2.getString("IS_NULLABLE"))) {
                    stringBuffer.append(" NOT NULL");
                } else if (this.useNull && string4.indexOf(string2) == -1) {
                    stringBuffer.append(" NULL");
                }
                bl = true;
            }
            resultSet2.close();
            if (string4.length() > 1) {
                stringBuffer.append(",\n\tPRIMARY KEY (");
                stringBuffer.append(string4.substring(1));
                stringBuffer.append(")");
            }
            stringBuffer.append("\n);\n");
            if (this.writer != null) {
                this.writer.write(stringBuffer.toString());
                this.writer.flush();
                continue;
            }
            System.out.println(stringBuffer);
        }
        resultSet.close();
        this.props.clear();
    }

    private void makeTableDDL4MySql() throws Exception {
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(null, null, this.tableNamePattern, new String[]{"TABLE"});
        ResultSet resultSet2 = null;
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        String string3 = null;
        ResultSet resultSet3 = null;
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer(128);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        String string5 = null;
        while (resultSet.next()) {
            string = resultSet.getString(3).toUpperCase();
            stringBuffer.setLength(0);
            stringBuffer.append("CREATE TABLE ");
            stringBuffer.append('`');
            stringBuffer.append(string);
            stringBuffer.append('`');
            stringBuffer.append("(\n");
            string4 = "";
            resultSet3 = databaseMetaData.getPrimaryKeys(null, null, string);
            while (resultSet3.next()) {
                string4 = string4 + ",`" + resultSet3.getString("COLUMN_NAME") + "`";
            }
            resultSet3.close();
            resultSet2 = databaseMetaData.getColumns(null, null, string, null);
            bl = false;
            bl3 = true;
            while (resultSet2.next()) {
                if (bl) {
                    stringBuffer.append(",\n");
                }
                string2 = resultSet2.getString("COLUMN_NAME").toUpperCase();
                stringBuffer.append("\t");
                stringBuffer.append('`');
                stringBuffer.append(string2);
                stringBuffer.append('`');
                stringBuffer.append(" ");
                string5 = resultSet2.getString("TYPE_NAME").toUpperCase();
                string5 = (String)this.props.get(this.dbtype + string5);
                if (string5 == null) {
                    string5 = resultSet2.getString("TYPE_NAME").toUpperCase();
                }
                stringBuffer.append(string5.toUpperCase());
                n = resultSet2.getInt("DATA_TYPE");
                boolean bl4 = bl2 = 1 == n || 12 == n;
                if (bl2) {
                    stringBuffer.append("(");
                    n2 = resultSet2.getInt("COLUMN_SIZE");
                    if (this.doublelen) {
                        n2 = Math.min(n2 * 2, 4000);
                    }
                    stringBuffer.append(n2);
                    stringBuffer.append(")");
                } else if (n == 2) {
                    stringBuffer.append("(");
                    stringBuffer.append(resultSet2.getInt("COLUMN_SIZE"));
                    stringBuffer.append(',');
                    stringBuffer.append(resultSet2.getInt("DECIMAL_DIGITS"));
                    stringBuffer.append(")");
                }
                string3 = resultSet2.getString("COLUMN_DEF");
                if (string3 != null) {
                    string3 = string3.substring(1, string3.length() - 1);
                    if (!bl2) {
                        if (string3.charAt(0) == 'g') {
                            if (bl3) {
                                string3 = this.props.getProperty(this.dbtype + "getdate");
                                bl3 = false;
                            } else {
                                string3 = null;
                            }
                        } else {
                            while (string3.indexOf(40) != -1) {
                                string3 = string3.substring(1, string3.length() - 1);
                            }
                        }
                    } else if (string3.indexOf(39) == -1) {
                        string3 = '\'' + string3 + '\'';
                    }
                    if (string3 != null) {
                        stringBuffer.append(" DEFAULT ").append(string3);
                    }
                }
                if (!"YES".equals(resultSet2.getString("IS_NULLABLE"))) {
                    stringBuffer.append(" NOT NULL");
                } else if (this.useNull && string4.indexOf(string2) == -1) {
                    stringBuffer.append(" NULL");
                }
                bl = true;
            }
            resultSet2.close();
            if (string4.length() > 1) {
                stringBuffer.append(",\n\tPRIMARY KEY (");
                stringBuffer.append(string4.substring(1));
                stringBuffer.append(")");
            }
            stringBuffer.append("\n);\n");
            if (this.writer != null) {
                this.writer.write(stringBuffer.toString());
                this.writer.flush();
                continue;
            }
            System.out.println(stringBuffer);
        }
        resultSet.close();
        this.props.clear();
    }

    private void makeIndexDDL() throws Exception {
        String string = "select name from sysobjects where upper(name) like '%WCM%' and xtype='U' order by name asc";
        string = string.replaceAll("WCM", this.tableNamePattern.toUpperCase());
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        CallableStatement callableStatement = this.conn.prepareCall("sp_helpindex ?");
        ResultSet resultSet2 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        HashSet<String> hashSet = new HashSet<String>(100, 0.2f);
        String string6 = null;
        StringBuffer stringBuffer = new StringBuffer(128);
        while (resultSet.next()) {
            string6 = resultSet.getString(1).toUpperCase();
            callableStatement.setString(1, string6);
            try {
                resultSet2 = callableStatement.executeQuery();
            }
            catch (Exception exception) {
                System.err.println("-- table has no index:" + string6 + ";");
                continue;
            }
            while (resultSet2.next()) {
                int n;
                string2 = resultSet2.getString(1).toUpperCase();
                string3 = resultSet2.getString(2).toUpperCase();
                string4 = resultSet2.getString(3).toUpperCase();
                string5 = string6 + "(" + string4 + ")";
                if (hashSet.contains(string5)) {
                    System.err.println("-- duplicate index on " + string5);
                    continue;
                }
                hashSet.add(string5);
                if (string3.indexOf("PRIMARY KEY") != -1) continue;
                stringBuffer.setLength(0);
                stringBuffer.append("create ");
                if (string3.indexOf("UNIQUE") != -1) {
                    stringBuffer.append("UNIQUE ");
                }
                if (string3.indexOf("NONCLUSTERED") == -1 && string3.indexOf("CLUSTERED") != -1) {
                    stringBuffer.append("CLUSTERED ");
                }
                stringBuffer.append("index ");
                if (!string2.startsWith("IX_")) {
                    string2 = "IX_" + string2;
                }
                if ((n = string2.length() - 30) >= 10) {
                    string2 = string2.substring(0, 28) + n;
                } else if (n > 0) {
                    string2 = string2.substring(0, 29) + n;
                }
                stringBuffer.append(string2);
                stringBuffer.append(" on ").append(string6);
                stringBuffer.append('(');
                string4 = string4.replaceAll("\\(-\\)", " desc");
                stringBuffer.append(string4);
                stringBuffer.append(')');
                stringBuffer.append(';');
                stringBuffer.append('\n');
                if (this.writer != null) {
                    this.writer.write(stringBuffer.toString().toUpperCase());
                    this.writer.flush();
                    continue;
                }
                System.out.println(stringBuffer.toString().toUpperCase());
            }
            resultSet2.close();
        }
        resultSet.close();
        statement.close();
        callableStatement.close();
    }

    public static void main(String[] stringArray) {
        AllDDLMaker allDDLMaker = new AllDDLMaker(stringArray);
        try {
            allDDLMaker.make();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

