/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.resource;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class Status
extends CMSObj {
    private static Logger logger = Logger.getLogger(Status.class);
    public static final int OBJ_TYPE = 610;
    public static final String DB_TABLE_NAME = "WCMSTATUS";
    public static final String DB_ID_NAME = "STATUSID";
    public static final int STATUS_ID_UNKNOWN = 0;
    public static final int STATUS_ID_NEW = 1;
    public static final int STATUS_ID_EDITED = 2;
    public static final int STATUS_ID_AGAIN = 3;
    public static final int STATUS_ID_PUBLISHED = 10;
    public static final int STATUS_ID_NO = 15;
    public static final int STATUS_ID_SIGN = 16;
    public static final int STATUS_ID_VERIFY = 18;
    public static final int STATUS_NOT_ACCEPTED = 21;
    public static final int STATUS_ACCEPTED = 22;
    public static final int STATUS_ID_IN_DESTROY = 1026;
    public static final int STATUS_ID_PUBLISHED_AFTER_EDIT = 1027;
    public static final int STATUS_ID_DRAFT = 1028;
    public static final int[] STATUS_CAN_DO_PUB = new int[]{10, 1027};
    public static final int STATUS_ID_USERDEF = 30;
    public static final int TYPE_FOR_SET_DOC = 1;
    public static final int TYPE_FOR_WORKFLOW = 2;
    public static final int TYPE_FOR_ALL = 3;
    public static final int TYPE_DO_NOT_SHOW = 0;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 610;
    }

    public String getName() {
        return (String)this.getProperty("SNAME");
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty("SNAME", string);
    }

    public String getDesc() {
        return (String)this.getProperty("SDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("SDESC", string);
    }

    public String getDisp() {
        return (String)this.getProperty("SDISP");
    }

    public boolean setDisp(String string) throws WCMException {
        return this.setProperty("SDISP", string);
    }

    public boolean isUsed() {
        return this.getPropertyAsBoolean("SUSED", true);
    }

    public boolean setUsed(boolean bl) throws WCMException {
        return this.setProperty("SUSED", bl);
    }

    public int getType() {
        return this.getPropertyAsInt("STYPE", 3);
    }

    public boolean setType(int n) throws WCMException {
        return this.setProperty("STYPE", n);
    }

    public boolean isValid() throws WCMException {
        String string = null;
        if (this.isAddMode()) {
            string = (String)this.getAllProperty().get("SNAME");
            if (string == null) {
                throw new WCMException(1106, I18NMessage.get(Status.class, "Status.label1", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(Status.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Status.class, "Status.label2", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Status.isValid)"));
            }
            string = (String)this.getNewProperty("SNAME");
        }
        if (string != null) {
            String string2 = " SName='" + CMyString.filterForSQL(string) + "'";
            if (!this.isAddMode()) {
                string2 = string2 + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists(string2)) {
                throw new WCMException(1108, I18NMessage.get(Status.class, "Status.label3", "\u72b6\u6001\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff08Status.isValid\uff09"));
            }
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(user);
        }
    }

    public int getRightIndex() {
        return this.getPropertyAsInt("RIGHTINDEX", 35);
    }

    public boolean setRightIndex(int n) throws WCMException {
        return this.setProperty("RIGHTINDEX", n);
    }

    public static final Status findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Status)BaseObj.findById(Status.class, n);
    }

    public static final Status createNewInstance() throws WCMException {
        return (Status)BaseObj.createNewInstance(Status.class);
    }

    public static final Status findByKey(Object object) throws WCMException {
        return (Status)BaseObj.findByKey(Status.class, object);
    }

    public static int[] getStatusCanDoPubInOutline() {
        try {
            String string = ConfigServer.getServer().getSysConfigValue("PageDestroyWhenModifyPublishStatusDoc", "false");
            if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("1")) {
                return new int[]{10};
            }
            String string2 = ConfigServer.getServer().getSysConfigValue("PublishedDocumentContainsEdit", "false").trim();
            if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("1")) {
                return new int[]{10, 1027};
            }
        }
        catch (WCMException wCMException) {
            logger.error((Object)"Fail to get published status!", (Throwable)wCMException);
        }
        return new int[]{10};
    }
}

