/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.resource;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.job.Schedules;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class ResourceMgr {
    private static final int[] RESOURCE_OBJ_TYPE = new int[]{608, 607, 610, 205, 313, 704, 951};

    public CMSObj save(User user, CMSObj cMSObj) throws WCMException {
        if (!this.isValidResourceType(cMSObj)) {
            throw new WCMException(10, I18NMessage.get(ResourceMgr.class, "ResourceMgr.label1", "\u975e\u914d\u7f6e\u8d44\u6e90\u5bf9\u8c61\uff01"));
        }
        cMSObj.save(user);
        return cMSObj;
    }

    public boolean delete(User user, CMSObj cMSObj) throws WCMException {
        if (!this.isValidResourceType(cMSObj)) {
            throw new WCMException(10, I18NMessage.get(ResourceMgr.class, "ResourceMgr.label2", "\u975e\u914d\u7f6e\u8d44\u6e90\u5bf9\u8c61!"));
        }
        return cMSObj.delete(user) == 1;
    }

    private boolean isValidResourceType(CMSObj cMSObj) throws WCMException {
        if (cMSObj == null) {
            throw new WCMException(10, I18NMessage.get(ResourceMgr.class, "ResourceMgr.label3", "\u65e0\u6548\u7684\u5bf9\u8c61\u53c2\u6570!"));
        }
        int n = cMSObj.getWCMType();
        int[] nArray = RESOURCE_OBJ_TYPE;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public Schedules getTempPathDeleteSchedules(WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "SenderType=0", "");
        wCMFilter2.mergeWith(wCMFilter);
        return Schedules.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }
}

