/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TemplateParameter;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateNestMgr;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateArgument;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.tagparser.RollDocumentsChannelsFinder;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class WCMTemplateChildIndexAnalyer {
    private static Logger logger = Logger.getLogger(WCMTemplateChildIndexAnalyer.class);
    public static final String INSERT_CHANNEL_CHILDINDEX_QUOTE = "insert into WCMChannelChildIndexQuote (TemplateId, FolderType, FolderId, QuoteChannelId) values(?, ?, ?, ?)";
    public static final String QUERY_CHANNEL_CHILDINDEX_QUOTE = "select 1 from WCMChannelChildIndexQuote where TemplateId=? and FolderType = ? and FolderId=? and QuoteChannelId=?";
    private Template m_oTemplate = null;
    private final int m_nTopTemplateId;
    private TagDocument m_oTagDoc = null;
    private DBManager dbMgr = null;
    private List lEmployers = null;

    public WCMTemplateChildIndexAnalyer(Template template) {
        this.m_oTemplate = template;
        this.m_nTopTemplateId = this.m_oTemplate.getId();
        this.dbMgr = DBManager.getDBManager();
    }

    public WCMTemplateChildIndexAnalyer(IPublishFolder iPublishFolder) {
        this.m_nTopTemplateId = 0;
        this.dbMgr = DBManager.getDBManager();
    }

    public void analyer() throws WCMException {
        this.removeOldAnalyeInfo();
        this.analyer(false);
    }

    private void analyer(boolean bl) throws WCMException {
        Object object;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Analyzing template quote: " + this.m_oTemplate));
        }
        try {
            object = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            this.m_oTagDoc = ((TemplateParseMgr)object).parse(this.m_oTemplate);
        }
        catch (Throwable throwable) {
            throw new WCMException("analyer " + this.m_oTemplate + "\u5931\u8d25\uff01", throwable);
        }
        if (this.m_oTagDoc == null) {
            return;
        }
        if (!bl) {
            this.lEmployers = this.makeEmployers();
            object = new HashSet();
            for (int i = this.lEmployers.size() - 1; i >= 0; --i) {
                IPublishElement iPublishElement = (IPublishElement)this.lEmployers.get(i);
                if (iPublishElement == null || iPublishElement instanceof IPublishContent) {
                    this.lEmployers.remove(i);
                    continue;
                }
                String string = iPublishElement.getType() + "." + iPublishElement.getId();
                if (((HashSet)object).contains(string)) {
                    this.lEmployers.remove(i);
                    continue;
                }
                ((HashSet)object).add(string);
            }
            ((HashSet)object).clear();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Employers of this template: " + this.lEmployers));
            }
        }
        if (this.lEmployers.isEmpty()) {
            return;
        }
        this.analyseTagsContainsChildIndex();
        this.analyseChannelsTags();
        this.anzlyzePageGenTags();
    }

    private void anzlyzePageGenTags() throws WCMException {
        String string = "TRS_PAGEGENERATE";
        Iterator iterator = this.m_oTagDoc.findItems(string);
        HashMap<String, Template> hashMap = new HashMap<String, Template>();
        while (iterator.hasNext()) {
            TagItem tagItem = (TagItem)iterator.next();
            if (tagItem == null) continue;
            String string2 = tagItem.getAttribute("TEMPNAME");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("tempname: " + string2));
            }
            if (hashMap.containsKey(string2)) continue;
            TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
            int n = this.lEmployers.size();
            for (int i = 0; i < n; ++i) {
                IPublishElement iPublishElement = (IPublishElement)this.lEmployers.get(i);
                if (iPublishElement == null || !iPublishElement.isFolder()) continue;
                IPublishFolder iPublishFolder = (IPublishFolder)iPublishElement;
                Template template = templateCacheMgr.lookupByName(iPublishFolder.getRoot(), string2);
                if (template != null) {
                    hashMap.put(string2, template);
                    continue;
                }
                logger.warn((Object)("Template not found: " + string2 + "@" + iPublishFolder.getRoot().getInfo()));
            }
        }
        for (Template this.m_oTemplate : hashMap.values()) {
            this.analyer(true);
        }
        hashMap.clear();
    }

    private void analyseTagsContainsChildIndex() throws WCMException {
        List list = this.findTagItemsContainsChildIndex();
        if (list == null || list.isEmpty()) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = this.m_nTopTemplateId;
        int n = this.lEmployers.size();
        for (int i = 0; i < n; ++i) {
            IPublishElement iPublishElement = (IPublishElement)this.lEmployers.get(i);
            if (iPublishElement == null || !(iPublishElement instanceof IPublishFolder)) continue;
            IPublishFolder iPublishFolder = (IPublishFolder)iPublishElement;
            nArray[1] = iPublishElement.getType();
            nArray[2] = iPublishElement.getId();
            int n2 = list.size();
            for (int j = 0; j < n2; ++j) {
                TagItem tagItem = (TagItem)list.get(j);
                if (tagItem == null) continue;
                this.saveQuoteInfo(nArray, iPublishFolder, tagItem);
            }
        }
    }

    private List makeEmployers() throws WCMException {
        ArrayList arrayList = new ArrayList();
        TemplateEmployMgr templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
        List list = templateEmployMgr.getEmployers(this.m_oTemplate, null);
        if (list != null && !list.isEmpty()) {
            arrayList.addAll(list);
        }
        TemplateNestMgr templateNestMgr = (TemplateNestMgr)DreamFactory.createObjectById("TemplateNestMgr");
        Templates templates = templateNestMgr.getTemplatesNested(this.m_oTemplate);
        int n = templates.size();
        for (int i = 0; i < n; ++i) {
            List list2;
            Template template = (Template)templates.getAt(i);
            if (template == null || (list2 = templateEmployMgr.getEmployers(template, null)) == null || list2.isEmpty()) continue;
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private void analyseChannelsTags() throws WCMException {
        List list = this.findChannelsTagItems();
        if (list == null || list.isEmpty()) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = this.m_nTopTemplateId;
        int n = this.lEmployers.size();
        for (int i = 0; i < n; ++i) {
            IPublishElement iPublishElement = (IPublishElement)this.lEmployers.get(i);
            if (iPublishElement == null || !(iPublishElement instanceof IPublishFolder)) continue;
            nArray[1] = iPublishElement.getType();
            nArray[2] = iPublishElement.getId();
            IPublishFolder iPublishFolder = (IPublishFolder)iPublishElement;
            int n2 = list.size();
            for (int j = 0; j < n2; ++j) {
                TagItem tagItem = (TagItem)list.get(j);
                if (tagItem == null) continue;
                this.analyseChannelsTag(tagItem, iPublishFolder, nArray);
            }
        }
    }

    private void analyseChannelsTag(TagItem tagItem, IPublishFolder iPublishFolder, int[] nArray) throws WCMException {
        List list;
        BaseChannel baseChannel;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Analyzing TRS_CHANNELS quote, params: ");
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                logger.debug((Object)(i + ":" + nArray[i]));
            }
        }
        if ((baseChannel = WCMTemplateChildIndexAnalyer.findFolderHost(tagItem, iPublishFolder)) == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Analyzing TRS_CHANNELS quote, parent: " + baseChannel));
        }
        if ((list = baseChannel.getChildren(null)) == null || list.isEmpty()) {
            return;
        }
        int n = list.size();
        int n2 = WCMTemplateChildIndexAnalyer.getValueOfTag(iPublishFolder, tagItem, "StartPos", 0);
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = WCMTemplateChildIndexAnalyer.getValueOfTag(iPublishFolder, tagItem, "NUM", n);
        int n4 = 0;
        for (int i = n2; i < n && n4 < n3; ++i) {
            Channel channel = (Channel)list.get(i);
            if (channel == null) continue;
            IPublishFolder iPublishFolder2 = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
            List list2 = tagItem.getChildren();
            int n5 = list2.size();
            for (int j = 0; j < n5; ++j) {
                Object e = list2.get(j);
                if (!(e instanceof TagItem)) continue;
                TagItem tagItem2 = (TagItem)e;
                if (tagItem2.getName().equalsIgnoreCase("TRS_CHANNELS")) {
                    this.analyseChannelsTag(tagItem2, iPublishFolder2, nArray);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("TRS_CHANNELS: " + iPublishFolder2.getInfo()));
                }
                this.saveQuoteInfo(nArray, iPublishFolder2, (TagItem)e);
            }
            ++n4;
        }
    }

    private void saveQuoteInfo(int[] nArray, IPublishFolder iPublishFolder, TagItem tagItem) throws WCMException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("saveQuoteInfo: " + tagItem.getName()));
            logger.debug((Object)("currFolder: " + iPublishFolder.getInfo()));
        }
        BaseChannel baseChannel = null;
        if (tagItem.getName().equalsIgnoreCase("TRS_DOCUMENTS") || tagItem.getName().equalsIgnoreCase("TRS_VIEWDATAS") || tagItem.getName().equalsIgnoreCase("TRS_OUTLINE")) {
            baseChannel = WCMTemplateChildIndexAnalyer.findFolderHost(tagItem, iPublishFolder);
        } else if (tagItem.getName().equalsIgnoreCase("TRS_ROLLDOCUMENTS")) {
            RollDocumentsChannelsFinder rollDocumentsChannelsFinder = new RollDocumentsChannelsFinder(iPublishFolder);
            String string = rollDocumentsChannelsFinder.find(tagItem);
            if (CMyString.isEmpty(string)) {
                return;
            }
            Channels channels = Channels.findByIds(null, string);
            int n = channels.size();
            for (int i = 0; i < n; ++i) {
                this.saveQuoteInDB(nArray, (Channel)channels.getAt(i));
            }
        } else if ("TRS_CHANNEL".equalsIgnoreCase(tagItem.getName())) {
            baseChannel = (BaseChannel)iPublishFolder.getSubstance();
        }
        this.saveQuoteInDB(nArray, baseChannel);
    }

    private void saveQuoteInDB(int[] nArray, BaseChannel baseChannel) throws WCMException {
        if (baseChannel == null || baseChannel.isSite()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("quote channel: " + baseChannel));
        }
        nArray[3] = baseChannel.getId();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("quote channel: " + baseChannel + ", sql:" + QUERY_CHANNEL_CHILDINDEX_QUOTE));
            for (int n : nArray) {
                logger.debug((Object)("param: " + n));
            }
        }
        if (this.dbMgr.sqlExecuteIntQuery(QUERY_CHANNEL_CHILDINDEX_QUOTE, nArray) > 0) {
            return;
        }
        nArray[3] = baseChannel.getId();
        this.dbMgr.sqlExecuteUpdate(new String[]{INSERT_CHANNEL_CHILDINDEX_QUOTE}, nArray);
    }

    private void removeOldAnalyeInfo() throws WCMException {
        this.dbMgr.sqlExecuteUpdate(new String[]{"delete from WCMChannelChildIndexQuote where TemplateId=?"}, new int[]{this.m_nTopTemplateId});
    }

    private List findTagItemsContainsChildIndex() {
        TagItem tagItem;
        Object object;
        Object object2;
        Iterator iterator = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String[] stringArray = new String[]{"TRS_OUTLINE", "TRS_DOCUMENTS", "TRS_VIEWDATAS"};
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = stringArray[i];
            iterator = this.m_oTagDoc.findItems((String)object2);
            while (iterator.hasNext() && (object = (TagItem)iterator.next()) != null) {
                HashMap hashMap;
                TagItem tagItem2 = ((TagItem)object).getParent();
                if (tagItem2 != null && tagItem2.getName().equals("TRS_CHANNELS") || (hashMap = ((TagItem)object).getAttributes()) == null || !hashMap.containsKey("CHILDINDEX")) continue;
                arrayList.add(object);
            }
        }
        iterator = this.m_oTagDoc.findItems("TRS_ROLLDOCUMENTS");
        while (iterator.hasNext() && (tagItem = (TagItem)iterator.next()) != null) {
            object2 = tagItem.getParent();
            if (object2 != null && ((TagItem)object2).getName().equals("TRS_CHANNELS") || (object = tagItem.getAttributes()) == null || !((HashMap)object).containsKey("PARENTCHANNELID")) continue;
            arrayList.add(tagItem);
        }
        return arrayList;
    }

    private List findChannelsTagItems() {
        ArrayList<TagItem> arrayList = new ArrayList<TagItem>();
        int n = this.m_oTagDoc.getItemCount();
        for (int i = 0; i < n; ++i) {
            Iterator iterator;
            TagItem tagItem;
            Object object = this.m_oTagDoc.getItemAt(i);
            if (object == null || !(object instanceof TagItem) || !(tagItem = (TagItem)object).getName().equalsIgnoreCase("TRS_CHANNELS") || !(iterator = tagItem.findItems(new String[]{"TRS_ROLLDOCUMENTS", "TRS_OUTLINE", "TRS_DOCUMENTS", "TRS_VIEWDATAS", "TRS_CHANNEL"})).hasNext()) continue;
            arrayList.add(tagItem);
        }
        return arrayList;
    }

    private static BaseChannel findFolderHost(TagItem tagItem, IPublishFolder iPublishFolder) throws WCMException {
        BaseChannel baseChannel;
        String string;
        BaseChannel baseChannel2;
        int n = -1;
        String string2 = WCMTemplateChildIndexAnalyer.getAttribute((IPublishElement)iPublishFolder, null, "CHILDINDEX", tagItem);
        if (!CMyString.isEmpty(string2)) {
            n = Integer.parseInt(string2);
        }
        if ((baseChannel2 = WCMTemplateChildIndexAnalyer.findIdAppointedFolder(string = WCMTemplateChildIndexAnalyer.getAttribute((IPublishElement)iPublishFolder, null, "ID", tagItem), iPublishFolder)) == null) {
            return null;
        }
        int n2 = WCMTemplateChildIndexAnalyer.getAttribute((IPublishElement)iPublishFolder, tagItem, "CHANNELTYPE", 0);
        if (n2 == 1 || n2 == 2) {
            return WCMTemplateChildIndexAnalyer.findTopNewsOrPicChannel(baseChannel2, n2);
        }
        switch (n) {
            case -2: {
                if (baseChannel2.isSite()) {
                    throw new WCMException(235, "Site has no parent!");
                }
                baseChannel = ((Channel)baseChannel2).getParent();
                if (baseChannel != null) break;
                if (((Channel)baseChannel2).getParentId() != 0) {
                    throw new WCMException(235, baseChannel2.getInfo() + "\u7684\u7236\u9891\u9053\u6ca1\u6709\u627e\u5230!");
                }
                baseChannel = baseChannel2.getSite();
                break;
            }
            case -1: {
                baseChannel = baseChannel2;
                break;
            }
            default: {
                baseChannel = baseChannel2.getChildAt(n);
                if (baseChannel != null) break;
                logger.error((Object)("Child " + n + " of " + baseChannel2.getInfo() + " is not found!"));
            }
        }
        return baseChannel;
    }

    private static BaseChannel findIdAppointedFolder(String string, IPublishFolder iPublishFolder) throws WCMException {
        BaseChannel baseChannel;
        String string2;
        int n;
        IPublishFolder iPublishFolder2 = iPublishFolder;
        IPublishFolder iPublishFolder3 = iPublishFolder.getRoot();
        String string3 = string;
        if (string3 == null || (string3 = string3.trim()).length() == 0) {
            n = 75627155;
        } else {
            int n2;
            string2 = "SITEID:";
            if (string3.toUpperCase().startsWith(string2)) {
                int n3 = Integer.parseInt(string3.substring(string2.length()));
                if (n3 > 0) {
                    return WebSite.findById(n3);
                }
            } else if (string3.toUpperCase().startsWith("CHANNELID:") && (n2 = Integer.parseInt(string3.substring("CHANNELID:".length()))) > 0) {
                return Channel.findById(n2);
            }
            n = string3.toUpperCase().hashCode();
        }
        switch (n) {
            case 2545479: {
                if (iPublishFolder2 == null) {
                    throw new WCMException("Upper Host is Null!");
                }
                try {
                    baseChannel = iPublishFolder2 instanceof IPublishFolder ? (BaseChannel)iPublishFolder2.getSubstance() : (BaseChannel)iPublishFolder2.getFolder().getSubstance();
                    if (baseChannel.isSite()) break;
                    baseChannel = baseChannel.getSite();
                    break;
                }
                catch (ClassCastException classCastException) {
                    throw new WCMException(10, "Upper host must be a channel or a site!");
                }
            }
            case 75627155: {
                if (iPublishFolder2 == null) {
                    throw new WCMException("Upper Host is Null!");
                }
                try {
                    if (iPublishFolder2 instanceof IPublishFolder) {
                        baseChannel = (BaseChannel)iPublishFolder2.getSubstance();
                        break;
                    }
                    baseChannel = (BaseChannel)iPublishFolder2.getFolder().getSubstance();
                    break;
                }
                catch (ClassCastException classCastException) {
                    throw new WCMException(10, "Upper host must be a channel or a site!");
                }
            }
            case -1942094678: {
                if (iPublishFolder2 == null) {
                    throw new WCMException("Upper Host is Null!");
                }
                try {
                    baseChannel = iPublishFolder2 instanceof IPublishFolder ? (BaseChannel)iPublishFolder2.getSubstance() : (BaseChannel)iPublishFolder2.getFolder().getSubstance();
                    if (baseChannel.isSite()) break;
                    baseChannel = baseChannel.getHost();
                    break;
                }
                catch (ClassCastException classCastException) {
                    throw new WCMException(10, "Upper host must be a channel or a site!");
                }
            }
            default: {
                baseChannel = Channel.findByName(iPublishFolder3.getId(), string3);
                if (baseChannel != null) break;
                string2 = "\u6307\u5b9a\u7684\u9891\u9053 [" + string3 + "]\u5728" + iPublishFolder3.getInfo() + "\u6ca1\u6709\u627e\u5230!";
                logger.error((Object)string2);
                throw new WCMException(233, string2);
            }
        }
        return baseChannel;
    }

    private static BaseChannel findTopNewsOrPicChannel(BaseChannel baseChannel, int n) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u7236\u9891\u9053\uff01");
        }
        BaseChannel baseChannel2 = baseChannel;
        User user = User.getSystem();
        int n2 = baseChannel2.getChildrenSize(user);
        for (int i = 0; i < n2 && i < 2; ++i) {
            Channel channel = baseChannel2.getChildAt(i);
            if (channel == null || channel.getType() != n) continue;
            return channel;
        }
        if (baseChannel2.isSite()) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7c7b\u578b[" + n + "]\u7684\u9891\u9053\uff01");
        }
        return WCMTemplateChildIndexAnalyer.findTopNewsOrPicChannel(baseChannel2.getHost(), n);
    }

    public static int getAttribute(IPublishElement iPublishElement, TagItem tagItem, String string, int n) throws WCMException {
        String string2 = WCMTemplateChildIndexAnalyer.getAttribute(iPublishElement, null, string, tagItem);
        if (string2 == null || string2.length() == 0) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new WCMException(2, "Value [" + string2 + "] of attribute [" + string + "] is not integer!", exception);
        }
    }

    private static int getValueOfTag(IPublishElement iPublishElement, TagItem tagItem, String string, int n) {
        int n2 = n;
        String string2 = WCMTemplateChildIndexAnalyer.getAttribute(iPublishElement, null, string, tagItem);
        if (!CMyString.isEmpty(string2)) {
            n2 = Integer.parseInt(string2);
        }
        return n2;
    }

    private static String getAttribute(IPublishElement iPublishElement, String string, String string2, TagItem tagItem) {
        String string3 = tagItem.getAttributeTrim(string2);
        if (string3 == null) {
            return null;
        }
        if (!TagItem.isVariableParameter(string3)) {
            return string3;
        }
        TemplateParameter templateParameter = tagItem.getVariableParameter(string2);
        if (templateParameter == null) {
            return string3;
        }
        String string4 = templateParameter.getParameterName();
        if (string4.charAt(0) == '@') {
            return string3;
        }
        HashMap hashMap = null;
        try {
            hashMap = iPublishElement.getTemplateArguments();
            if (hashMap == null) {
                return templateParameter.getParameterDefaultValue();
            }
        }
        catch (Exception exception) {
            return string3;
        }
        String string5 = TemplateArgument.makeCacheKey(string, string4);
        String string6 = (String)hashMap.get(string5);
        if (string6 != null) {
            return string6;
        }
        return templateParameter.getParameterDefaultValue();
    }
}

