/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.components.wcm.publish.tagparser.WCMAppendixGenerator;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WCMTagParserXAppendixs
extends BaseTagParser4List {
    protected static TagBeanInfo m_sTagBeanInfo = null;
    private List m_xAppendixs;
    private Document m_oDocument;
    protected int m_nCurrNumber = 1;
    private int m_nCurrPos = 0;
    private PublishTagContext m_nextRecordContext = null;
    private static NamesRegister s_oAppendixTypeRegister = new NamesRegister();
    private Map hmAppendix = new HashMap();

    public TagBeanInfo getBeanInfo() {
        if (m_sTagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_XAPPENDIXs");
            tagBeanInfo.setDesc("TRS_XAPPENDIXs");
            tagBeanInfo.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ID");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("OWNER");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MODE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"PIC", "FILE", "LINK", "ALL"});
            tagBeanAttrInfo.setDefaultValue("FILE");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("STARTPOS");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("0");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("NUM");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ORDER");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("WHERE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MINWIDTH");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MINHEIGHT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            m_sTagBeanInfo = tagBeanInfo;
        }
        return m_sTagBeanInfo;
    }

    public void setStartPos(int n) {
        this.m_nCurrPos = n;
    }

    public int getRecordSize() {
        return this.m_xAppendixs == null ? 0 : this.m_xAppendixs.size();
    }

    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            Appendix appendix = (Appendix)this.m_xAppendixs.get(this.m_nCurrPos++);
            PublishContentDocumentImpl publishContentDocumentImpl = new PublishContentDocumentImpl(this.m_oDocument);
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(publishContentDocumentImpl);
            this.hmAppendix.put("APPENDIX", appendix);
            this.m_nextRecordContext.setExtraAttributes(this.hmAppendix);
            return this.m_nextRecordContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        if (!publishTagContext.getTagItem().hasChildren()) {
            return null;
        }
        if (!this.isValidate(publishTagContext)) {
            return null;
        }
        CMSBaseObjs cMSBaseObjs = this.findObjects(publishTagContext);
        this.m_xAppendixs = new ArrayList(cMSBaseObjs.size());
        int n = cMSBaseObjs.size();
        for (int i = 0; i < n; ++i) {
            Appendix appendix = (Appendix)cMSBaseObjs.getAt(i);
            if (appendix == null || appendix.getFlag() == 20 && !WCMAppendixGenerator.validPic(appendix, publishTagContext)) continue;
            this.m_xAppendixs.add(appendix);
        }
        this.m_nextRecordContext = new PublishTagContext(publishTagContext, publishTagContext.getTagItem(), this);
        String[] stringArray = TagParseHelper.parse4List(publishTagContext.getTagItem(), publishTagContext, this);
        return stringArray;
    }

    protected CMSBaseObjs findObjects(PublishTagContext publishTagContext) throws WCMException {
        String string = publishTagContext.getAttribute("ID");
        this.m_oDocument = CMyString.isEmpty(string) || "OWNER".equalsIgnoreCase(string) ? WCMTagParserHelper.findDocumentHost(publishTagContext) : Document.findById(Integer.parseInt(string));
        if (this.m_oDocument == null) {
            throw new WCMException(200006, "\u6ca1\u6709\u627e\u5230\u6240\u5c5e\u7684\u6587\u6863\uff01");
        }
        Appendixes appendixes = this.getAllAppendixes(this.m_oDocument, publishTagContext);
        return appendixes;
    }

    private Appendixes getAllAppendixes(Document document, PublishTagContext publishTagContext) throws WCMException {
        String string = publishTagContext.getAttribute("RELATEDCOLUMN");
        boolean bl = !CMyString.isEmpty(string);
        int n = this.getAppendixType(publishTagContext);
        Appendixes appendixes = this.getAppMgr().getAppendixes(document, n);
        if (bl) {
            for (int i = appendixes.size() - 1; i >= 0; --i) {
                Appendix appendix = (Appendix)appendixes.getAt(i);
                if (appendix == null || string.equals(appendix.getRelatedColumn())) continue;
                appendixes.remove(appendix, false);
            }
        }
        return appendixes;
    }

    private AppendixMgr getAppMgr() {
        return (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    }

    private int getAppendixType(PublishTagContext publishTagContext) {
        String string = CMyString.showNull(publishTagContext.getAttribute("MODE"), "FILE").toUpperCase();
        return s_oAppendixTypeRegister.lookup(string, 10);
    }

    protected boolean isValidate(PublishTagContext publishTagContext) throws WCMException {
        String string = publishTagContext.getAttribute("ID");
        return CMyString.isEmpty(string) || string.indexOf(",") <= -1;
    }

    static {
        s_oAppendixTypeRegister.register("LINK", 40);
        s_oAppendixTypeRegister.register("FILE", 10);
        s_oAppendixTypeRegister.register("PIC", 20);
        s_oAppendixTypeRegister.register("ALL", 50);
    }
}

