/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.content.DefaultObj;
import com.trs.cms.content.DefaultObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WCMDocumentImagesGenerator {
    private static Logger logger = Logger.getLogger(WCMDocumentImagesGenerator.class);
    public static final String FROM_CONTENT = "content";
    public static final String FROM_APPENDIX = "appendix";
    public static final int MIN_WIDTH = 100;
    public static final int MIN_HEIGHT = 100;

    public static DefaultObjs getDocumentImages(PublishTagContext publishTagContext, Document document, int n) throws WCMException {
        String string = publishTagContext.getAttribute("FirstFrom");
        String string2 = publishTagContext.getAttribute("OnlyFrom");
        DefaultObjs defaultObjs = new DefaultObjs(null);
        defaultObjs.setPageSize(20);
        String string3 = ConfigServer.getServer().getSysConfigValue("DOCPICAPPENDIX_VALID_MIN_LIMIT", "0,0");
        int[] nArray = CMyString.splitToInt(string3, ",");
        String string4 = ConfigServer.getServer().getSysConfigValue("DOCCONTENTPIC_VALID_MIN_LIMIT", "600,400");
        int[] nArray2 = CMyString.splitToInt(string4, ",");
        int n2 = publishTagContext.getAttribute("MinWidth", nArray[0]);
        int n3 = publishTagContext.getAttribute("MinHeight", nArray[1]);
        int n4 = publishTagContext.getAttribute("MinWidth", nArray2[0]);
        int n5 = publishTagContext.getAttribute("MinHeight", nArray2[1]);
        if (!CMyString.isEmpty(string2)) {
            if (FROM_APPENDIX.equalsIgnoreCase(string2)) {
                WCMDocumentImagesGenerator.getAppendixImages(document, n, n2, n3, defaultObjs);
            } else {
                WCMDocumentImagesGenerator.getContentImages(document, n, n4, n5, defaultObjs);
            }
        } else if (!CMyString.isEmpty(string) && FROM_CONTENT.equalsIgnoreCase(string)) {
            WCMDocumentImagesGenerator.getContentImages(document, n, n4, n5, defaultObjs);
            if (defaultObjs.size() < n) {
                WCMDocumentImagesGenerator.getAppendixImages(document, n, n2, n3, defaultObjs);
            }
        } else {
            WCMDocumentImagesGenerator.getAppendixImages(document, n, n2, n3, defaultObjs);
            if (defaultObjs.size() < n) {
                WCMDocumentImagesGenerator.getContentImages(document, n, n4, n5, defaultObjs);
            }
        }
        return defaultObjs;
    }

    private static DefaultObjs getAppendixImages(Document document, int n, int n2, int n3, DefaultObjs defaultObjs) throws WCMException {
        AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        Appendixes appendixes = appendixMgr.getAppendixes(document, 20);
        int n4 = defaultObjs.size();
        for (int i = 0; i < appendixes.size() && n4 < n; ++i) {
            Appendix appendix = (Appendix)appendixes.getAt(i);
            String string = appendix.getFile();
            if (!WCMDocumentImagesGenerator.isValid(string, n2, n3)) continue;
            String string2 = appendix.getDesc();
            WCMDocumentImagesGenerator.addImage(string, string2, defaultObjs);
            n4 = defaultObjs.size();
        }
        return defaultObjs;
    }

    private static DefaultObjs getContentImages(Document document, int n, int n2, int n3, DefaultObjs defaultObjs) {
        String string = document.getHtmlContent();
        if (string == null || string.trim().equals("")) {
            return null;
        }
        String string2 = "(?is)<img\\b[^>]*\\bsrc=\"([^\"]+)?\"[^>]*?>";
        Pattern pattern = Pattern.compile(string2);
        String string3 = "(?is)<img\\b[^>]*\\btitle=\"([^\"]+)?\"[^>]*?>";
        Pattern pattern2 = Pattern.compile(string3);
        Matcher matcher = pattern.matcher(string);
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n4 = defaultObjs.size();
        while (matcher.find() && n4 < n) {
            string4 = matcher.group(1);
            if (string4 == null || string4.trim().length() == 0) continue;
            int n5 = string4.lastIndexOf("/");
            if (n5 < 0) {
                n5 = string4.lastIndexOf("\\");
            }
            if (n5 >= 0) {
                string4 = string4.substring(n5 + 1);
            }
            if (!WCMDocumentImagesGenerator.isValid(string4, n2, n3)) continue;
            string6 = matcher.group(0);
            Matcher matcher2 = pattern2.matcher(string6);
            if (matcher2.find()) {
                string5 = matcher2.group(1);
            }
            WCMDocumentImagesGenerator.addImage(string4, string5, defaultObjs);
            ++n4;
        }
        return defaultObjs;
    }

    private static void addImage(String string, String string2, DefaultObjs defaultObjs) {
        block5: {
            DefaultObj defaultObj = new DefaultObj();
            String string3 = CMyString.showNull(string2, "");
            try {
                defaultObj.setProperty("FileName", string, false);
                defaultObj.setProperty("FileDesc", string3, false);
            }
            catch (WCMException wCMException) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"\u8bbe\u7f6e\u6b63\u6587\u4e2d\u56fe\u7247\u7684\u6587\u4ef6\u540d\u5c5e\u6027\u51fa\u73b0\u5f02\u5e38", (Throwable)wCMException);
                }
                return;
            }
            defaultObj.setId(defaultObjs.size() + 1);
            defaultObj.setAddMode(false);
            try {
                defaultObjs.addElement(defaultObj);
            }
            catch (WCMException wCMException) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)"\u8bbe\u7f6e\u6b63\u6587\u4e2d\u56fe\u7247\u7684\u6587\u4ef6\u540d\u5c5e\u6027\u51fa\u73b0\u5f02\u5e38", (Throwable)wCMException);
            }
        }
    }

    private static boolean isValid(String string, int n, int n2) {
        String string2;
        try {
            string2 = FilesMan.getFilesMan().mapFilePath(string, 0) + string;
        }
        catch (WCMException wCMException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6839\u636e\u6587\u4ef6\u540d[" + string + "]\u83b7\u53d6\u6587\u4ef6\u8def\u5f84\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)wCMException);
            }
            return false;
        }
        return CMyFile.validImageFile(string2, n, n2);
    }
}

