/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.element.PublishElementsCMSObjsImpl;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.tagparser.RelNewsHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;

public class TagRelNewsParser
implements ITagParser,
ITagParser4List {
    private static ArrayList DEFAULT_FIELDS = new ArrayList(16);
    private static HashMap FIELDS_MAP;
    private TagItem m_tagItem = null;
    private IPublishElements m_contents;
    private int m_nCurrPos = 0;
    protected int m_nCurrNumber = 1;
    private PublishTagContext m_nextRecordContext = null;
    private static TagBeanInfo s_TagBeanInfo;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_RELNEWS");
            tagBeanInfo.setDesc("TRS_RELNEWS");
            tagBeanInfo.setType(TagBeanInfo.BodyType.TAMPLATE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("NUM");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("STARTPOS");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("0");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TARGET");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("_blank");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MODE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"USERDEF", "KEYWORDS", "ALL"});
            tagBeanAttrInfo.setDefaultValue("USERDEF");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MULTISITE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CHNLID");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("SORTBYRELTIME");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tagBeanInfo;
        }
        return s_TagBeanInfo;
    }

    public void setTagItem(TagItem tagItem) {
        this.m_tagItem = tagItem;
    }

    public void clear() {
        if (this.m_contents != null) {
            this.m_contents.clear();
        }
        if (this.m_nextRecordContext != null) {
            this.m_nextRecordContext = null;
        }
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
    }

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) {
        return null;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        Documents documents = RelNewsHelper.getDocuments(publishTagContext, this.getSelectFields(publishTagContext));
        if (documents == null || documents.isEmpty()) {
            return null;
        }
        this.m_contents = new PublishElementsCMSObjsImpl(documents);
        this.m_nextRecordContext = new PublishTagContext(publishTagContext, this.m_tagItem, this);
        String[] stringArray = TagParseHelper.parse4List(this.m_tagItem, publishTagContext, this);
        return stringArray;
    }

    public int getRecordSize() {
        return this.m_contents == null ? 0 : this.m_contents.size();
    }

    public void setStartPos(int n) {
        this.m_nCurrPos = n;
    }

    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            IPublishContent iPublishContent = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            int n = iPublishContent.getSubstance().getPropertyAsInt("FOLDERID", 0);
            if (n > 0) {
                Channel channel = Channel.findById(n);
                iPublishContent.setFolder((IPublishFolder)PublishElementFactory.makeElementFrom(channel));
            } else {
                iPublishContent.setFolder(iPublishContent.getOriginalHome());
            }
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(iPublishContent);
            return this.m_nextRecordContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }

    public PublishTagContext getDelegatedContext() {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        this.m_nextRecordContext.setUpperHost(null);
        return this.m_nextRecordContext;
    }

    public PublishTagContext substantiateContext(PublishTagContext publishTagContext) throws WCMException {
        try {
            IPublishContent iPublishContent = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            int n = iPublishContent.getSubstance().getPropertyAsInt("FOLDERID", 0);
            if (n > 0) {
                Channel channel = Channel.findById(n);
                iPublishContent.setFolder((IPublishFolder)PublishElementFactory.makeElementFrom(channel));
            } else {
                iPublishContent.setFolder(iPublishContent.getOriginalHome());
            }
            publishTagContext.setSequenceNumber(this.m_nCurrNumber++);
            publishTagContext.setUpperHost(iPublishContent);
            return publishTagContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSelectFields(PublishTagContext publishTagContext) {
        String string = this.m_tagItem.getExtraAttributeValue("SELECT");
        if (string == null) {
            TagItem tagItem = this.m_tagItem;
            synchronized (tagItem) {
                string = this.m_tagItem.getExtraAttributeValue("SELECT");
                if (string == null) {
                    string = this.makeSelectFields(publishTagContext);
                    this.m_tagItem.setExtraAttribute("SELECT", string);
                }
            }
        }
        return string;
    }

    private String makeSelectFields(PublishTagContext publishTagContext) {
        StringBuffer stringBuffer = new StringBuffer(256);
        ArrayList arrayList = DEFAULT_FIELDS;
        stringBuffer.append(arrayList.get(0));
        int n = arrayList.size();
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(',').append(arrayList.get(i));
        }
        ArrayList arrayList2 = TagParseHelper.makeSelectFields(this.m_tagItem, "TRS_DOCUMENT");
        DBManager dBManager = DBManager.getDBManager();
        int n2 = arrayList2.size();
        for (int i = 0; i < n2; ++i) {
            String string = (String)arrayList2.get(i);
            if (CMyString.isEmpty(string) || arrayList.contains(string = string.toUpperCase())) continue;
            String string2 = (String)FIELDS_MAP.get(string);
            boolean bl = true;
            if (string2 != null) {
                string = string2;
            } else {
                try {
                    bl = dBManager.getFieldInfo("WCMDOCUMENT", string) != null;
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            if (!bl) continue;
            stringBuffer.append(',').append(string);
        }
        return stringBuffer.toString();
    }

    static {
        DEFAULT_FIELDS.add("DOCID");
        DEFAULT_FIELDS.add("DOCCHANNEL");
        DEFAULT_FIELDS.add("DOCSTATUS");
        DEFAULT_FIELDS.add("DOCTYPE");
        DEFAULT_FIELDS.add("DOCTITLE");
        DEFAULT_FIELDS.add("CRUSER");
        DEFAULT_FIELDS.add("CRTIME");
        DEFAULT_FIELDS.add("DOCFLAG");
        DEFAULT_FIELDS.add("TITLECOLOR");
        DEFAULT_FIELDS.add("DOCLINK");
        DEFAULT_FIELDS.add("DOCFILENAME");
        DEFAULT_FIELDS.add("DOCVERSION");
        DEFAULT_FIELDS.add("DOCRELTIME");
        DEFAULT_FIELDS.add("DOCPUBTIME");
        FIELDS_MAP = new HashMap(3);
        FIELDS_MAP.put("DOCFROM", "DOCSOURCE");
        FIELDS_MAP.put("DOCHTMLCON", "DOCPUBHTMLCON");
        FIELDS_MAP.put("DOCHTMLCONTENT", "DOCPUBHTMLCON");
        s_TagBeanInfo = null;
    }
}

