/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.tagparser.IPublishTaskDocumentsCacheMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PublishTaskDocumentsCacheMgr
implements IPublishTaskDocumentsCacheMgr {
    private static Logger logger = Logger.getLogger(PublishTaskDocumentsCacheMgr.class);
    private Hashtable m_hDocumentsNumCache = new Hashtable(100);
    private Hashtable m_hDocumentsIdListCache = new Hashtable(100);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Documents get(IPublishFolder iPublishFolder, WCMFilter wCMFilter) throws WCMException {
        String string = this.makeKey(iPublishFolder, wCMFilter);
        boolean bl = this.isCached(string, wCMFilter);
        if (bl) {
            return this.getDocumentsFromCache(wCMFilter, string);
        }
        PublishTaskDocumentsCacheMgr publishTaskDocumentsCacheMgr = this;
        synchronized (publishTaskDocumentsCacheMgr) {
            bl = this.isCached(string, wCMFilter);
            if (bl) {
                return this.getDocumentsFromCache(wCMFilter, string);
            }
            Channel channel = (Channel)iPublishFolder.getSubstance();
            WCMFilter wCMFilter2 = new WCMFilter("", "WCMChnlDoc.DocStatus=?", "");
            wCMFilter2.setMaxRowNumber(PublishServerConfigMapper.getTemplateParseConfig().getWcmOutlineContentsMaxNum());
            wCMFilter2.addSearchValues(10);
            wCMFilter2.mergeWith(wCMFilter);
            Documents documents = null;
            if (Document.DOCUMENTS_GET_OPTIMIZE) {
                documents = DocumentsGetHelper.getDocuments(channel, wCMFilter2);
            } else {
                DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
                documents = documentMgr.getDocuments(channel, wCMFilter2);
            }
            this.put(string, wCMFilter, documents);
            documents.m_bNotClearIdList = true;
            return documents;
        }
    }

    private Documents getDocumentsFromCache(WCMFilter wCMFilter, String string) {
        Documents documents = new Documents(null);
        documents.setIdList((Vector)this.m_hDocumentsIdListCache.get(string), wCMFilter, true);
        return documents;
    }

    public void put(IPublishFolder iPublishFolder, WCMFilter wCMFilter, Documents documents) {
        String string = this.makeKey(iPublishFolder, wCMFilter);
        boolean bl = this.isCached(string, wCMFilter);
        if (bl) {
            return;
        }
        this.put(string, wCMFilter, documents);
    }

    private void put(String string, WCMFilter wCMFilter, Documents documents) {
        Vector vector = documents.getIdList();
        this.m_hDocumentsNumCache.put(string, new Integer(wCMFilter.getMaxRowNumber()));
        this.m_hDocumentsIdListCache.put(string, vector);
    }

    private boolean isCached(String string, WCMFilter wCMFilter) {
        Integer n = (Integer)this.m_hDocumentsNumCache.get(string);
        int n2 = -1;
        if (n != null) {
            n2 = n;
        }
        return n2 == 0 || wCMFilter.getMaxRowNumber() > 0 && n2 >= wCMFilter.getMaxRowNumber();
    }

    private String makeKey(IPublishFolder iPublishFolder, WCMFilter wCMFilter) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("^");
        stringBuffer.append(iPublishFolder.getType());
        stringBuffer.append(".");
        stringBuffer.append(iPublishFolder.getId());
        stringBuffer.append("^");
        String string = wCMFilter.getWhere();
        if (string != null) {
            stringBuffer.append(string.trim().toUpperCase());
        }
        stringBuffer.append("^");
        String string2 = wCMFilter.getOrder();
        if (string2 != null) {
            stringBuffer.append(string2.trim().toUpperCase());
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Vector<String> vector = new Vector<String>(3);
        vector.add("1");
        vector.add("2");
        System.out.println(vector.hashCode());
        vector.add("3");
        System.out.println(vector.hashCode());
        Hashtable<String, Vector<String>> hashtable = new Hashtable<String, Vector<String>>();
        hashtable.put("1", vector);
        System.out.println(vector);
        ((Vector)vector.clone()).clear();
        System.out.println(vector);
    }
}

