/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.region;

import com.trs.ajaxservice.xmlconvertors.XMLToCMSObj;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.region.CellInfo;
import com.trs.components.wcm.publish.region.CellInfos;
import com.trs.components.wcm.publish.region.RegionInfo;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class CellServiceProvider
implements IGlueServiceProvider {
    public void delete(MethodContext methodContext) throws Throwable {
    }

    public Object query(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("RegionInfoId", 0);
        RegionInfo regionInfo = RegionInfo.findById(n);
        if (regionInfo == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5bfc\u8bfb\u4e0d\u5b58\u5728[ID=" + n + "]");
        }
        User user = ContextHelper.getLoginUser();
        this.validRight(user, regionInfo);
        return CellInfos.findCellInfos(regionInfo, methodContext.getExtraWCMFilter());
    }

    public int save(MethodContext methodContext) throws Throwable {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCells(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("RegionInfoId", 0);
        RegionInfo regionInfo = RegionInfo.findById(n);
        if (regionInfo == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5bfc\u8bfb\u4e0d\u5b58\u5728[ID=" + n + "]");
        }
        User user = ContextHelper.getLoginUser();
        this.validRight(user, regionInfo);
        XMLToCMSObj xMLToCMSObj = new XMLToCMSObj(user, new CellInfo());
        xMLToCMSObj.parse(methodContext.getValue("CellsXML"));
        String string = xMLToCMSObj.getObjectIds();
        if (CMyString.isEmpty(string)) {
            throw new WCMException("\u6ca1\u6709\u8bbe\u7f6e\u4efb\u4f55\u5bfc\u8bfb\u5185\u5bb9\uff1f");
        }
        WCMFilter wCMFilter = new WCMFilter("", "CELLINFOID not in(" + string + ")", "");
        CellInfos cellInfos = CellInfos.findCellInfos(regionInfo, wCMFilter, user);
        cellInfos.removeAll(true);
        boolean bl = true;
        try {
            int n2 = xMLToCMSObj.getCMSObjs().length;
            for (int i = 0; i < n2; ++i) {
                CellInfo cellInfo = (CellInfo)xMLToCMSObj.getCMSObjs()[i];
                if (cellInfo == null) continue;
                if (cellInfo.isAddMode()) {
                    cellInfo.setRegionInfoId(n);
                }
                cellInfo.save(user);
            }
            bl = false;
            Object var14_13 = null;
            if (bl) {
                xMLToCMSObj.cancelUpdate();
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (bl) {
                xMLToCMSObj.cancelUpdate();
            }
            throw throwable;
        }
    }

    private void validRight(User user, RegionInfo regionInfo) throws WCMException {
        int n = regionInfo.getChannelId();
        int n2 = regionInfo.getWebSiteId();
        Channel channel = Channel.findById(n);
        WebSite webSite = WebSite.findById(n2);
        BaseChannel baseChannel = channel;
        if (baseChannel == null) {
            baseChannel = webSite;
        }
        if (baseChannel != null) {
            if (!AuthServer.hasRight(user, (CMSObj)baseChannel, 48)) {
                throw new WCMException("\u60a8[" + user.getName() + "]\u6ca1\u6709\u6743\u9650\u7ba1\u7406[" + baseChannel + "]\u7684\u5bfc\u8bfb\uff01");
            }
        } else {
            throw new WCMException("\u6307\u5b9a\u5bfc\u8bfb\u6240\u5728\u7684\u680f\u76ee[ID=" + n + "]\u548c\u7ad9\u70b9[ID=" + n2 + "\u4e0d\u5b58\u5728");
        }
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        return null;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return null;
    }
}

