/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish;

import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class WCMFolderPublishConfigLCListener
implements IObjectLCListenerOnModify {
    private static Logger s_logger = Logger.getLogger(WCMFolderPublishConfigLCListener.class);

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (this.isListening(baseObj)) {
            int n2 = baseObj.getWCMType();
            int n3 = baseObj.getId();
            WCMFolderPublishConfig wCMFolderPublishConfig = WCMFolderPublishConfig.findOf(baseObj.getWCMType(), baseObj.getId());
            int n4 = baseObj.getNewPropertyAsInt("PARENTID", 0);
            if (wCMFolderPublishConfig != null) {
                Templates templates;
                IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.lookupElement(n2, n3);
                String string = this.getParentIdChain(n4) + n3;
                TemplateEmployMgr templateEmployMgr = wCMFolderPublishConfig.getTemplateEmployMgr();
                DBManager dBManager = DBManager.getDBManager();
                Template template = templateEmployMgr.getDetailTemplate(iPublishFolder);
                if (template != null && !this.isExistsTemplate(string, template, dBManager)) {
                    templateEmployMgr.setDetailTemplate(iPublishFolder, 0, true);
                }
                if ((templates = templateEmployMgr.getOutlineTemplates(iPublishFolder)).isEmpty()) {
                    return;
                }
                String string2 = "";
                boolean bl = false;
                for (int i = 0; i < templates.size(); ++i) {
                    Template template2 = (Template)templates.getAt(i);
                    if (this.isExistsTemplate(string, template2, dBManager)) {
                        string2 = string2 + "," + template2.getId();
                        continue;
                    }
                    bl = true;
                }
                if ("".equals(string2)) {
                    string2 = "0";
                    bl = true;
                }
                if (bl) {
                    templateEmployMgr.setOutlineTemplates(iPublishFolder, string2, true);
                }
            }
        }
    }

    private boolean isExistsTemplate(String string, Template template, DBManager dBManager) {
        if (template == null) {
            return false;
        }
        try {
            if (template.getFolder().isRoot()) {
                return true;
            }
            String string2 = "SELECT TEMPID FROM WCMTEMPLATE WHERE TEMPID=" + template.getId() + " and FolderType=" + 101 + " and FolderId in(" + string + ")";
            return dBManager.sqlExecuteIntQuery(string2) > 0;
        }
        catch (Exception exception) {
            s_logger.error((Object)"template exists checked failed", (Throwable)exception);
            return false;
        }
    }

    private boolean isListening(BaseObj baseObj) {
        return this.isValidInstance(baseObj) && this.isNotifyNeeded((Channel)baseObj);
    }

    private boolean isValidInstance(BaseObj baseObj) {
        return baseObj != null && baseObj instanceof Channel;
    }

    private boolean isNotifyNeeded(Channel channel) {
        return channel.isChangeProperty("PARENTID") && !this.isSpecial(channel);
    }

    private boolean isSpecial(Channel channel) {
        return 1 == channel.getType() || 2 == channel.getType();
    }

    private String getParentIdChain(int n) throws WCMException {
        String string = "";
        if (n != 0) {
            Channel channel = Channel.findById(n);
            string = string + n + "," + this.getParentIdChain(channel.getParentId());
        }
        return string;
    }

    public static void main(String[] stringArray) {
        WCMFolderPublishConfigLCListener wCMFolderPublishConfigLCListener = new WCMFolderPublishConfigLCListener();
        try {
            System.out.println("test:" + wCMFolderPublishConfigLCListener.getParentIdChain(12));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

