/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.HTMLContent;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.XmlToDocumentConverter;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.epress.EPressConf;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EPressImporter {
    private static final String PATTERN_HTML = "<{1}[^>]{1,}>{1}";
    protected XmlToDocumentConverter m_converter;
    private Map m_currChannels = null;
    private static Logger s_logger = Logger.getLogger(EPressImporter.class);
    private static final String CHILD_TAG_APPENDIXES = "WCMAPPENDIXS";
    private DocumentMgr m_documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    private static String[] HTML_TAG_NAMES;
    private static String[] HTML_TAG_SRCS;

    public EPressImporter() {
        this.m_converter = new XmlToDocumentConverter(1);
        this.m_converter.registPersistentObj("WCMDOCUMENT", Document.class);
        this.m_converter.registPersistentObj("WCMAPPENDIX", Appendix.class);
    }

    public void importDocuments(String string) throws WCMException {
        this.importDocuments(string, "");
    }

    public void importDocuments(String string, Channel channel) throws WCMException {
        if (channel == null) {
            throw new WCMException("\u65e0\u6548\u7684\u7535\u5b50\u62a5\u9891\u9053[null]!");
        }
        int n = channel.getId();
        this.m_currChannels = EPressConf.instance().getChannels(n);
        if (this.m_currChannels == null) {
            throw new WCMException("\u65e0\u6548\u7684\u7535\u5b50\u62a5\u9891\u9053" + channel + "!");
        }
        this.importData(string);
    }

    public void importDocuments(String string, String string2) throws WCMException {
        this.m_currChannels = EPressConf.instance().getChannels(string2);
        if (this.m_currChannels == null) {
            throw new WCMException("\u65e0\u6548\u7684\u7535\u5b50\u62a5\u9891\u9053\u6807\u8bc6[key=" + string2 + "]!");
        }
        this.importData(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void importData(String string) throws WCMException {
        XmlObject[] xmlObjectArray;
        CMyUnZipFile cMyUnZipFile;
        String string2;
        block9: {
            String string3 = this.getFullFileName(string);
            String string4 = CMyFile.extractFilePath(string3) + "uziptemp";
            string4 = string4 + CMyFile.extractMainFileName(string3);
            string2 = string4 + File.separator;
            cMyUnZipFile = new CMyUnZipFile(string3, string2);
            boolean bl = false;
            try {
                try {
                    cMyUnZipFile.addFileExtFilters("xml");
                    cMyUnZipFile.doUnZipAnd();
                    bl = true;
                }
                catch (CMyException cMyException) {
                    throw new WCMException(200, "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25!", cMyException);
                }
                xmlObjectArray = null;
                if (!bl) break block9;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (!bl) throw throwable;
                CMyFile.deleteFile(string3);
                throw throwable;
            }
            CMyFile.deleteFile(string3);
        }
        try {
            ArrayList arrayList = cMyUnZipFile.getFilteredFiles();
            if (arrayList == null) throw new WCMException(10, "\u6ca1\u6709\u6709\u6548\u7684XML\u6570\u636e\u6587\u4ef6.");
            if (arrayList.isEmpty()) {
                throw new WCMException(10, "\u6ca1\u6709\u6709\u6548\u7684XML\u6570\u636e\u6587\u4ef6.");
            }
            String string5 = null;
            xmlObjectArray = null;
            if (arrayList != null && arrayList.size() > 0) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    string5 = (String)arrayList.get(i);
                    if (string5 == null) continue;
                    xmlObjectArray = this.m_converter.convertXml(string5, null, null);
                    this.importData0(xmlObjectArray, CMyFile.extractFilePath(string5));
                }
            }
            Object var13_15 = null;
            cMyUnZipFile = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            cMyUnZipFile = null;
            CMyFile.deleteDir(string2);
            throw throwable;
        }
        CMyFile.deleteDir(string2);
    }

    private void importData0(XmlObject[] xmlObjectArray, String string) throws WCMException {
        XmlObject xmlObject = null;
        Document document = null;
        User user = this.getLoginUser();
        ContextHelper.initContext(user);
        String string2 = "";
        String string3 = "";
        Object var8_8 = null;
        Channel channel = null;
        String string4 = null;
        String string5 = null;
        for (int i = xmlObjectArray.length - 1; i >= 0; --i) {
            xmlObject = xmlObjectArray[i];
            document = (Document)xmlObject.getCurrentObj();
            if (CMyString.isEmpty(string2) && CMyString.isEmpty(string2 = document.getPropertyAsString("PageNum"))) {
                throw new WCMException(10, "\u6ca1\u6709\u8bbe\u5b9a\u65b0\u95fb\u6240\u5c5e\u7248\u6b21");
            }
            string5 = document.getTitle();
            if (CMyString.isEmpty(string5)) {
                throw new WCMException(10, "\u6ca1\u6709\u8bbe\u5b9a\u65b0\u95fb\u6807\u9898");
            }
            channel = document.getChannel();
            if (channel == null) {
                string2 = string2.trim();
                document.setProperty("PageNum", string2);
                if (string2.startsWith("0")) {
                    string2 = Integer.valueOf(string2).toString();
                }
                if (this.m_currChannels != null) {
                    var8_8 = this.m_currChannels.get(string2);
                }
                if (var8_8 == null) {
                    throw new WCMException(1106, "\u6ca1\u6709\u8fd9\u4e2a\u7248\u9762[" + string2 + "]");
                }
                document.setProperty("DOCCHANNEL", var8_8);
                if (CMyString.isEmpty(string3)) {
                    string3 = document.getPropertyAsString("PUBLISHDATE");
                }
                string3 = CMyString.isEmpty(string3) ? CMyDateTime.now().toString("yyyy.MM.dd") : this.makePubDate(string3);
                document.setProperty("Publishdate", string3);
            }
            if ((string4 = document.getCrUserName()) == null || User.findByName(string4) == null) {
                string4 = "system";
            }
            document.setProperty("CRUSER", string4);
            document.setProperty("CrTime", CMyDateTime.now());
            document.removeProperty("DOCPUBTIME");
            document = this.processHtmlContent(document, string);
            document = this.updateIfExists(document);
            this.m_documentMgr.save(document);
            this.processAppendix(xmlObject, document.getId(), string);
        }
    }

    private Document updateIfExists(Document document) {
        int n = document.getChannelId();
        String string = document.getTitle();
        String string2 = document.getPropertyAsString("PUBLISHDATE");
        WCMFilter wCMFilter = new WCMFilter("", "DOCCHANNEL=? and DOCTITLE=? and PUBLISHDATE=?", "", "DOCID");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(string);
        wCMFilter.addSearchValues(string2);
        wCMFilter.setMaxRowNumber(1);
        Documents documents = new Documents(this.getLoginUser());
        try {
            documents.open(wCMFilter);
            if (documents.isEmpty()) {
                return document;
            }
            Document document2 = (Document)documents.getAt(0);
            document2.setProperties(document.getProperties());
            return document2;
        }
        catch (WCMException wCMException) {
            return document;
        }
    }

    private String makePubDate(String string) throws WCMException {
        StringBuffer stringBuffer = new StringBuffer(64);
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 3) {
            stringBuffer.append("\u65e0\u6548\u7684\u65e5\u671f[");
            stringBuffer.append(string);
            stringBuffer.append("].\u53ef\u80fd\u662f\u683c\u5f0f\u4e0d\u6b63\u786e,\u8981\u6c42\u7684\u683c\u5f0f\u662f[yyyy.MM.dd]!");
            throw new WCMException(stringBuffer.toString());
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        try {
            n = Integer.parseInt(stringArray[0]);
            n2 = Integer.parseInt(stringArray[1]);
            n3 = Integer.parseInt(stringArray[2]);
            bl = n >= 1 && n2 >= 1 && n2 <= 12 && n3 >= 1 && n3 <= 31;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (bl) {
            if (n2 == 2) {
                bl = n % 400 == 0 || n % 4 == 0 && n % 100 != 0 ? n3 <= 29 : n3 <= 28;
            } else if ((n2 & 1) == 1) {
                bl = n2 < 8 && n3 <= 31 || n2 >= 8 && n3 <= 30;
            } else {
                boolean bl2 = bl = n2 >= 8 && n3 <= 31 || n2 < 8 && n3 <= 30;
            }
        }
        if (!bl) {
            stringBuffer.append("\u65e0\u6548\u7684\u65e5\u671f[");
            stringBuffer.append(string);
            stringBuffer.append("]!");
            throw new WCMException(stringBuffer.toString());
        }
        stringBuffer.append(n);
        stringBuffer.append('.');
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        stringBuffer.append('.');
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
        return stringBuffer.toString();
    }

    private Document processHtmlContent(Document document, String string) {
        if (20 != document.getType()) {
            return document;
        }
        String string2 = document.getHtmlContent();
        if (string2 == null || string2.length() == 0) {
            return document;
        }
        try {
            HashMap hashMap = this.getPicFiles(document, string);
            string2 = HTMLContent.saveHTMLContentFromOut(string2, hashMap);
            document.setHtmlContent(string2);
            string2 = string2.replaceAll("<br>", "\n\r");
            document.setContent(string2.replaceAll(PATTERN_HTML, ""));
        }
        catch (WCMException wCMException) {
            s_logger.warn((Object)"process htmlcon with exception.", (Throwable)wCMException);
        }
        return document;
    }

    private HashMap getPicFiles(Document document, String string) throws WCMException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = this.getTagNames();
        if (stringArray == null) {
            return hashMap;
        }
        String[] stringArray2 = this.getTagAttrsrcNames();
        String string2 = document.getHtmlContent();
        HtmlElementFinder htmlElementFinder = null;
        HtmlElement htmlElement = null;
        try {
            int n = stringArray.length;
            int n2 = stringArray2.length;
            for (int i = 0; i < n && i < n2; ++i) {
                String string3 = stringArray[i];
                String string4 = stringArray2[i];
                htmlElementFinder = new HtmlElementFinder(string2);
                while ((htmlElement = htmlElementFinder.findNextElement(string3, true)) != null) {
                    String string5 = htmlElement.getAttributeValue(string4);
                    if (string5 == null || string5.trim().length() == 0) continue;
                    if (File.separatorChar != '/') {
                        string5 = string5.replace('/', File.separatorChar);
                    }
                    string5 = CMyFile.extractFileName(string5);
                    hashMap.put(string5.toLowerCase(), string + string5);
                }
            }
            return hashMap;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "\u83b7\u53d6\u6b63\u6587\u4e2d\u9700\u8981\u5904\u7406\u7684\u7f6e\u6807\u8d44\u6e90\u5931\u8d25!", exception);
        }
    }

    private String[] getTagNames() {
        if (HTML_TAG_NAMES != null) {
            return HTML_TAG_NAMES;
        }
        ConfigServer configServer = ConfigServer.getServer();
        String string = configServer.getInitProperty("DOC_HTML_TAG_NAMES");
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            HTML_TAG_NAMES = CMyString.split(string, ",");
        }
        catch (Exception exception) {
            HTML_TAG_NAMES = null;
        }
        return HTML_TAG_NAMES;
    }

    private String[] getTagAttrsrcNames() {
        if (HTML_TAG_SRCS != null) {
            return HTML_TAG_SRCS;
        }
        ConfigServer configServer = ConfigServer.getServer();
        String string = configServer.getInitProperty("DOC_HTML_TAG_SRCS");
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            HTML_TAG_SRCS = CMyString.split(string, ",");
        }
        catch (Exception exception) {
            HTML_TAG_SRCS = null;
        }
        return HTML_TAG_SRCS;
    }

    private void processAppendix(XmlObject xmlObject, int n, String string) throws WCMException {
        XmlObject[] xmlObjectArray = xmlObject.getChild(CHILD_TAG_APPENDIXES);
        if (xmlObjectArray.length == 0) {
            return;
        }
        Appendixes appendixes = new Appendixes(this.getLoginUser());
        WCMFilter wCMFilter = new WCMFilter("", "APPDOCID=?", "");
        wCMFilter.addSearchValues(n);
        appendixes.open(wCMFilter);
        if (!appendixes.isEmpty()) {
            appendixes.removeAll(true);
        }
        Appendix appendix = null;
        String string2 = null;
        String string3 = null;
        FilesMan filesMan = FilesMan.getFilesMan();
        String string4 = string;
        User user = this.getLoginUser();
        boolean bl = false;
        int n2 = xmlObjectArray.length;
        for (int i = 0; i < n2; ++i) {
            appendix = (Appendix)xmlObjectArray[i].getCurrentObj();
            appendix.setDocId(n);
            appendix.setUsedByVersion(0, true);
            int n3 = appendix.getFlag();
            if (n3 != 40) {
                if (n3 == 30) continue;
                appendix.setSrcFile(appendix.getFile());
                String string5 = appendix.getDesc();
                if (string5 == null || string5.length() == 0) {
                    appendix.setDesc(appendix.getFile());
                }
                if (n3 == 20) {
                    string2 = filesMan.getNextFileName("W0", appendix.getFileExt());
                    bl = true;
                } else {
                    string2 = filesMan.getNextFileName("P0", appendix.getFileExt());
                }
                string3 = filesMan.mapFilePath(string2, 0);
                try {
                    CMyFile.copyFile(string4 + appendix.getFile(), string3 + string2);
                }
                catch (CMyException cMyException) {
                    s_logger.warn((Object)("missing file:" + appendix.getFile()));
                    continue;
                }
                appendix.setFile(string2);
                if (appendix.getProperty("APPSERN") == null) {
                    appendix.setSerialNo(i + 1);
                }
            }
            appendix.save(user);
        }
        if (bl) {
            this.setAttachpicFlag(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setAttachpicFlag(int n) {
        block16: {
            PreparedStatement preparedStatement;
            Connection connection;
            DBManager dBManager;
            block14: {
                dBManager = DBManager.getDBManager();
                connection = null;
                preparedStatement = null;
                String string = "update WCMDOCUMENT set ATTACHPIC=1 where DOCID=?";
                connection = dBManager.getConnection();
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setInt(1, n);
                preparedStatement.executeUpdate();
                Object var8_6 = null;
                if (preparedStatement == null) break block14;
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
            break block16;
            {
                catch (Exception exception) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.error((Object)"set flag fail", (Throwable)exception);
                    }
                    Object var8_7 = null;
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        dBManager.freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    dBManager.freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    private User getLoginUser() {
        User user = User.getSystem();
        try {
            user = ContextHelper.getLoginUser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return user;
    }

    private String getFullFileName(String string) throws WCMException {
        String string2 = string;
        if (!CMyFile.fileExists(string)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            String string3 = filesMan.mapFilePath(string, 0);
            string2 = string3 + string;
        }
        return string2;
    }

    public static void main(String[] stringArray) {
    }
}

