/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.customize;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.customize.UserSetting;
import com.trs.components.wcm.customize.UserSettings;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import org.apache.log4j.Logger;

public class CustomizeMgr {
    private static Logger m_oLogger = Logger.getLogger((String)CustomizeMgr.class.getName());
    private static final int[] VALID_MOUDEL_TYPES = new int[]{306, 304, 309, 605, 102, 204};

    public boolean save(int n) throws WCMException {
        Object object;
        if (!this.isValidMoudelType(n)) {
            throw new WCMException(10, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label1", "\u65e0\u6548\u7684\u529f\u80fd\u6a21\u5757\u7c7b\u578b[") + WCMTypes.getObjName(n, true) + "]!");
        }
        try {
            object = "SELECT COUNT(*) FROM WCMUserSetting WHERE ObjType=" + n + " AND UserId=" + ContextHelper.getLoginUser().getId();
            if (DBManager.getDBManager().sqlExecuteIntQuery((String)object) != 0) {
                return true;
            }
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label2", "\u7cfb\u7edf\u5f02\u5e38!"), exception);
        }
        object = UserSetting.createNewInstance();
        ((CMSObj)object).canEdit(ContextHelper.getLoginUser());
        ((UserSetting)object).setUser(ContextHelper.getLoginUser());
        ((UserSetting)object).setObjType(n);
        ((UserSetting)object).setObjId(0);
        ((UserSetting)object).insert(ContextHelper.getLoginUser());
        return true;
    }

    public boolean delete(int n) throws WCMException {
        if (ContextHelper.getLoginUser() == null) {
            throw new WCMException(10, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label3", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61!"));
        }
        String string = "DELETE FROM WCMUserSetting WHERE ObjType=" + n + " AND UserId=" + ContextHelper.getLoginUser().getId();
        return this.getDBManager().sqlExecuteUpdate(string) == 1;
    }

    public int[] getMoudels() throws WCMException {
        if (ContextHelper.getLoginUser() == null) {
            throw new WCMException(10, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label3", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61!"));
        }
        String string = "UserId=" + ContextHelper.getLoginUser().getId() + " AND ObjType<>" + 101;
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        UserSettings userSettings = UserSettings.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        UserSetting userSetting = null;
        int[] nArray = new int[userSettings.size()];
        for (int i = 0; i < userSettings.size(); ++i) {
            userSetting = (UserSetting)userSettings.getAt(i);
            if (userSetting == null) continue;
            nArray[i] = userSetting.getObjType();
        }
        return nArray;
    }

    public boolean hasCustomized() throws Exception {
        String string = "SELECT COUNT(*) FROM WCMUserSetting WHERE UserId=" + ContextHelper.getLoginUser().getId();
        return DBManager.getDBManager().sqlExecuteIntQuery(string) > 0;
    }

    public boolean saveChannels(int[] nArray) throws WCMException {
        if (nArray == null || nArray.length == 0) {
            return true;
        }
        String string = "DELETE FROM WCMUserSetting WHERE ObjType=101 AND UserId=" + ContextHelper.getLoginUser().getId();
        this.getDBManager().sqlExecuteUpdate(string);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            this.saveChannel(nArray[i]);
        }
        return true;
    }

    public boolean deleteChannels(int[] nArray) throws WCMException {
        if (nArray == null || nArray.length == 0) {
            return true;
        }
        String string = "DELETE FROM WCMUserSetting WHERE ObjType=101 AND UserId=" + ContextHelper.getLoginUser().getId();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string + " AND ObjId=" + nArray[i];
        }
        return this.getDBManager().sqlExecuteUpdate(stringArray) == 1;
    }

    public Channels getChannels() throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "UserId=" + ContextHelper.getLoginUser().getId() + " AND ObjType=" + 101, "RangeIndex desc,SettingId asc", "ObjId");
        UserSettings userSettings = UserSettings.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        String string = "";
        UserSetting userSetting = null;
        for (int i = 0; i < userSettings.size(); ++i) {
            userSetting = (UserSetting)userSettings.getAt(i);
            if (userSetting == null) continue;
            if (string.length() == 0) {
                string = string + userSetting.getObjId();
            }
            string = string + "," + userSetting.getObjId();
        }
        if (string.length() == 0) {
            return Channels.createNewInstance(ContextHelper.getLoginUser());
        }
        return Channels.findByIds(ContextHelper.getLoginUser(), string);
    }

    private boolean saveChannel(int n) throws WCMException {
        Object object;
        Channel channel = Channel.findById(n);
        if (channel == null) {
            return true;
        }
        try {
            object = "SELECT COUNT(*) FROM WCMUserSetting WHERE ObjType=101 AND UserId=" + ContextHelper.getLoginUser().getId() + " AND ObjId=" + n;
            if (DBManager.getDBManager().sqlExecuteIntQuery((String)object) != 0) {
                return true;
            }
        }
        catch (Exception exception) {
            m_oLogger.error((Object)I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label4", "\u7cfb\u7edf\u5f02\u5e38:"), (Throwable)exception);
            throw new WCMException(1100, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label2", "\u7cfb\u7edf\u5f02\u5e38!"), exception);
        }
        object = UserSetting.createNewInstance();
        ((CMSObj)object).canEdit(ContextHelper.getLoginUser());
        ((UserSetting)object).setUser(ContextHelper.getLoginUser());
        ((UserSetting)object).setObjType(101);
        ((UserSetting)object).setObjId(n);
        ((UserSetting)object).insert(ContextHelper.getLoginUser());
        return true;
    }

    private boolean isValidMoudelType(int n) {
        int[] nArray = VALID_MOUDEL_TYPES;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager dBManager = DBManager.getDBManager();
        if (dBManager == null || !dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label5", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label6", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return dBManager;
    }

    public UserSetting find(User user, int n) throws WCMException {
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label7", "\u65e0\u6cd5\u7684\u7528\u6237\u5bf9\u8c61!"));
        }
        User user2 = ContextHelper.getLoginUser();
        if (!user.equals(user2)) {
            throw new WCMException(1002, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label8", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u67e5\u770b\u5176\u5b83\u7528\u6237\u7684\u5b9a\u5236!"));
        }
        WCMFilter wCMFilter = new WCMFilter("", "UserId=" + user.getId() + " AND Region=" + n, "");
        UserSettings userSettings = UserSettings.openWCMObjs(user, wCMFilter);
        UserSetting userSetting = null;
        if (!userSettings.isEmpty()) {
            userSetting = (UserSetting)userSettings.getAt(0);
        }
        return userSetting;
    }

    public void saveSetting(BaseObj baseObj, int n, int n2) throws WCMException {
        this.saveSetting(baseObj, n, n2, null);
    }

    public void saveSetting(BaseObj baseObj, int n, int n2, String string) throws WCMException {
        UserSetting userSetting = UserSetting.createNewInstance();
        userSetting.setObjId(baseObj.getId());
        userSetting.setObjType(baseObj.getWCMType());
        userSetting.setOrder(n);
        userSetting.setRegion(n2);
        userSetting.setUser(ContextHelper.getLoginUser());
        if (string != null) {
            userSetting.setValue(string);
        }
        userSetting.save();
    }
}

