/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Replace;
import com.trs.components.wcm.content.persistent.Replaces;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.cache.ICacheMgr;
import java.util.HashMap;
import java.util.Map;

public class ReplaceCacheMgr
implements ICacheMgr {
    private static final char CHAR_UNDERSCORE = '_';
    private static final String PROPERTY_REPLACENAME = "REPLACENAME";
    private static final String PROPERTY_REPLACECONTENT = "REPLACECONTENT";
    private Map m_hmRepalceCache = null;

    String getReplaceContent(int n, String string) throws WCMException {
        this.assertNameNotEmpty(string);
        return (String)this.getRepalceCache().get(this.makeKey(n, string));
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (this.notified(baseObj)) {
            Replace replace = (Replace)baseObj;
            this.getRepalceCache().put(this.makeKey(replace), replace.getContent());
        }
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (this.notified(baseObj)) {
            Replace replace = (Replace)baseObj;
            this.getRepalceCache().remove(this.makeKey(replace));
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (this.notified(baseObj)) {
            Replace replace = (Replace)baseObj;
            boolean bl = replace.isChangeProperty(PROPERTY_REPLACENAME);
            boolean bl2 = replace.isChangeProperty(PROPERTY_REPLACECONTENT);
            if (!bl && !bl2) {
                return;
            }
            if (bl && !bl2) {
                String string = replace.getNewPropertyAsString(PROPERTY_REPLACENAME);
                String string2 = this.makeKey(replace.getChnlId(), string);
                this.getRepalceCache().remove(this.makeKey(replace));
                this.getRepalceCache().put(string2, replace.getContent());
                return;
            }
            if (!bl && bl2) {
                String string = replace.getNewPropertyAsString(PROPERTY_REPLACECONTENT);
                this.getRepalceCache().put(this.makeKey(replace), string);
                return;
            }
            if (bl && bl2) {
                String string = replace.getNewPropertyAsString(PROPERTY_REPLACENAME);
                String string3 = replace.getChnlId() + 95 + string;
                String string4 = replace.getNewPropertyAsString(PROPERTY_REPLACECONTENT);
                this.getRepalceCache().remove(this.makeKey(replace));
                this.getRepalceCache().put(string3, string4);
                return;
            }
        }
    }

    private boolean notified(BaseObj baseObj) {
        if (baseObj == null) {
            return false;
        }
        return 105 == baseObj.getWCMType();
    }

    private synchronized void loadReplaces() throws WCMException {
        if (this.m_hmRepalceCache != null) {
            return;
        }
        Replaces replaces = Replaces.openWCMObjs(User.getSystem(), null);
        HashMap<String, String> hashMap = new HashMap<String, String>(replaces.size(), 1.0f);
        Replace replace = null;
        for (int i = 0; i < replaces.size(); ++i) {
            replace = (Replace)replaces.getAt(i);
            if (replace == null) continue;
            hashMap.put(this.makeKey(replace), replace.getContent());
        }
        this.m_hmRepalceCache = hashMap;
    }

    private String makeKey(Replace replace) {
        return replace.getChnlId() + 95 + replace.getName();
    }

    private String makeKey(int n, String string) {
        return n + 95 + string;
    }

    private void assertNameNotEmpty(String string) throws WCMException {
        if (string == null || string.trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(ReplaceCacheMgr.class, "ReplaceCacheMgr.label1", "\u65e0\u6548\u7684\u66ff\u6362\u5185\u5bb9\u5bf9\u8c61\u7684\u540d\u79f0!"));
        }
    }

    public boolean init() throws WCMException {
        if (this.m_hmRepalceCache != null) {
            return true;
        }
        this.loadReplaces();
        return true;
    }

    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    public void clear() {
        if (this.m_hmRepalceCache == null) {
            return;
        }
        this.m_hmRepalceCache.clear();
        this.m_hmRepalceCache = null;
    }

    public Map getRepalceCache() throws WCMException {
        if (this.m_hmRepalceCache == null) {
            this.loadReplaces();
        }
        return this.m_hmRepalceCache;
    }
}

