/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.ExtendedField;
import com.trs.cms.content.ExtendedFields;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DataType;

public class ContentExtField
extends CMSObj {
    private ExtendedField m_extfield;
    public static final int OBJ_TYPE = 1319922479;
    public static final String DB_TABLE_NAME = "WCMCONTENTEXTFIELD";
    public static final String DB_ID_NAME = "CONTENTEXTFIELDID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 1319922479;
    }

    public int getObjId() {
        return this.getPropertyAsInt("OBJID", 0);
    }

    public boolean setObjId(int n) throws WCMException {
        return this.setProperty("OBJID", n);
    }

    public int getObjType() {
        return this.getPropertyAsInt("OBJTYPE", 0);
    }

    public boolean setObjType(int n) throws WCMException {
        return this.setProperty("OBJTYPE", n);
    }

    public String getDesc() {
        return this.getPropertyAsString("LOGICFIELDDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("LOGICFIELDDESC", string);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("OBJID") == null) {
                throw new WCMException(1106, I18NMessage.get(ContentExtField.class, "ContentExtField.label1", "\u5c5e\u6027ObjId\u6ca1\u6709\u8bbe\u7f6e(ContentExtField.isValid)"));
            }
            if (this.getProperty("OBJTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(ContentExtField.class, "ContentExtField.label2", "\u5c5e\u6027ObjType\u6ca1\u6709\u8bbe\u7f6e(ContentExtField.isValid)"));
            }
            if (this.getProperty("EXTFIELDID") == null) {
                throw new WCMException(1106, I18NMessage.get(ContentExtField.class, "ContentExtField.label3", "\u5c5e\u6027ExtFieldId\u6ca1\u6709\u8bbe\u7f6e(ContentExtField.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(ContentExtField.class, "ContentExtField.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ContentExtField.isValid)"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            Object object;
            if (this.getProperty("EXTFIELDID") == null) {
                object = this.findExtfield(user);
                if (object == null) {
                    this.m_extfield.save(user);
                    this.setExtFieldId(this.m_extfield.getId());
                } else {
                    this.setExtFieldId(((BaseObj)object).getId());
                }
            }
            if (this.logicFieldExists()) {
                object = "";
                try {
                    object = (String)object + this.getHost();
                }
                catch (Exception exception) {
                    object = (String)object + I18NMessage.get(ContentExtField.class, "ContentExtField.label5", "\u5bf9\u8c61[Id=") + this.getObjId() + ",Type=" + this.getObjType() + "]";
                }
                object = (String)object + I18NMessage.get(ContentExtField.class, "ContentExtField.label6", "\u4e0b\u5df2\u7ecf\u5b58\u5728[") + this.getExtendedField() + "]!";
                throw new WCMException(1100, (String)object);
            }
            super.insert(user);
        }
    }

    private boolean logicFieldExists() throws WCMException {
        String string = " ObjId=" + this.getObjId() + " AND ObjType=" + this.getObjType() + " AND ExtFieldId=" + this.getExtFieldId();
        return this.checkExists(string);
    }

    private ExtendedField findExtfield(User user) throws WCMException {
        String string = "FieldName='" + CMyString.filterForSQL(this.m_extfield.getName()) + "' AND TableName='" + CMyString.filterForSQL(this.m_extfield.getTableName()) + "'";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.setMaxRowNumber(1);
        ExtendedFields extendedFields = new ExtendedFields(user);
        extendedFields.open(wCMFilter);
        if (extendedFields.isEmpty()) {
            return null;
        }
        return (ExtendedField)extendedFields.getAt(0);
    }

    public String getTableName() {
        return this.getExtendedField().getTableName();
    }

    public boolean setTableName(String string) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(ContentExtField.class, "ContentExtField.label7", "\u5c5e\u6027TableName\u4e0d\u5141\u8bb8\u4fee\u6539"));
        }
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(ContentExtField.class, "ContentExtField.label8", "\u6307\u5b9a\u7684\u8868\u540d\u79f0\u4e3a\u7a7a"));
        }
        string = string.toUpperCase();
        if (this.getDBManager().getTableInfo(string) == null) {
            throw new WCMException(10, I18NMessage.get(ContentExtField.class, "ContentExtField.label9", "\u6307\u5b9a\u7684\u6570\u636e\u8868") + string + I18NMessage.get(ContentExtField.class, "ContentExtField.label10", "\u4e0d\u5b58\u5728!"));
        }
        return this.getExtendedField().setTableName(string);
    }

    public String getName() {
        return this.getExtendedField().getName();
    }

    public boolean setName(String string) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(ContentExtField.class, "ContentExtField.label11", "\u5c5e\u6027Name\u4e0d\u5141\u8bb8\u4fee\u6539\uff08ExtendedField.setName\uff09"));
        }
        return this.getExtendedField().setName(string);
    }

    public String getTypeName() {
        return this.getExtendedField().getTypeName();
    }

    public String getTypeDesc() throws WCMException {
        return this.getExtendedField().getTypeDesc();
    }

    public DataType getType() throws WCMException {
        return this.getExtendedField().getType();
    }

    public int getMaxLength() {
        return this.getExtendedField().getMaxLength();
    }

    public int getScale() {
        return this.getExtendedField().getScale();
    }

    public boolean isNullable() {
        return this.getExtendedField().isNullable();
    }

    public String getDefaultValue() {
        return this.getExtendedField().getDefaultValue();
    }

    public int getDefaultValueAsInt(int n) throws WCMException {
        return this.getExtendedField().getDefaultValueAsInt(n);
    }

    public boolean setType(String string, int n) throws WCMException {
        return this.setType(string, n, true, null);
    }

    public boolean setType(String string, int n, boolean bl, String string2) throws WCMException {
        return this.setType(string, n, bl, string2, 0);
    }

    public boolean setType(String string, int n, boolean bl, String string2, int n2) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(ContentExtField.class, "ContentExtField.label12", "\u5c5e\u6027Name\u4e0d\u5141\u8bb8\u4fee\u6539"));
        }
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(ContentExtField.class, "ContentExtField.label13", "\u6307\u5b9a\u5b57\u6bb5\u7c7b\u578b\u4e3a\u7a7a"));
        }
        if (n < 0) {
            throw new WCMException(10, I18NMessage.get(ContentExtField.class, "ContentExtField.label14", "\u6307\u5b9a\u6700\u5927\u957f\u5ea6\u5c0f\u4e8e0\uff1a") + n);
        }
        if (!bl && string2 == null) {
            throw new WCMException(10, I18NMessage.get(ContentExtField.class, "ContentExtField.label15", "\u975e\u7a7a\u5b57\u6bb5\u5fc5\u987b\u8bbe\u7f6e\u9ed8\u8ba4\u503c"));
        }
        DataType dataType = this.getDBManager().getDBType().getDataType(string);
        if (dataType == null) {
            throw new WCMException(10, I18NMessage.get(ContentExtField.class, "ContentExtField.label16", "\u65e0\u6548\u7684\u6570\u636e\u7c7b\u578b\uff1a") + string);
        }
        int n3 = dataType.getMaxLength();
        if (!dataType.isLengthDefinedByUser()) {
            n = n3;
        } else if (n > n3) {
            throw new WCMException(10, I18NMessage.get(ContentExtField.class, "ContentExtField.label17", "\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7") + n3);
        }
        return this.getExtendedField().setType(string, n, bl, string2, n2);
    }

    public String getAttribute() {
        return this.getExtendedField().getAttribute();
    }

    public boolean setAttribute(String string) throws WCMException {
        return this.getExtendedField().setAttribute(string);
    }

    public static final ContentExtField findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        ContentExtField contentExtField = (ContentExtField)BaseObj.findById(ContentExtField.class, n);
        if (contentExtField == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(1319922479)}));
        }
        return contentExtField;
    }

    public static final ContentExtField createNewInstance() {
        return new ContentExtField();
    }

    public static final ContentExtField findByKey(Object object) throws WCMException {
        ContentExtField contentExtField = (ContentExtField)BaseObj.findByKey(ContentExtField.class, object);
        return contentExtField;
    }

    public int getExtFieldId() {
        return this.getPropertyAsInt("EXTFIELDID", 0);
    }

    public CMSObj getHost() throws WCMException {
        int n = this.getObjId();
        switch (this.getObjType()) {
            case 103: {
                WebSite webSite = WebSite.findById(n);
                if (webSite == null) {
                    throw new WCMException(I18NMessage.get(ContentExtField.class, "ContentExtField.label18", "\u6307\u5b9a\u7684\u7ad9\u70b9[ID=") + n + I18NMessage.get(ContentExtField.class, "ContentExtField.label19", "]\u4e0d\u5b58\u5728\uff01"));
                }
                return webSite;
            }
            case 101: {
                Channel channel = Channel.findById(n);
                if (channel == null) {
                    throw new WCMException(I18NMessage.get(ContentExtField.class, "ContentExtField.label20", "\u6307\u5b9a\u7684\u680f\u76ee[ID=") + n + I18NMessage.get(ContentExtField.class, "ContentExtField.label19", "]\u4e0d\u5b58\u5728\uff01"));
                }
                return channel;
            }
            case 605: {
                int n2 = DBManager.getDBManager().sqlExecuteIntQuery("select DocChannel from WCMDocument where DocId=?", new int[]{n});
                Channel channel = Channel.findById(n2);
                if (channel == null) {
                    throw new WCMException(I18NMessage.get(ContentExtField.class, "ContentExtField.label21", "\u6307\u5b9a\u7684\u6587\u6863[ID=") + n + I18NMessage.get(ContentExtField.class, "ContentExtField.label22", "]\u7684\u6240\u5c5e\u9891\u9053\u4e0d\u5b58\u5728\uff01"));
                }
                return channel;
            }
            case 1: {
                return new WCMSystemObject(n);
            }
        }
        throw new WCMException(I18NMessage.get(ContentExtField.class, "ContentExtField.label23", "\u672a\u77e5\u5bf9\u8c61\u7c7b\u578b[ObjType=") + this.getObjType() + "]");
    }

    private boolean setExtFieldId(int n) throws WCMException {
        return this.setProperty("EXTFIELDID", n);
    }

    private ExtendedField getExtendedField() {
        if (this.m_extfield == null) {
            if (this.isAddMode()) {
                this.m_extfield = new ExtendedField();
            } else {
                try {
                    this.m_extfield = ExtendedField.findById(this.getExtFieldId());
                }
                catch (WCMException wCMException) {
                    throw new RuntimeException(wCMException);
                }
                if (this.m_extfield == null) {
                    throw new RuntimeException(I18NMessage.get(ContentExtField.class, "ContentExtField.label24", "\u7cfb\u7edf\u6570\u636e\u5f02\u5e38!"));
                }
            }
        }
        return this.m_extfield;
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(ContentExtField.class, "ContentExtField.label25", "[\u6269\u5c55\u5b57\u6bb5-") + this.getId() + "]";
    }

    public boolean setExtFieldProperty(String string, String string2) throws WCMException {
        return this.getExtendedField().setProperty(string, string2);
    }

    public String getExtFieldProperty(String string) throws WCMException {
        return this.getExtendedField().getPropertyAsString(string);
    }
}

