/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.IChildrenMgr;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyMemory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class ChildrenCacheMgr
implements IChildrenMgr {
    private static Logger logger = Logger.getLogger(ChildrenCacheMgr.class);
    private HashMap m_hChannelChildren = null;
    private HashMap m_hSiteChildren = null;

    public void clear() {
        if (this.m_hChannelChildren != null) {
            this.m_hChannelChildren.clear();
            this.m_hChannelChildren = null;
        }
        if (this.m_hSiteChildren != null) {
            this.m_hSiteChildren.clear();
            this.m_hSiteChildren = null;
        }
    }

    public List listChildren(User user, BaseChannel baseChannel, int n) throws WCMException {
        return this.listChildren(user, baseChannel, new int[]{n});
    }

    public final List listChildren(User user, BaseChannel baseChannel, int[] nArray) throws WCMException {
        List list = null;
        Channel channel = null;
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label1", "\u65e0\u6548\u7684\u7236\u9891\u9053/\u7ad9\u70b9[null]"));
        }
        if (nArray == null) {
            throw new WCMException(10, I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label2", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u7684\u5b50\u9891\u9053\u7c7b\u578b\uff01"));
        }
        ArrayList<Channel> arrayList = new ArrayList<Channel>();
        if (nArray.length == 0) {
            return arrayList;
        }
        list = this.getChildrenList(baseChannel);
        if (list == null) {
            return arrayList;
        }
        for (int i = 0; i < list.size(); ++i) {
            channel = (Channel)list.get(i);
            if (!this.isNeeded(channel, nArray)) continue;
            arrayList.add(channel);
        }
        return arrayList;
    }

    public int getChildrenSize(User user, BaseChannel baseChannel) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label1", "\u65e0\u6548\u7684\u7236\u9891\u9053/\u7ad9\u70b9[null]"));
        }
        List list = this.getChildrenList(baseChannel);
        return list == null ? 0 : list.size();
    }

    public Channel getChildAt(BaseChannel baseChannel, int n) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label1", "\u65e0\u6548\u7684\u7236\u9891\u9053/\u7ad9\u70b9[null]"));
        }
        List list = this.getChildrenList(baseChannel);
        if (list == null || list.size() <= n) {
            return null;
        }
        return (Channel)list.get(n);
    }

    public synchronized boolean init() throws WCMException {
        if (this.m_hChannelChildren != null) {
            return false;
        }
        logger.info((Object)I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label3", "\u5b50\u9891\u9053\u7f13\u51b2\u521d\u59cb\u5316\u5f00\u59cb..."));
        logger.info((Object)(I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label4", "\u5b50\u9891\u9053\u7f13\u51b2\u521d\u59cb\u5316\u524d\u5185\u5b58\u4f7f\u7528\u60c5\u51b5[") + CMyMemory.toMemoryInfo() + "]"));
        this.m_hChannelChildren = new HashMap();
        this.m_hSiteChildren = new HashMap();
        String string = "Status!=-1 and ChnlType in(1, 2)";
        WCMFilter wCMFilter = new WCMFilter("", string, " ChnlType desc ");
        this.loadChildren(wCMFilter);
        string = "Status=0 and ChnlType not in(1, 2)";
        WCMFilter wCMFilter2 = new WCMFilter("", string, " ChnlOrder desc ");
        this.loadChildren(wCMFilter2);
        logger.info((Object)I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label5", "\u5b50\u9891\u9053\u7f13\u51b2\u521d\u59cb\u5316\u5b8c\u6210\uff01"));
        logger.info((Object)(I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label6", "\u5b50\u9891\u9053\u7f13\u51b2\u521d\u59cb\u5316\u540e\u5185\u5b58\u4f7f\u7528\u60c5\u51b5[") + CMyMemory.toMemoryInfo() + "]"));
        return true;
    }

    private void loadChildren(WCMFilter wCMFilter) throws WCMException {
        Channels channels = Channels.openWCMObjs(User.getSystem(), wCMFilter);
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            int n2 = channel.getParentId();
            List<Channel> list = n2 == 0 ? (List)this.getSiteChildren().get(new Integer(channel.getSiteId())) : (ArrayList<Channel>)this.getChannelChildren().get(new Integer(n2));
            if (list == null) {
                list = new ArrayList<Channel>();
            }
            list.add(channel);
            if (n2 == 0) {
                this.getSiteChildren().put(new Integer(channel.getSiteId()), list);
                continue;
            }
            this.getChannelChildren().put(new Integer(n2), list);
        }
        channels.clear();
    }

    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (baseObj.getWCMType() != 101) {
            return;
        }
        Channel channel = (Channel)baseObj;
        this.reloadChildren(channel.getHost());
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof BaseChannel)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label7", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label8", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        BaseChannel baseChannel = (BaseChannel)baseObj;
        this.removeFromCache(baseChannel);
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        int n2;
        int n3;
        if (baseObj.getWCMType() != 101) {
            return;
        }
        Channel channel = (Channel)baseObj;
        int n4 = channel.getParentId();
        if (channel.isChangeProperty("SiteId")) {
            n3 = channel.isChangeProperty("ParentId");
            n2 = channel.getNewPropertyAsInt("PARENTID", 0);
            if (n4 == 0 && n3 != 0) {
                this.reloadChildren(channel.getSite());
                this.reloadChildren(WebSite.findById(channel.getNewPropertyAsInt("SITEID", 0)));
                return;
            }
            if (n3 != 0) {
                this.reloadChildren(this.getParent(channel));
                this.reloadChildren(Channel.findById(n2));
                return;
            }
        }
        if (channel.isChangeProperty("ParentId")) {
            this.reloadChildren(this.getParent(channel));
            n3 = channel.getNewPropertyAsInt("ParentId", 0);
            if (n3 == 0) {
                this.reloadChildren(channel.getSite());
            } else {
                this.reloadChildren(Channel.findById(n3));
            }
            return;
        }
        if (channel.isChangeProperty("ChnlOrder")) {
            this.reloadChildren(channel.getHost());
            return;
        }
        if (channel.isChangeProperty("Status")) {
            n3 = channel.getNewPropertyAsInt("Status", -2);
            if (n3 == -1) {
                this.removeChildFromCache(channel);
            } else if (n3 == 0) {
                this.reloadChildren(channel.getHost());
            }
            return;
        }
        if (channel.isChangeProperty("ChnlType")) {
            n3 = channel.getNewPropertyAsInt("ChnlType", 0);
            n2 = channel.getType();
            if (this.isSpecialType(n3) ^ this.isSpecialType(n2)) {
                this.reloadChildren(channel.getHost());
            }
            return;
        }
    }

    private boolean isSpecialType(int n) {
        return 2 == n || 1 == n;
    }

    protected HashMap getChannelChildren() throws WCMException {
        if (this.m_hChannelChildren == null) {
            this.init();
        }
        return this.m_hChannelChildren;
    }

    protected HashMap getSiteChildren() throws WCMException {
        if (this.m_hSiteChildren == null) {
            this.init();
        }
        return this.m_hSiteChildren;
    }

    private void reloadChildren(BaseChannel baseChannel) throws WCMException {
        List list = this.loadChildren(baseChannel);
        List list2 = this.getChildrenList(baseChannel);
        if (list2 != null) {
            list2.clear();
        }
        this.putChildrenList(baseChannel, list);
    }

    private List loadChildren(BaseChannel baseChannel) throws WCMException {
        WCMFilter wCMFilter = null;
        Channels channels = null;
        Channel channel = null;
        ArrayList<Channel> arrayList = new ArrayList<Channel>();
        channel = this.getChannelByType(2, baseChannel);
        if (channel != null) {
            arrayList.add(channel);
        }
        if ((channel = this.getChannelByType(1, baseChannel)) != null) {
            arrayList.add(channel);
        }
        String string = "Status!=-1";
        string = baseChannel.isSite() ? string + " and SiteId=" + baseChannel.getId() + " AND ParentId=0" : string + " and ParentId=" + baseChannel.getId();
        string = string + " and ChnlType not in(2, 1)";
        wCMFilter = new WCMFilter("", string, "ChnlOrder desc", "CHANNELID");
        channels = Channels.openWCMObjs(User.getSystem(), wCMFilter);
        for (int i = 0; i < channels.size(); ++i) {
            channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            arrayList.add(channel);
        }
        return arrayList;
    }

    private Channel getChannelByType(int n, BaseChannel baseChannel) throws WCMException {
        String string = "Status!=-1";
        string = baseChannel.isSite() ? string + " and SiteId=" + baseChannel.getId() + " and ParentId=0 and ChnlType=" + n : string + " and ParentId=" + baseChannel.getId() + " and ChnlType=" + n;
        WCMFilter wCMFilter = new WCMFilter("", string, "", "CHANNELID");
        wCMFilter.setMaxRowNumber(1);
        Channels channels = Channels.openWCMObjs(User.getSystem(), wCMFilter);
        if (channels.isEmpty()) {
            return null;
        }
        return (Channel)channels.getAt(0);
    }

    private boolean isNeeded(Channel channel, int[] nArray) {
        if (channel == null) {
            return false;
        }
        int n = channel.getType();
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (-1 != n2 && n != n2) continue;
            return true;
        }
        return false;
    }

    private List getChildrenList(BaseChannel baseChannel) throws WCMException {
        return this.getChildrenList(baseChannel.isSite() ? 0 : baseChannel.getId(), baseChannel.getSiteId());
    }

    private List getChildrenList(int n, int n2) throws WCMException {
        if (n == 0) {
            return (List)this.getSiteChildren().get(new Integer(n2));
        }
        return (List)this.getChannelChildren().get(new Integer(n));
    }

    private BaseChannel getParent(Channel channel) throws WCMException {
        if (channel.getParentId() == 0) {
            return channel.getSite();
        }
        return Channel.findById(channel.getParentId());
    }

    protected void addChildToCache(BaseChannel baseChannel, Object object) throws WCMException {
        ArrayList<Object> arrayList = this.getChildrenList(baseChannel);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        if (arrayList.indexOf(object) != -1) {
            return;
        }
        arrayList.add(object);
        this.putChildrenList(baseChannel, arrayList);
    }

    private void removeChildFromCache(Channel channel) throws WCMException {
        if (channel.isDeleted()) {
            return;
        }
        List list = this.getChildrenList(channel.getHost());
        if (list == null) {
            logger.error((Object)(I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label9", "\u5b50\u9891\u9053\u7f13\u51b2\u6709\u8bef\uff01") + channel + I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label10", "\u7684\u7236\u7f13\u51b2\u6ca1\u6709\uff01")));
            return;
        }
        list.remove(channel);
    }

    private void removeFromCache(BaseChannel baseChannel) throws WCMException {
        List list;
        if (!baseChannel.isSite()) {
            this.removeChildFromCache((Channel)baseChannel);
        }
        if ((list = this.getChildrenList(baseChannel)) != null) {
            list.clear();
        }
        if (baseChannel.isSite()) {
            this.getSiteChildren().remove(baseChannel.getKey());
        } else {
            this.getChannelChildren().remove(baseChannel.getKey());
        }
        list = null;
    }

    private void putChildrenList(BaseChannel baseChannel, List list) throws WCMException {
        if (baseChannel.isSite()) {
            this.getSiteChildren().put(baseChannel.getKey(), list);
        } else {
            this.getChannelChildren().put(baseChannel.getKey(), list);
        }
    }

    public int getSiblingIndex(BaseChannel baseChannel) throws WCMException {
        List list = this.getChildrenList(baseChannel.getParentId(), baseChannel.getSiteId());
        if (list == null) {
            return -1;
        }
        return list.indexOf(baseChannel);
    }
}

