/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.resource.Statuses;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class AutoBakConfig
extends CMSObj {
    public static final int OBJ_TYPE = 902;
    public static final String DB_TABLE_NAME = "WCMAUTOBAKCONFIG";
    public static final String DB_ID_NAME = "AUTOBAKCONFIGID";
    public static final int OPER_DOC_EDIT = 10;
    public static final int OPER_DOCSTATUS_CHANGE = 20;
    public static final int OPER_DOC_PUB = 30;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 902;
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("SITEID") == null) {
                throw new WCMException(1106, I18NMessage.get(AutoBakConfig.class, "AutoBakConfig.label1", "\u5c5e\u6027SITEID\u6ca1\u6709\u8bbe\u7f6e\uff01"));
            }
            WebSite webSite = WebSite.findById(this.getSiteId());
            if (webSite == null) {
                throw new WCMException(200006, I18NMessage.get(AutoBakConfig.class, "AutoBakConfig.label2", "\u5c5e\u6027SITEID\u65e0\u6548\uff01\u6ca1\u6709\u627e\u5230\u76f8\u5bf9\u5e94\u7684\u7ad9\u70b9\uff01"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(AutoBakConfig.class, "AutoBakConfig.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539\uff01"));
        }
        return true;
    }

    public int getSiteId() {
        return this.getPropertyAsInt("SITEID", 0);
    }

    public WebSite getSite() throws WCMException {
        return WebSite.findById(this.getSiteId());
    }

    public String getOperTypes() {
        return this.getPropertyAsString("OPERTYPE");
    }

    public Statuses getCanSavedDocStatus(User user) throws WCMException {
        return Statuses.findByIds(user, this.getCanSavedDocStatusIds());
    }

    public String getCanSavedDocStatusIds() {
        return this.getPropertyAsString("DOCSTATUSES");
    }

    public boolean setSiteId(int n) throws WCMException {
        return this.setProperty("SITEID", n);
    }

    public boolean setOperType(String string) throws WCMException {
        return this.setProperty("OPERTYPE", string);
    }

    public boolean setCanSavedDocStatus(String string) throws WCMException {
        return this.setProperty("DOCSTATUSES", string);
    }

    public static final AutoBakConfig findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (AutoBakConfig)BaseObj.findById(AutoBakConfig.class, n);
    }

    public static final AutoBakConfig createNewInstance() throws WCMException {
        return (AutoBakConfig)BaseObj.createNewInstance(AutoBakConfig.class);
    }

    public static final AutoBakConfig findByKey(Object object) throws WCMException {
        return (AutoBakConfig)BaseObj.findByKey(AutoBakConfig.class, object);
    }
}

