/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.content.HTMLContent;
import com.trs.components.wcm.content.domain.DocumentLCListenerForRelDocs;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import org.apache.log4j.Logger;

public class DocumentLCListenerForDocForm
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(DocumentLCListenerForRelDocs.class);

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (!(baseObj instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForDocForm.class, "DocumentLCListenerForDocForm.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(DocumentLCListenerForDocForm.class, "DocumentLCListenerForDocForm.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        Document document = (Document)baseObj;
        int n = document.getPropertyAsInt("DOCFORM", 0);
        if (n == 0) {
            n = this.resetDocForm4Add(document);
            document.refreshProperty("DOCFORM", n);
            this.updateSQL(n, document.getId());
        }
    }

    private int resetDocForm4Add(Document document) throws WCMException {
        int n = this.getDocFormBySite(document);
        if (n != 0) {
            return n;
        }
        int n2 = document.getType();
        if (n2 == 40) {
            String string = document.getPropertyAsString("DOCFILENAME");
            n = this.analyzeExt(string);
        } else if (n2 == 20) {
            String string = document.getHtmlContent();
            n = this.analyzeDocForm(string);
        } else {
            n = 1;
        }
        return n;
    }

    private int getDocFormBySite(Document document) throws WCMException {
        int n = 0;
        Channel channel = document.getChannel();
        if (channel == null) {
            return n;
        }
        WebSite webSite = channel.getSite();
        if (webSite == null) {
            return n;
        }
        int n2 = webSite.getType();
        switch (n2) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
        }
        return n;
    }

    private void updateSQL(int n, int n2) throws WCMException {
        String[] stringArray = new String[]{"UPDATE WCMCHNLDOC SET DocForm=" + n + " WHERE DocId=" + n2, "UPDATE WCMDOCUMENT SET DocForm=" + n + " WHERE DocId=" + n2};
        DBManager.getDBManager().sqlExecuteUpdate(stringArray);
    }

    private int analyzeExt(String string) {
        if (CMyString.isEmpty(string)) {
            return 1;
        }
        String string2 = "jpg,jpeg,gif,png,bmp";
        String string3 = "wav,mid,midi,mp3,mpa,mp2,ra,ram,rm,wma";
        String string4 = "asf,avi,mpg,mpeg,mpe,mov,rm,rmvb,wmv,swf,flv,mp4,f4v";
        String[] stringArray = new String[]{string2, string3, string4};
        int[] nArray = new int[]{2, 3, 4};
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].split(",").length; ++j) {
                if (string.indexOf("." + stringArray[i].split(",")[j]) < 0) continue;
                return nArray[i];
            }
        }
        return 1;
    }

    private int analyzeDocForm(String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return 1;
        }
        HtmlElementFinder htmlElementFinder = null;
        HtmlElement htmlElement = null;
        try {
            String string2;
            htmlElementFinder = new HtmlElementFinder(string);
            htmlElement = htmlElementFinder.findNextElement("EMBED", false);
            if (htmlElement != null && !CMyString.isEmpty(string2 = htmlElement.getAttributeValue("src"))) {
                return this.analyzeExt(string2);
            }
            htmlElementFinder.setPosition(0);
            htmlElement = htmlElementFinder.findNextElement("script", false);
            if (htmlElement != null && !CMyString.isEmpty(string2 = htmlElement.getAttributeValue("src")) && string2.toLowerCase().indexOf("swfobject.js") >= 0) {
                return 4;
            }
            htmlElementFinder.setPosition(0);
            htmlElement = htmlElementFinder.findNextElement("IMG", false);
            if (htmlElement != null) {
                return 2;
            }
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(HTMLContent.class, "HTMLContent.label112", "\u89e3\u6790\u6587\u6863\u6240\u5c5e\u5173\u7cfb\u53d1\u751f\u9519\u8bef!"), exception);
        }
        return 1;
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForDocForm.class, "DocumentLCListenerForDocForm.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(DocumentLCListenerForDocForm.class, "DocumentLCListenerForDocForm.label3", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        if (baseObj.isChangeProperty("DOCFORM")) {
            int n2 = baseObj.getNewPropertyAsInt("DOCFORM", 0);
            if (n2 != 0) {
                return;
            }
            Document document = (Document)baseObj;
            n2 = this.resetDocForm4Mod(document);
            document.refreshProperty("DOCFORM", n2);
            this.updateSQL(n2, document.getId());
        }
    }

    private int resetDocForm4Mod(Document document) throws WCMException {
        int n = this.getDocFormBySite(document);
        if (n != 0) {
            return n;
        }
        int n2 = document.getNewPropertyAsInt("DOCTYPE", 0);
        if (n2 == 40) {
            String string = document.getNewPropertyAsString("DOCFILENAME");
            n = this.analyzeExt(string);
        } else if (n2 == 20) {
            String string = document.getNewPropertyAsString("DOCHTMLCON");
            n = this.analyzeDocForm(string);
        } else {
            n = 1;
        }
        return n;
    }
}

