/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.eprobiti.trs.TRSConnection;
import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.IDocKeywordMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.trsserver.DocsFromTRSServer;
import com.trs.components.wcm.content.trsserver.TRSToWCMFilter;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DocKeywordMgrImpl
implements IDocKeywordMgr {
    private static Logger logger = Logger.getLogger(DocKeywordMgrImpl.class);
    private static final String sInsertSQL = "insert into WCMDOCKEYWORD(DocId, DOCCRTIME, DOCKEYWORD, DOCKEYWORDORDER,SITEID)values(?, ?, ?, ?,?)";
    public static boolean GET_FROM_TRSSERVER = false;

    public void addNewDocKeywords(Document document) throws WCMException {
        if (GET_FROM_TRSSERVER) {
            return;
        }
        if (document == null) {
            return;
        }
        String string = document.getKeywords();
        this.putKeywords(document, string);
    }

    private void putKeywords(Document document, String string) throws WCMException {
        if (string == null || (string = string.trim()).length() <= 0) {
            return;
        }
        DBManager dBManager = DBManager.getDBManager();
        Channel channel = document.getChannel();
        int n = 0;
        if (channel != null) {
            n = channel.getSiteId();
        }
        Integer n2 = new Integer(n);
        Object[] objectArray = new Object[5];
        objectArray[0] = document.getKey();
        objectArray[1] = document.getCrTime().toTimestamp();
        String[] stringArray = CMyString.split(string, ";");
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[2] = stringArray[i].trim();
            objectArray[3] = new Integer(i + 1);
            objectArray[4] = n2;
            dBManager.sqlExecuteUpdate(new String[]{sInsertSQL}, objectArray);
        }
    }

    public void updateDocKeywords(Document document, String string, String string2) throws WCMException {
        if (GET_FROM_TRSSERVER) {
            return;
        }
        if (string == null) {
            if (string2 == null) {
                return;
            }
        } else {
            if (string.equals(string2)) {
                return;
            }
            if (string.length() > 0) {
                this.removeDocKeywords(document);
            }
        }
        this.putKeywords(document, string2);
    }

    public void removeDocKeywords(Document document) throws WCMException {
        if (GET_FROM_TRSSERVER) {
            return;
        }
        DBManager dBManager = DBManager.getDBManager();
        dBManager.sqlExecuteUpdate(new String[]{"delete from WCMDOCKEYWORD where DocId=?"}, new int[]{document.getId()});
    }

    public Documents getRelatedDocumentsByKeywords(Document document, int n, String string, int[] nArray, boolean bl, ArrayList arrayList) throws WCMException {
        Cloneable cloneable;
        ArrayList<String> arrayList2;
        if (GET_FROM_TRSSERVER) {
            WCMFilter wCMFilter = new WCMFilter();
            wCMFilter.setSelect(string);
            wCMFilter.setPageSize(n);
            return this.getAllRelatedDocumentsByKeywordsFromTRSServer(document.getKeywords(), wCMFilter, 1);
        }
        User user = User.getSystem();
        Documents documents = new Documents(user);
        int n2 = n;
        if (n2 <= 0) {
            n2 = 100;
        }
        if ((arrayList2 = arrayList) == null) {
            arrayList2 = new ArrayList<String>(n2);
        }
        arrayList2.add(document.getTitle().trim());
        String string2 = document.getKeywords();
        if (string2 == null || (string2 = string2.trim()).length() <= 0) {
            return documents;
        }
        StringBuffer stringBuffer = new StringBuffer("DocId<>? AND DocKeyword=?");
        if (!bl && (cloneable = document.getChannel()) != null) {
            stringBuffer.append(" AND SiteId=").append(((Channel)cloneable).getSiteId());
        }
        if (string != null) {
            string = string.replaceAll("WCMDocument.DOCID", "DOCID");
        }
        cloneable = new WCMFilter("WCMDocKeyword", "/*+index WCMDOCKEYWORD_IX_KEY_DOCID*/ " + stringBuffer.toString(), "DocKeywordOrder, DocCrTime desc", string);
        ((WCMFilter)cloneable).addSearchValues(0, document.getId());
        ((WCMFilter)cloneable).setMaxRowNumber(n2 + 30);
        String[] stringArray = CMyString.split(string2, ";");
        for (int i = 0; i < stringArray.length; ++i) {
            ((WCMFilter)cloneable).addSearchValues(1, stringArray[i]);
            DebugTimer debugTimer = new DebugTimer();
            debugTimer.start();
            Documents documents2 = Documents.openWCMObjs(user, (WCMFilter)cloneable);
            debugTimer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("query reldocuments of [DocId=" + document.getId() + "] by keyword[" + stringArray[i] + "] Info:"));
                logger.debug((Object)("use [" + debugTimer.getTime() + "]ms!"));
                logger.debug((Object)("size=[" + documents2.size() + "]!"));
                logger.debug((Object)cloneable);
            }
            debugTimer.start();
            int n3 = documents2.size();
            documents2.setPageSize(n3);
            documents2.setMaxBufferSize(n3);
            for (int j = n3 - 1; j >= 0; --j) {
                Document document2 = (Document)documents2.getAt(j);
                if (document2 == null || !this.isInRange(document2.getStatusId(), nArray) || document2.getPropertyAsInt("DocChannel", 0) <= 0) {
                    documents2.removeAt(j, false);
                    continue;
                }
                String string3 = document2.getTitle().trim();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(j + ":" + string3));
                }
                if (arrayList2.contains(string3)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"already exists!");
                    }
                    documents2.removeAt(j, false);
                    continue;
                }
                arrayList2.add(string3);
            }
            debugTimer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("filter reldocuments by keyword[" + stringArray[i] + "] Info:"));
                logger.debug((Object)("use [" + debugTimer.getTime() + "]ms!"));
            }
            if (documents2.isEmpty()) continue;
            documents.setMaxBufferSize(documents.size() + documents2.size());
            documents.addWith(documents2);
            if (documents.size() >= n2) break;
        }
        return documents;
    }

    public Documents getAllRelatedDocumentsByKeywords(String string, int n, WCMFilter wCMFilter) throws WCMException {
        if (GET_FROM_TRSSERVER) {
            return this.getAllRelatedDocumentsByKeywordsFromTRSServer(string, wCMFilter, 1);
        }
        User user = User.getSystem();
        Documents documents = new Documents(user);
        String string2 = string;
        if (string2 == null || (string2 = string2.trim()).length() <= 0) {
            return documents;
        }
        String[] stringArray = CMyString.split(string2, ";");
        WCMFilter wCMFilter2 = new WCMFilter("", "", "DOCID desc");
        wCMFilter2.addSearchValues(0, n);
        StringBuffer stringBuffer = new StringBuffer(10 + stringArray.length * 42);
        stringBuffer.append("WCMDocKeyword.DOCID<>?");
        stringBuffer.append(" AND (WCMDocKeyword.DOCKEYWORD=?");
        int n2 = 1;
        wCMFilter2.addSearchValues(n2, stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
            if (stringArray[i].length() <= 0) continue;
            stringBuffer.append(" OR WCMDocKeyword.DOCKEYWORD=?");
            wCMFilter2.addSearchValues(++n2, stringArray[i]);
        }
        stringBuffer.append(")");
        String string3 = "DocChannel>0 and DocStatus>=0 and exists(select DocId from WCMDocKeyword where WCMDocument.DOCID=WCMDocKeyword.DOCID and " + stringBuffer.toString() + ")";
        wCMFilter2.setWhere(string3);
        wCMFilter2.mergeWith(wCMFilter);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"=====The filter of get reldocuments======");
            logger.debug((Object)wCMFilter2);
        }
        return Documents.openWCMObjs(user, wCMFilter2);
    }

    public Documents getAllRelatedDocumentsByKeywordsFromTRSServer(String string, WCMFilter wCMFilter, int n) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return new Documents(null);
        }
        int n2 = wCMFilter.getPageSize();
        if (n2 <= 0) {
            n2 = 20;
        }
        int n3 = n;
        TRSConnection.setCharset((int)3, (boolean)false);
        DocsFromTRSServer docsFromTRSServer = (DocsFromTRSServer)DreamFactory.createObjectById("DocsFromTRSServer");
        TRSToWCMFilter tRSToWCMFilter = new TRSToWCMFilter();
        tRSToWCMFilter.setIDFieldName(DocsFromTRSServer.getTRSDocIdDBName());
        String string2 = null;
        String string3 = wCMFilter.getSelect();
        if (CMyString.isEmpty(string3)) {
            string3 = "docid,doctitle,docchannel,docauthor,crtime,cruser,docstatus,doctype,dockeywords,docsource,docreltime,docpuburl";
            string2 = DocsFromTRSServer.getTRSDocIdDBName() + ",doctitle,docchannel,docauthor," + "crtime,cruser,docstatus,doctype,dockeywords,docsource," + "docreltime,docpuburl";
        } else {
            string2 = CMyString.replaceStr(string3.toUpperCase(), "DOCID", DocsFromTRSServer.getTRSDocIdDBName());
        }
        tRSToWCMFilter.setTRSFrom(DocsFromTRSServer.getTRSDocDBName());
        tRSToWCMFilter.setSelect(string3, string2);
        string = string.replaceAll("[,\uff1b\uff0c\\s]", ";");
        String[] stringArray = string.split(";");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (CMyString.isEmpty(stringArray[i])) continue;
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" or ");
        }
        stringBuffer.setLength(stringBuffer.length() - 4);
        tRSToWCMFilter.setTRSWhere(stringBuffer.toString());
        tRSToWCMFilter.setDefaultCols("DocKeywords");
        tRSToWCMFilter.setTRSOrder("-publishdate");
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        Documents documents = docsFromTRSServer.openDocs(null, tRSToWCMFilter, n3, n2);
        debugTimer.stop();
        logger.debug((Object)("documents.size():" + documents.size() + " use [" + debugTimer.getTime() + "]ms!"));
        return documents;
    }

    private boolean isInRange(int n, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return true;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }
}

