/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.DocBak;
import com.trs.components.wcm.content.persistent.DocBaks;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.database.TableInfo;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class DocBakMgr {
    private static Logger m_oLogger = Logger.getLogger((String)DocBakMgr.class.getName());

    public DocBaks findDocBaks(Document document) throws WCMException {
        return this.findDocBaks(document, null);
    }

    public DocBaks findDocBaks(Document document, WCMFilter wCMFilter) throws WCMException {
        if (document == null) {
            throw new WCMException(20, I18NMessage.get(DocBakMgr.class, "DocBakMgr.label1", "\u5f53\u524d\u6587\u6863\u4e3a\u7a7a,\u65e0\u6cd5\u53d6\u5f97\u5176\u5907\u4efd"));
        }
        String string = "DocId=" + document.getDocId();
        WCMFilter wCMFilter2 = new WCMFilter("", string, "DOCVERSION");
        wCMFilter2.mergeWith(wCMFilter);
        try {
            return DocBaks.openWCMObjs(this.getLoginUser(), wCMFilter2);
        }
        catch (Exception exception) {
            m_oLogger.debug((Object)exception.getMessage());
            throw new WCMException(1100, I18NMessage.get(DocBakMgr.class, "DocBakMgr.label2", "\u6253\u5f00\u6587\u6863\u5907\u4efd\u96c6\u5408\u5931\u8d25!"), exception);
        }
    }

    public DocBak getDocBak(Document document, int n) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "DocVersion=" + n, "");
        DocBaks docBaks = this.findDocBaks(document, wCMFilter);
        if (docBaks == null || docBaks.isEmpty()) {
            return null;
        }
        return (DocBak)docBaks.getAt(0);
    }

    public synchronized DocBak bakupDocument(Document document) throws WCMException {
        if (document == null || !document.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(DocBakMgr.class, "DocBakMgr.label3", "\u5f53\u524d\u6587\u6863\u65e0\u6548,\u65e0\u6cd5\u5907\u4efd\u8be5\u6587\u6863!"));
        }
        int n = this.getNewDocVersion(document);
        DocBak docBak = this.getDocBak(document, n);
        if (docBak != null) {
            this.deleteDocBak(docBak);
        }
        DocBak docBak2 = this.saveDocBak(document);
        if (!document.isAddMode() && document.isModified()) {
            document.setVersion(n);
        } else {
            Document document2 = Document.findById(document.getId());
            if (document2 != null) {
                document2.setVersion(n);
                document2.update();
            }
        }
        return docBak2;
    }

    private int getNewDocVersion(Document document) throws WCMException {
        int n = document.getVersion() + 1;
        if (n >= 59) {
            WCMFilter wCMFilter = new WCMFilter("", "", "BakTime", "DocId,DocVersion", 1);
            DocBaks docBaks = this.findDocBaks(document, wCMFilter);
            if (docBaks.isEmpty()) {
                n = 0;
            } else {
                DocBak docBak = (DocBak)docBaks.getAt(0);
                if (docBak == null) {
                    n = 0;
                } else {
                    n = docBak.getVersion();
                    this.deleteDocBak(docBak);
                }
            }
        }
        return n;
    }

    public void deleteDocBak(DocBak docBak) throws WCMException {
        if (docBak == null) {
            throw new WCMException(10, I18NMessage.get(DocBakMgr.class, "DocBakMgr.label4", "\u6587\u6863\u5907\u4efd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        docBak.delete(this.getLoginUser());
    }

    private DocBak saveDocBak(Document document) throws WCMException {
        User user = this.getLoginUser();
        DocBak docBak = new DocBak();
        docBak.canEdit(user);
        docBak.setProperties(document.getAllProperty());
        docBak.removeProperty("DOCFROMVERSION");
        docBak.setBakUser(user);
        docBak.insert(user);
        return docBak;
    }

    public Document recoverDocument(DocBak docBak, Document document) throws WCMException {
        if (document == null || !document.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(DocBakMgr.class, "DocBakMgr.label5", "\u5f53\u524d\u6587\u6863\u65e0\u6548,\u65e0\u6cd5\u6062\u590d"));
        }
        if (docBak == null || !docBak.isValidInstance() || docBak.getDocId() != document.getId()) {
            throw new WCMException(10, I18NMessage.get(DocBakMgr.class, "DocBakMgr.label6", "\u6307\u5b9a\u6587\u6863\u5907\u4efd\u5bf9\u8c61\u65e0\u6548"));
        }
        if (!document.canEdit(this.getLoginUser())) {
            throw new WCMException(1013, I18NMessage.get(DocBakMgr.class, "DocBakMgr.label7", "\u9501\u5b9a\u5bf9\u8c61\u5931\u8d25,\u5f53\u524d\u6587\u6863\u53ef\u80fd\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u9501\u5b9a!"));
        }
        try {
            int n = document.getChannelId();
            document = this.recoverDataFromBak(docBak, document);
            document.setFromVersion(docBak.getVersion());
            document.setChannel(n);
        }
        catch (Exception exception) {
            document.unlock();
            throw new WCMException(1100, I18NMessage.get(DocBakMgr.class, "DocBakMgr.label8", "\u4ece\u5907\u4efd\u4e2d\u6062\u590d\u6570\u636e\u5931\u8d25"), exception);
        }
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        document = documentMgr.save(document);
        return document;
    }

    private Document recoverDataFromBak(DocBak docBak, Document document) throws WCMException {
        DocBak docBak2 = (DocBak)docBak.cloneToNewWCMObj();
        DBManager dBManager = DBManager.getDBManager();
        if (dBManager.getDBTypeAsInt() == 1) {
            Hashtable hashtable = docBak2.getAllProperty();
            TableInfo tableInfo = dBManager.getTableInfo("WCMDOCUMENT");
            Enumeration enumeration = tableInfo.getFieldNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if ("DOCID".equals(string) || "CRTIME".equals(string) || hashtable.containsKey(string)) continue;
                hashtable.put(string, new NullValue(tableInfo.getFieldInfo(string).getDataType().getType()));
            }
        }
        docBak2.removeProperty("BAKTIME");
        docBak2.removeProperty("BAKUSER");
        docBak2.removeProperty("DOCVERSION");
        docBak2.removeProperty("DOCSTATUS");
        document.setNewProperties(docBak2.getAllProperty());
        return document;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

