/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.job.BaseStatefulScheduleWorker;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.RelationMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChannelSyn;
import com.trs.components.wcm.content.persistent.ChannelSyns;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.DocumentSyn;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class ChnlSynWorker
extends BaseStatefulScheduleWorker {
    private static Logger s_logger = Logger.getLogger(ChnlSynWorker.class);
    public static boolean NEW_MODE = false;
    public static boolean STOP_MODE = true;
    private static DocumentMgr currDocumentMgr = null;

    private void assertNotNull(BaseObj baseObj) throws WCMException {
        if (baseObj == null) {
            throw new WCMException(10, I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label1", "\u65e0\u6548\u7684\u5bf9\u8c61[null],\u65e0\u6cd5\u5b8c\u6210\u64cd\u4f5c!"));
        }
    }

    private DocumentMgr getDocumentMgr() {
        if (currDocumentMgr != null) {
            return currDocumentMgr;
        }
        currDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return currDocumentMgr;
    }

    private ChannelSyns getChannelSyns() throws WCMException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SDATE<=");
        stringBuffer.append(this.getDBManager().getDBType().sqlDateTime(CMyDateTime.now().toString("yyyy-MM-dd") + " 23:59:59", "YYYY-MM-DD HH24:MI:SS"));
        stringBuffer.append(" AND EDATE>=");
        stringBuffer.append(this.getDBManager().getDBType().sqlDateTime(CMyDateTime.now().toString("yyyy-MM-dd") + " 00:00:00", "YYYY-MM-DD HH24:MI:SS"));
        WCMFilter wCMFilter = new WCMFilter("", stringBuffer.toString(), "CHANNELSYNID DESC");
        return ChannelSyns.openWCMObjs(User.getSystem(), wCMFilter);
    }

    private Documents getDocuments(ChannelSyn channelSyn) throws WCMException {
        boolean bl;
        this.assertNotNull(channelSyn);
        Channel channel = channelSyn.getSrcChannel();
        if (channel == null) {
            return new Documents(User.getSystem());
        }
        String string = channelSyn.getStatusIds();
        String string2 = channelSyn.getWhereSql();
        if (!CMyString.isEmpty(string2)) {
            if (string2.toUpperCase().indexOf("WCMCHNLDOC") != -1) {
                s_logger.warn((Object)("Unsupported extra include wcmchnldoc: " + string2));
            }
            return null;
        }
        CMyDateTime cMyDateTime = channelSyn.getDocStartTime();
        CMyDateTime cMyDateTime2 = channelSyn.getDocEndTime();
        try {
            cMyDateTime2.setTimeWithString("23:59:59", 0);
        }
        catch (CMyException cMyException) {
            s_logger.error((Object)"failed to auto transmit documents caused by:\n", (Throwable)cMyException);
        }
        String string3 = "DocChannel=? and CrTime>=? and CrTime<=?";
        boolean bl2 = bl = this.getDBManager().getFieldInfo("WCMDOCUMENT", "DOCPARENTID") != null;
        if (bl) {
            string3 = string3 + "  and DOCPARENTID<=0";
        }
        if (string != null && string.trim().length() > 0) {
            string3 = string3 + " AND DOCSTATUS IN (" + string + ")";
        }
        if (string2 != null && string2.trim().length() > 0) {
            string3 = string3 + " AND (" + string2 + ")";
        }
        string3 = string3 + " and not exists(select 1 from WCMDOCSYN where WCMDOCSYN.ChnlId=? and WCMDOCSYN.DocId=WCMDocument.DocId)";
        WCMFilter wCMFilter = new WCMFilter("", string3, "DocId asc");
        wCMFilter.addSearchValues(0, channelSyn.getSrcChannelId());
        wCMFilter.addSearchValues(1, cMyDateTime);
        wCMFilter.addSearchValues(2, cMyDateTime2);
        wCMFilter.addSearchValues(3, channelSyn.getToChannelId());
        int n = 200;
        wCMFilter.setMaxRowNumber(n);
        wCMFilter.setPageSize(n);
        Documents documents = new Documents(null);
        documents.setMaxBufferSize(n);
        documents.setMaxSize(n);
        documents.open(wCMFilter);
        return documents;
    }

    protected void execute() {
        try {
            if (!STOP_MODE) {
                this.autoTransmit();
            }
        }
        catch (Exception exception) {
            s_logger.error((Object)I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label2", "\u81ea\u52a8\u5206\u53d1\u4efb\u52a1\u6267\u884c\u5931\u8d25!"), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transmitDocument(ChannelSyn channelSyn) throws WCMException {
        if (channelSyn == null) {
            return;
        }
        Channel channel = channelSyn.getToChannel();
        Documents documents = this.getDocuments(channelSyn);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("docsyn:from[" + channelSyn.getSrcChannel() + "] to [" + channel + "],docs=" + documents.size()));
        }
        if (channel == null || documents == null || documents.isEmpty()) {
            return;
        }
        int n = channelSyn.getTransmitType();
        switch (n) {
            case 1: {
                Channel channel2 = channelSyn.getSrcChannel();
                if (channel2 == null) break;
                this.syncCopy(documents, channel2, channel);
                break;
            }
            case 2: {
                this.syncQuote(documents, channel);
                break;
            }
            case 3: {
                this.syncMirror(documents, channel);
                break;
            }
            default: {
                s_logger.error((Object)("auto transmit documents failed,caused by invalid transmit type[" + n + "]!"));
            }
        }
        try {
            this.recordTransmited(channel.getId(), documents.getIdListAsString());
            Object var7_6 = null;
            documents.clear();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            documents.clear();
            throw throwable;
        }
    }

    private void syncCopy(Documents documents, Channel channel, Channel channel2) throws WCMException {
        DocumentMgr documentMgr = this.getDocumentMgr();
        AppendixMgr appendixMgr = this.getAppendixManager();
        RelationMgr relationMgr = this.getRelationManager();
        Document document = null;
        if (channel2.getType() == 0 || channel2.getType() == 13) {
            int n;
            Document document2 = null;
            int[] nArray = new int[documents.size()];
            int n2 = documents.size();
            for (n = 0; n < n2; ++n) {
                document2 = (Document)documents.getAt(n);
                if (document2 == null) continue;
                try {
                    document = documentMgr.copyDocument(document2, channel, channel2);
                    if (document == null || document.getId() == document2.getId()) continue;
                    appendixMgr.copyAppendixes(document2, document);
                    relationMgr.copyRelations(document2, document);
                    continue;
                }
                catch (WCMException wCMException) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)"syncopy failed", (Throwable)wCMException);
                    }
                    nArray[n] = document2.getId();
                }
            }
            Arrays.sort(nArray);
            n = 0;
            for (int i = n2 = nArray.length - 1; i >= 0 && n == 0; --i) {
                documents.remove(nArray[i], false);
                n = nArray[i] == 0 ? 1 : 0;
            }
        } else {
            this.syncQuote(documents, channel2);
        }
    }

    private RelationMgr getRelationManager() {
        return (RelationMgr)DreamFactory.createObjectById("RelationMgr");
    }

    private AppendixMgr getAppendixManager() {
        return (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    }

    private void syncQuote(Documents documents, Channel channel) throws WCMException {
        DocumentMgr documentMgr = this.getDocumentMgr();
        Document document = null;
        int n = documents.size();
        for (int i = 0; i < n; ++i) {
            document = (Document)documents.getAt(i);
            if (document == null) continue;
            documentMgr.quoteTo(document, channel);
        }
    }

    private void syncMirror(Documents documents, Channel channel) throws WCMException {
        DocumentMgr documentMgr = this.getDocumentMgr();
        Document document = null;
        int n = documents.size();
        for (int i = 0; i < n; ++i) {
            document = (Document)documents.getAt(i);
            if (document == null) continue;
            documentMgr.mirrorTo(document, channel);
        }
    }

    private void recordTransmited(int n, String string) throws WCMException {
        int[] nArray = CMyString.splitToInt(string, ",");
        DocumentSyn documentSyn = null;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            documentSyn = new DocumentSyn();
            documentSyn.setChannelId(n);
            documentSyn.setDocumentId(nArray[i]);
            documentSyn.insert();
        }
    }

    private void autoTransmit() throws WCMException {
        ChannelSyns channelSyns;
        ContextHelper.initContext(User.getSystem());
        if (NEW_MODE) {
            this.transmitDocumentForTriggerMode();
        }
        if ((channelSyns = this.getChannelSyns()).isEmpty()) {
            return;
        }
        ChannelSyn channelSyn = null;
        int n = channelSyns.size();
        for (int i = 0; i < n; ++i) {
            channelSyn = (ChannelSyn)channelSyns.getAt(i);
            if (channelSyn == null) continue;
            try {
                this.transmitDocument(channelSyn);
                continue;
            }
            catch (Exception exception) {
                s_logger.error((Object)("failed to trsansmit documents from[" + channelSyn.getSrcChannel() + "] to [" + channelSyn.getToChannel() + "]!"), (Throwable)exception);
            }
        }
        channelSyns.clear();
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager dBManager = DBManager.getDBManager();
        if (dBManager == null || !dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label3", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label4", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return dBManager;
    }

    /*
     * Loose catch block
     */
    private void transmitDocumentForTriggerMode() throws WCMException {
        block35: {
            Exception exception2222;
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block33: {
                connection = null;
                statement = null;
                resultSet = null;
                String string = "select recid,srcchnlid,tochnlid,docid,modal from wcmchnldocsynbak order by recid asc";
                String string2 = "delete from wcmchnldocsynbak where recid=?";
                String[] stringArray = new String[]{string2};
                connection = DBManager.getDBManager().getConnection();
                statement = connection.prepareStatement(string);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    int n = resultSet.getInt("recid");
                    int n2 = resultSet.getInt("tochnlid");
                    int n3 = resultSet.getInt("srcchnlid");
                    int n4 = resultSet.getInt("docid");
                    int n5 = resultSet.getInt("modal");
                    Document document = Document.findById(n4);
                    if (document == null) {
                        DBManager.getDBManager().sqlExecuteUpdate(stringArray, new int[]{n});
                        throw new WCMException(0, I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label5", "\u5229\u7528\u89e6\u53d1\u5668\u7684\u4e2d\u95f4\u7ed3\u679c\u8fdb\u884c\u81ea\u52a8\u5206\u53d1\u5931\u8d25currDocument[") + n4 + "] is null");
                    }
                    Channel channel = Channel.findById(n3);
                    if (channel == null) {
                        DBManager.getDBManager().sqlExecuteUpdate(stringArray, new int[]{n});
                        throw new WCMException(0, I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label6", "\u5229\u7528\u89e6\u53d1\u5668\u7684\u4e2d\u95f4\u7ed3\u679c\u8fdb\u884c\u81ea\u52a8\u5206\u53d1\u5931\u8d25srcChannel[") + n3 + "] is null");
                    }
                    Channel channel2 = Channel.findById(n2);
                    if (channel2 == null) {
                        DBManager.getDBManager().sqlExecuteUpdate(stringArray, new int[]{n});
                        throw new WCMException(0, I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label7", "\u5229\u7528\u89e6\u53d1\u5668\u7684\u4e2d\u95f4\u7ed3\u679c\u8fdb\u884c\u81ea\u52a8\u5206\u53d1\u5931\u8d25toChannel[") + n2 + "] is null");
                    }
                    Report report = null;
                    DocumentMgr documentMgr = this.getDocumentMgr();
                    switch (n5) {
                        case 1: {
                            this.synCopy(channel, channel2, document);
                            break;
                        }
                        case 2: {
                            report = documentMgr.quoteTo(document, channel2);
                            break;
                        }
                        case 3: {
                            report = documentMgr.mirrorTo(document, channel2);
                            break;
                        }
                        default: {
                            s_logger.error((Object)("auto transmit document failed,caused by invalid transmit type[" + n5 + "]!"));
                        }
                    }
                    if (report != null) {
                        switch (report.getType()) {
                            case 5: {
                                s_logger.error((Object)(I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label8", "\u5206\u53d1\u6587\u6863[") + document + I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label9", "]\u5230[") + channel2 + I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label10", "]\u7684\u65f6\u5019\u5b58\u5728\u9519\u8bef\uff01\n") + report));
                                break;
                            }
                            case 4: {
                                s_logger.error((Object)(I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label8", "\u5206\u53d1\u6587\u6863[") + document + I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label9", "]\u5230[") + channel2 + I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label11", "]\u7684\u65f6\u5019\u5b58\u5728\u8b66\u544a\uff01\n") + report));
                                break;
                            }
                        }
                    }
                    DBManager.getDBManager().sqlExecuteUpdate(stringArray, new int[]{n});
                }
                Object var18_19 = null;
                if (resultSet == null) break block33;
                try {
                    resultSet.close();
                    resultSet = null;
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                    connection = null;
                }
                catch (Exception exception2222) {}
            }
            break block35;
            {
                catch (WCMException wCMException) {
                    throw wCMException;
                }
                catch (Exception exception3) {
                    throw new WCMException(0, I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label12", "\u5229\u7528\u89e6\u53d1\u5668\u7684\u4e2d\u95f4\u7ed3\u679c\u8fdb\u884c\u81ea\u52a8\u5206\u53d1\u5931\u8d25"), exception3);
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var18_20 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                        resultSet = null;
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                        connection = null;
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private void synCopy(Channel channel, Channel channel2, Document document) throws WCMException {
        DocumentMgr documentMgr = this.getDocumentMgr();
        AppendixMgr appendixMgr = this.getAppendixManager();
        RelationMgr relationMgr = this.getRelationManager();
        Document document2 = documentMgr.copyDocument(document, channel, channel2);
        if (document2 != null && document2.getId() != document.getId()) {
            appendixMgr.copyAppendixes(document, document2);
            relationMgr.copyRelations(document, document2);
        }
    }
}

