/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.job.Schedule;
import com.trs.components.wcm.content.domain.DocumentPriMgr;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.CMyDateTime;
import org.apache.log4j.Logger;

public class ChnlDocLCListenerForPri
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(ChnlDocLCListenerForPri.class);
    private DocumentPriMgr m_oPriMgr = (DocumentPriMgr)DreamFactory.createObjectById("DocumentPriMgr");

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (!(baseObj instanceof ChnlDoc)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(ChnlDocLCListenerForPri.class, "ChnlDocLCListenerForPri.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(ChnlDocLCListenerForPri.class, "ChnlDocLCListenerForPri.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        ChnlDoc chnlDoc = (ChnlDoc)baseObj;
        if (!chnlDoc.isTopped()) {
            return;
        }
        CMyDateTime cMyDateTime = chnlDoc.getInvalidTime();
        if (cMyDateTime != null && !cMyDateTime.isNull()) {
            this.m_oPriMgr.createSchedule(chnlDoc, chnlDoc.getInvalidTime());
        }
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof ChnlDoc)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(ChnlDocLCListenerForPri.class, "ChnlDocLCListenerForPri.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(ChnlDocLCListenerForPri.class, "ChnlDocLCListenerForPri.label3", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        ChnlDoc chnlDoc = (ChnlDoc)baseObj;
        Schedule schedule = this.m_oPriMgr.findSchedule(chnlDoc);
        if (schedule != null) {
            schedule.delete(ContextHelper.getLoginUser());
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (baseObj == null || !(baseObj instanceof ChnlDoc)) {
            return;
        }
        ChnlDoc chnlDoc = (ChnlDoc)baseObj;
        if (!chnlDoc.isChangeProperty("INVALIDTIME") && !chnlDoc.isChangeProperty("DOCORDERPRI")) {
            return;
        }
        CMyDateTime cMyDateTime = this.getNewTopPriInvalidTime(chnlDoc);
        Schedule schedule = this.m_oPriMgr.findSchedule(chnlDoc);
        if (schedule == null) {
            if (cMyDateTime != null) {
                this.m_oPriMgr.createSchedule(chnlDoc, cMyDateTime);
            }
        } else if (cMyDateTime == null || ChnlDoc.NOT_ON_TOP == chnlDoc.getNewPropertyAsInt("DOCORDERPRI", 1)) {
            schedule.delete();
        } else {
            User user = ContextHelper.getLoginUser();
            if (!schedule.canEdit(user)) {
                throw new WCMException(1013, I18NMessage.get(ChnlDocLCListenerForPri.class, "ChnlDocLCListenerForPri.label5", "\u64a4\u6d88\u6587\u6863\u7f6e\u9876\u7684\u8ba1\u5212\u5df2\u88ab") + schedule.getLockerUser() + I18NMessage.get(ChnlDocLCListenerForPri.class, "ChnlDocLCListenerForPri.label6", "\u9501\u5b9a,\u66f4\u6539\u8ba1\u5212\u5931\u8d25!"));
            }
            schedule.setExeTime(cMyDateTime);
            schedule.save(user);
        }
    }

    private CMyDateTime getNewTopPriInvalidTime(ChnlDoc chnlDoc) {
        CMyDateTime cMyDateTime = (CMyDateTime)chnlDoc.getNewProperty("INVALIDTIME");
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            return null;
        }
        return cMyDateTime;
    }

    public static void main(String[] stringArray) {
        try {
            IObjectLCListenerOnModify iObjectLCListenerOnModify = (IObjectLCListenerOnModify)Class.forName("com.trs.components.wcm.content.domain.ChnlDocLCListenerForPri").newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

