/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ChnlDocLCListener4ClassInfo
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel {
    private static final String SQL_UPD_LINKQUOTE = "update WCMDOCUMENT set LINKQUOTE=? where DOCID=?";
    private static final String SQL_UPD_MIRRORQUOTE = "update WCMDOCUMENT set MIRRORQUOTE=? where DOCID=?";
    private static final String SQL_GET_LINKQUOTE = "select LINKQUOTE from WCMDOCUMENT where DOCID=?";
    private static final String SQL_GET_MIRRORQUOTE = "select MIRRORQUOTE from WCMDOCUMENT where DOCID=?";

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (baseObj == null || 614 != baseObj.getWCMType()) {
            return;
        }
        ChnlDoc chnlDoc = (ChnlDoc)baseObj;
        int n = chnlDoc.getModal();
        switch (n) {
            case 2: {
                this.addLinkQuote(chnlDoc.getDocId(), chnlDoc.getChannelId());
                break;
            }
            case 3: {
                this.addMirrorQuote(chnlDoc.getDocId(), chnlDoc.getChannelId());
                break;
            }
        }
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (baseObj == null || 614 != baseObj.getWCMType()) {
            return;
        }
        ChnlDoc chnlDoc = (ChnlDoc)baseObj;
        int n2 = chnlDoc.getModal();
        switch (n2) {
            case 2: {
                this.removeLinkQuote(chnlDoc.getDocId(), chnlDoc.getChannelId());
                break;
            }
            case 3: {
                this.removeMirrorQuote(chnlDoc.getDocId(), chnlDoc.getChannelId());
                break;
            }
        }
    }

    private void addLinkQuote(int n, int n2) throws WCMException {
        this.updateQuote(SQL_GET_LINKQUOTE, SQL_UPD_LINKQUOTE, n, n2, true);
    }

    private void addMirrorQuote(int n, int n2) throws WCMException {
        this.updateQuote(SQL_GET_MIRRORQUOTE, SQL_UPD_MIRRORQUOTE, n, n2, true);
    }

    private void removeLinkQuote(int n, int n2) throws WCMException {
        this.updateQuote(SQL_GET_LINKQUOTE, SQL_UPD_LINKQUOTE, n, n2, false);
    }

    private void removeMirrorQuote(int n, int n2) throws WCMException {
        this.updateQuote(SQL_GET_MIRRORQUOTE, SQL_UPD_MIRRORQUOTE, n, n2, false);
    }

    /*
     * Loose catch block
     */
    private void updateQuote(String string, String string2, int n, int n2, boolean bl) throws WCMException {
        block14: {
            DBManager dBManager;
            Statement statement;
            Connection connection;
            block13: {
                connection = null;
                statement = null;
                dBManager = DBManager.getDBManager();
                String string3 = this.getQuote(string, n);
                if (bl) {
                    string3 = string3.length() > 1 ? string3 + "," + n2 : String.valueOf(n2);
                } else {
                    string3 = "," + string3;
                    if ((string3 = string3.replaceAll("," + n2, "")).charAt(0) == ',') {
                        string3 = string3.substring(1);
                    }
                }
                connection = dBManager.getConnection();
                statement = connection.prepareStatement(string2);
                statement.setString(1, string3);
                statement.setInt(2, n);
                statement.executeUpdate();
                Object var11_11 = null;
                if (statement == null) break block13;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
            break block14;
            {
                catch (SQLException sQLException) {
                    throw new WCMException(40, I18NMessage.get(ChnlDocLCListener4ClassInfo.class, "ChnlDocLCListener4ClassInfo.label1", "\u66f4\u65b0\u5f15\u7528\u5206\u7c7b\u5931\u8d25"), sQLException);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    dBManager.freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private String getQuote(String string, int n) throws WCMException {
        String string2;
        DBManager dBManager;
        PreparedStatement preparedStatement;
        Connection connection;
        block10: {
            connection = null;
            preparedStatement = null;
            ResultSet resultSet = null;
            dBManager = DBManager.getDBManager();
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            String string3 = "";
            if (resultSet.next()) {
                string3 = resultSet.getString(1);
            }
            string2 = CMyString.showNull(string3, "");
            Object var10_10 = null;
            if (preparedStatement == null) break block10;
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (connection != null) {
            dBManager.freeConnection(connection);
        }
        return string2;
        catch (SQLException sQLException) {
            try {
                throw new WCMException(40, I18NMessage.get(ChnlDocLCListener4ClassInfo.class, "ChnlDocLCListener4ClassInfo.label2", "\u83b7\u53d6\u5206\u7c7b\u5f15\u7528\u5931\u8d25"), sQLException);
            }
            catch (Throwable throwable) {
                block11: {
                    Object var10_11 = null;
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (connection == null) break block11;
                    dBManager.freeConnection(connection);
                }
                throw throwable;
            }
        }
    }
}

