/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content;

import com.trs.DreamFactory;
import com.trs.cms.auth.config.RightConfigServer;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.HTMLContent;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class ViewDocument
extends CMSObj {
    private static Logger logger = Logger.getLogger(ViewDocument.class);
    public static final String DB_TABLE_NAME = "WCMDOCUMENT";
    public static final String ID_FIELD_NAME = "DOCID";
    public static final Integer KEY_CURR_HOST = new Integer(1);
    public static final Integer KEY_CHANNEL_RIGHTVALUES = new Integer(2);
    private Hashtable m_hChnlDocProperties = null;
    private HTMLContent m_oHTMLContent = null;
    private HashMap m_hPublicCache = null;
    private RightValue m_oRightValue = null;
    private Channel m_oDocChannel = null;
    private Channel m_oChannel = null;
    private int m_nDocId = 0;
    private Document m_oDocument = null;
    private ChnlDoc m_oChnlDoc = null;

    public ViewDocument(HashMap hashMap) {
        this.m_hPublicCache = hashMap;
        this.m_bCheckPropertyValid = false;
    }

    public void setId(int n) {
        this.id = n;
    }

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return ID_FIELD_NAME;
    }

    public int getWCMType() {
        return 0;
    }

    public boolean isValid() {
        return false;
    }

    public void setChnlDocProperty(String string, Object object) {
        if (this.m_hChnlDocProperties == null) {
            this.m_hChnlDocProperties = new Hashtable();
        }
        this.m_hChnlDocProperties.put(string.toUpperCase(), object);
    }

    public int getChnlDocProperty(String string, int n) {
        Number number = (Number)this.m_hChnlDocProperties.get(string.toUpperCase());
        if (number == null) {
            return n;
        }
        return number.intValue();
    }

    public String getChnlDocProperty(String string) {
        Object v = this.m_hChnlDocProperties.get(string.toUpperCase());
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    public void cloneDocumentProperties(ViewDocument viewDocument) {
        this.m_hProperties = viewDocument.getProperties(false);
    }

    public Hashtable getChnlDocProperties() {
        return this.m_hChnlDocProperties;
    }

    public int getDocId() {
        return this.m_nDocId;
    }

    public void setDocId(int n) {
        this.m_nDocId = n;
    }

    public int getChannelId() {
        return Math.abs(this.getChnlDocProperty("CHNLID", 0));
    }

    public Channel getChannel() throws WCMException {
        if (this.m_oChannel != null) {
            return this.m_oChannel;
        }
        int n = this.getChannelId();
        BaseChannel baseChannel = this.getCurrChannelOrSite();
        if (baseChannel != null && !baseChannel.isSite() && baseChannel.getId() == n) {
            this.m_oChannel = (Channel)baseChannel;
            return this.m_oChannel;
        }
        int n2 = this.getChnlDocProperty("Modal", 1);
        if (n2 == 1 && this.getDocChannelId() == n) {
            this.m_oChannel = this.getDocChannel();
            return this.m_oChannel;
        }
        this.m_oChannel = Channel.findById(n);
        return this.m_oChannel;
    }

    public int getDocChannelId() {
        int n = Math.abs(this.getChnlDocProperty("DocChannel", 0));
        if (n <= 0) {
            n = Math.abs(this.getPropertyAsInt("DocChannel", 0));
        }
        return n;
    }

    public Channel getDocChannel() throws WCMException {
        if (this.m_oDocChannel == null) {
            this.m_oDocChannel = Channel.findById(this.getDocChannelId());
        }
        return this.m_oDocChannel;
    }

    public int getStatusId() {
        return this.getChnlDocProperty("DOCSTATUS", 0);
    }

    public Status getStatus() throws WCMException {
        return Status.findById(Math.abs(this.getStatusId()));
    }

    public boolean isTopped() {
        BaseChannel baseChannel = this.getCurrChannelOrSite();
        if (baseChannel == null) {
            return false;
        }
        if (baseChannel.isSite()) {
            return false;
        }
        Channel channel = (Channel)baseChannel;
        return this.getChnlDocProperty("DOCORDERPRI", 0) > 0;
    }

    public int getSourceId() {
        return this.getPropertyAsInt("DOCSOURCE", 0);
    }

    public Source getSource() throws WCMException {
        return Source.findById(this.getSourceId());
    }

    public String getHtmlContentWithImgFilter(String string, boolean bl) throws WCMException {
        return this.getHtmlContentWithImgFilter(string, bl, false);
    }

    public String getHtmlContentWithImgFilter(String string, boolean bl, boolean bl2) throws WCMException {
        if (this.getType() != 20) {
            return "";
        }
        if (this.m_oHTMLContent == null) {
            this.m_oHTMLContent = new HTMLContent(bl2 ? this.getPubHtmlContent() : this.getHtmlContent());
        }
        return this.m_oHTMLContent.parseHTMLContent(string);
    }

    public String getPubHtmlContent() {
        if (!this.getProperties(true).containsKey("DOCPUBHTMLCON")) {
            try {
                this.loadTextsFromDB("DOCPUBHTMLCON");
            }
            catch (Exception exception) {
                logger.error((Object)(I18NMessage.get(ViewDocument.class, "ViewDocument.label1", "\u8f7d\u5165[") + this + I18NMessage.get(ViewDocument.class, "ViewDocument.label2", "] DOCPUBHTMLCON \u5c5e\u6027\u5931\u8d25\uff01")));
                throw new RuntimeException(I18NMessage.get(ViewDocument.class, "ViewDocument.label1", "\u8f7d\u5165[") + this + I18NMessage.get(ViewDocument.class, "ViewDocument.label3", "] DOCPUBHTMLCON \u5c5e\u6027\u5931\u8d25\uff01\n") + CMyException.getStackTraceText(exception));
            }
        }
        return this.getPropertyAsString("DOCPUBHTMLCON");
    }

    public String getHtmlContent() {
        if (!this.getProperties(true).containsKey("DOCHTMLCON")) {
            try {
                this.loadTextsFromDB("DOCHTMLCON");
            }
            catch (Exception exception) {
                logger.error((Object)(I18NMessage.get(ViewDocument.class, "ViewDocument.label1", "\u8f7d\u5165[") + this + I18NMessage.get(ViewDocument.class, "ViewDocument.label4", "] DOCHTMLCON \u5c5e\u6027\u5931\u8d25\uff01")));
                throw new RuntimeException(I18NMessage.get(ViewDocument.class, "ViewDocument.label1", "\u8f7d\u5165[") + this + I18NMessage.get(ViewDocument.class, "ViewDocument.label5", "] DOCHTMLCON \u5c5e\u6027\u5931\u8d25\uff01\n") + CMyException.getStackTraceText(exception));
            }
        }
        return this.getPropertyAsString("DOCHTMLCON");
    }

    public int getType() {
        return this.getPropertyAsInt("DOCTYPE", 0);
    }

    public String getContent() {
        if (!this.getProperties(true).containsKey("DOCCONTENT")) {
            try {
                this.loadTextsFromDB("DOCCONTENT");
            }
            catch (Exception exception) {
                logger.error((Object)(I18NMessage.get(ViewDocument.class, "ViewDocument.label1", "\u8f7d\u5165[") + this + I18NMessage.get(ViewDocument.class, "ViewDocument.label6", "] DOCONTENT \u5c5e\u6027\u5931\u8d25\uff01")));
                throw new RuntimeException(I18NMessage.get(ViewDocument.class, "ViewDocument.label1", "\u8f7d\u5165[") + this + I18NMessage.get(ViewDocument.class, "ViewDocument.label7", "] DOCONTENT \u5c5e\u6027\u5931\u8d25\uff01\n") + CMyException.getStackTraceText(exception));
            }
        }
        return this.getPropertyAsString("DOCCONTENT");
    }

    public String getTypeString() {
        return Document.getTypeString(this.getType());
    }

    public HashMap getPublicCache() {
        if (this.m_hPublicCache == null) {
            this.m_hPublicCache = new HashMap(1);
        }
        return this.m_hPublicCache;
    }

    public void setPublicCache(HashMap hashMap) {
        this.m_hPublicCache = hashMap;
    }

    public BaseChannel getCurrChannelOrSite() {
        return (BaseChannel)this.getPublicCache().get(KEY_CURR_HOST);
    }

    public RightValue getRightValue(User user) throws WCMException {
        if (this.m_oRightValue != null) {
            return this.m_oRightValue;
        }
        this.m_oRightValue = this.makeRightValue(user);
        return this.m_oRightValue;
    }

    private RightValue makeRightValue(User user) throws WCMException {
        Object object;
        String string = this.getPropertyAsString("FLOWOPERATIONMARK");
        boolean bl = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("FLOW_RIGHT_PRI", "false"));
        boolean bl2 = bl && !CMyString.isEmpty(string) && !string.equalsIgnoreCase("RESERVED_FORCED_END") && !string.equals(I18NMessage.get(ViewDocument.class, "ViewDocument.label8", "\u7ed3\u675f\u6d41\u8f6c"));
        int[] nArray = WCMRightTypes.getRemoveRightIndexs();
        if (this.isRightDefined()) {
            try {
                RightValue rightValue = new RightValue();
                rightValue.load(user, 605, this.getDocId(), true);
                if (user.getName().equalsIgnoreCase(this.getCrUserName())) {
                    int[] nArray2 = DocumentAuthServer.INDEXES_OWNER_HAS;
                    for (int i = 0; i < nArray2.length; ++i) {
                        int n = nArray2[i];
                        rightValue.setBit(n, true);
                    }
                }
                if (bl2) {
                    for (int i = 0; i < nArray.length; ++i) {
                        rightValue.setBit(nArray[i], false);
                    }
                }
                return rightValue;
            }
            catch (WCMException wCMException) {
                throw new WCMException(1100, I18NMessage.get(ViewDocument.class, "ViewDocument.label9", "\u83b7\u53d6\u6307\u5b9a\u5bf9\u8c61\u7684\u6743\u9650\u503c\u65f6\u5931\u8d25(") + this.getClass().getName() + ".getRightValue)", wCMException);
            }
        }
        if (user.isAdministrator()) {
            RightValue rightValue = new RightValue(RightValue.getAdministratorRightValue().getValue());
            if (bl2) {
                for (int i = 0; i < nArray.length; ++i) {
                    rightValue.setBit(nArray[i], false);
                }
            }
            return rightValue;
        }
        BaseChannel baseChannel = this.getCurrChannelOrSite();
        Channel channel = null;
        channel = baseChannel != null && !baseChannel.isSite() && baseChannel.getId() == this.getChannelId() ? (Channel)baseChannel : this.getChannel();
        RightValue rightValue = new RightValue();
        Document document = this.getDocument();
        boolean bl3 = DocumentAuthServer.hasRightByDocLevel(user, this.getDocChannel(), document);
        if (bl3) {
            object = this.getChannelRightValueFromCache(user, channel);
            if (this.getDocChannelId() > 0 && channel.getId() != this.getDocChannelId()) {
                RightValue rightValue2 = this.getChannelRightValueFromCache(user, this.getDocChannel());
                rightValue.copy(rightValue2);
                int[] nArray3 = RightConfigServer.getInstance().getRightIndexDefineOnCurrChannel(channel.getSiteId());
                for (int i = 0; i < nArray3.length; ++i) {
                    int n = nArray3[i];
                    rightValue.setBit(n, ((CMyBitsValue)object).getBit(n));
                }
            } else {
                rightValue.copy((RightValue)object);
            }
        }
        if (user.getName().equalsIgnoreCase(this.getCrUserName())) {
            object = DocumentAuthServer.INDEXES_OWNER_HAS;
            for (int i = 0; i < ((Object)object).length; ++i) {
                Object object2 = object[i];
                rightValue.setBit((int)object2, true);
            }
        }
        if (bl2) {
            for (int i = 0; i < nArray.length; ++i) {
                rightValue.setBit(nArray[i], false);
            }
        }
        return rightValue;
    }

    private RightValue getChannelRightValueFromCache(User user, Channel channel) throws WCMException {
        RightValue rightValue;
        Object object = channel.getKey();
        HashMap<Object, RightValue> hashMap = (HashMap<Object, RightValue>)this.getPublicCache().get(KEY_CHANNEL_RIGHTVALUES);
        if (hashMap == null) {
            hashMap = new HashMap<Object, RightValue>(1);
            this.getPublicCache().put(KEY_CHANNEL_RIGHTVALUES, hashMap);
        }
        if ((rightValue = (RightValue)hashMap.get(object)) == null) {
            if (user.isAdministrator() || user.getName().equalsIgnoreCase(channel.getCrUserName())) {
                rightValue = RightValue.getAdministratorRightValue();
            } else {
                rightValue = new RightValue();
                IObjectMemberMgr iObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
                if (iObjectMemberMgr.canOperate(user, channel.getWCMType(), channel.getId())) {
                    rightValue.load(user, 101, channel.getId(), true);
                }
                hashMap.put(object, rightValue);
            }
        }
        return rightValue;
    }

    public boolean isRightDefined() throws WCMException {
        RightCacheMgr rightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
        return rightCacheMgr.isExistsRight(605, this.getDocId());
    }

    public boolean hasRight(User user, int n) throws WCMException {
        RightValue rightValue = this.getRightValue(user);
        if (this.isRightDefined()) {
            if (n == 64) {
                return rightValue.getValue() > 0L;
            }
            return rightValue.isHasRight(n);
        }
        return rightValue.isHasRight(n);
    }

    public void setDocChannel(Channel channel) {
        this.m_oDocChannel = channel;
    }

    public static ViewDocument findById(BaseChannel baseChannel, int n, String string, String string2) throws WCMException {
        String string3 = null;
        if (string == null) {
            string3 = "DOCID,RECID,CHNLID,DOCCHANNEL";
        } else {
            string3 = string.toUpperCase();
            if (string3.indexOf(" FROM ") >= 0) {
                return null;
            }
        }
        HashMap<Integer, BaseChannel> hashMap = new HashMap<Integer, BaseChannel>(1);
        if (baseChannel != null) {
            hashMap.put(KEY_CURR_HOST, baseChannel);
        }
        ViewDocument viewDocument = new ViewDocument(hashMap);
        viewDocument.setId(n);
        if (!viewDocument.loadDatasOfChnlDoc(string3)) {
            return null;
        }
        if (string2 == null || string2.trim().length() == 0) {
            return viewDocument;
        }
        String string4 = string2.toUpperCase();
        if (string4.indexOf(" FROM ") >= 0) {
            return null;
        }
        viewDocument.loadDatasOfDocument(string4);
        return viewDocument;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean loadDatasOfChnlDoc(String var1_1) throws WCMException {
        block38: {
            block37: {
                block32: {
                    block36: {
                        block35: {
                            block31: {
                                var2_2 = null;
                                var3_3 = null;
                                var4_4 = null;
                                var5_5 = "select " + var1_1 + " from WCMChnlDoc where RecId=?";
                                try {
                                    try {
                                        var2_2 = this.getDBManager().getConnection();
                                        var3_3 = var2_2.prepareStatement(var5_5);
                                        var3_3.setMaxRows(1);
                                        var3_3.setFetchSize(1);
                                        var3_3.setInt(1, this.getId());
                                        var4_4 = var3_3.executeQuery();
                                        if (!var4_4.next()) {
                                            var6_6 = false;
                                            var14_10 = null;
                                            break block31;
                                        }
                                        var6_7 = var4_4.getMetaData();
                                        var7_16 = var6_7.getColumnCount();
                                        var8_17 = null;
                                        for (var10_18 = 1; var10_18 <= var7_16; ++var10_18) {
                                            var9_19 = var6_7.getColumnLabel(var10_18).toUpperCase();
                                            if (var9_19.equals("DOCID")) {
                                                this.setDocId(var4_4.getInt(var10_18));
                                                continue;
                                            }
                                            var8_17 = null;
                                            switch (var6_7.getColumnType(var10_18)) {
                                                case 2: 
                                                case 3: {
                                                    if (var6_7.getScale(var10_18) <= 0) {
                                                        var11_20 = var4_4.getLong(var10_18);
                                                        if (var4_4.wasNull()) break;
                                                        var8_17 = new Long(var11_20);
                                                        break;
                                                    }
                                                    var11_21 = new Double(var4_4.getDouble(var10_18));
                                                    if (var4_4.wasNull()) break;
                                                    var8_17 = var11_21;
                                                    break;
                                                }
                                                case -6: 
                                                case -5: 
                                                case 4: 
                                                case 5: {
                                                    var11_22 = var4_4.getLong(var10_18);
                                                    if (var4_4.wasNull()) break;
                                                    var8_17 = new Long(var11_22);
                                                    break;
                                                }
                                                case 12: {
                                                    var8_17 = var4_4.getString(var10_18);
                                                    break;
                                                }
                                                case 91: 
                                                case 92: 
                                                case 93: {
                                                    var8_17 = new CMyDateTime();
                                                    ((CMyDateTime)var8_17).setDateTimeWithRs(var4_4, var10_18);
                                                    break;
                                                }
                                                case 8: {
                                                    var11_23 = var4_4.getDouble(var10_18);
                                                    if (var4_4.wasNull()) break;
                                                    var8_17 = new Double(var11_23);
                                                    break;
                                                }
                                                default: {
                                                    var8_17 = var4_4.getObject(var10_18);
                                                }
                                            }
                                            if (var8_17 == null) continue;
                                            this.setChnlDocProperty(var9_19, var8_17);
                                        }
                                        var10_18 = 1;
                                        break block32;
                                    }
                                    catch (SQLException var6_8) {
                                        throw new WCMException(40, I18NMessage.get(ViewDocument.class, "ViewDocument.label10", "\u8f7d\u5165ChnlDoc\u6570\u636e[RecId=") + this.getId() + I18NMessage.get(ViewDocument.class, "ViewDocument.label11", "]\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff1a\n") + var5_5, var6_8);
                                    }
                                    catch (Exception var6_9) {
                                        throw new WCMException(0, I18NMessage.get(ViewDocument.class, "ViewDocument.label10", "\u8f7d\u5165ChnlDoc\u6570\u636e[RecId=") + this.getId() + I18NMessage.get(ViewDocument.class, "ViewDocument.label12", "]\u5931\u8d25"), var6_9);
                                    }
                                }
                                catch (Throwable var13_24) {
                                    var14_12 = null;
                                    try {
                                        if (var4_4 != null) {
                                            var4_4.close();
                                        }
                                    }
                                    catch (Exception var15_15) {
                                        // empty catch block
                                    }
                                    try {
                                        if (var3_3 != null) {
                                            var3_3.close();
                                        }
                                    }
                                    catch (Exception var15_15) {
                                        var15_15.printStackTrace();
                                    }
                                    if (var2_2 == null) throw var13_24;
                                    this.getDBManager().freeConnection(var2_2);
                                    throw var13_24;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [7 : 641->656)] { 
lbl89:
                            // 1 sources

                            if (var4_4 != null) {
                                var4_4.close();
                            }
                            break block35;
lbl92:
                            // 1 sources

                            catch (Exception var15_13) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [8 : 658->671)] { 
lbl96:
                        // 1 sources

                        if (var3_3 != null) {
                            var3_3.close();
                        }
                        break block36;
lbl99:
                        // 1 sources

                        catch (Exception var15_13) {
                            var15_13.printStackTrace();
                        }
                    }
                    if (var2_2 == null) return var6_6;
                    this.getDBManager().freeConnection(var2_2);
                    return var6_6;
                }
                var14_11 = null;
                ** try [egrp 2[TRYBLOCK] [7 : 641->656)] { 
lbl108:
                // 1 sources

                if (var4_4 != null) {
                    var4_4.close();
                }
                break block37;
lbl111:
                // 1 sources

                catch (Exception var15_14) {
                    // empty catch block
                }
            }
            ** try [egrp 3[TRYBLOCK] [8 : 658->671)] { 
lbl115:
            // 1 sources

            if (var3_3 != null) {
                var3_3.close();
            }
            break block38;
lbl118:
            // 1 sources

            catch (Exception var15_14) {
                var15_14.printStackTrace();
            }
        }
        if (var2_2 == null) return (boolean)var10_18;
        this.getDBManager().freeConnection(var2_2);
        return (boolean)var10_18;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean loadDatasOfDocument(String var1_1) throws WCMException {
        block28: {
            block27: {
                block22: {
                    block26: {
                        block25: {
                            block21: {
                                var2_2 = null;
                                var3_3 = null;
                                var4_4 = null;
                                var5_5 = "select " + var1_1 + " from WCMDocument where DocId=?";
                                try {
                                    try {
                                        var2_2 = this.getDBManager().getConnection();
                                        var3_3 = var2_2.prepareStatement(var5_5);
                                        var3_3.setMaxRows(1);
                                        var3_3.setFetchSize(1);
                                        var3_3.setInt(1, this.getDocId());
                                        var4_4 = var3_3.executeQuery();
                                        if (!var4_4.next()) {
                                            var6_6 = false;
                                            var9_10 = null;
                                            break block21;
                                        }
                                        this.setLoadText(true);
                                        var6_7 = var4_4.getMetaData();
                                        this.readFromRs(var4_4, var6_7);
                                        var7_16 = true;
                                        break block22;
                                    }
                                    catch (SQLException var6_8) {
                                        throw new WCMException(40, I18NMessage.get(ViewDocument.class, "ViewDocument.label13", "\u8f7d\u5165Document\u6570\u636e[RecId=") + this.getDocId() + I18NMessage.get(ViewDocument.class, "ViewDocument.label11", "]\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff1a\n") + var5_5, var6_8);
                                    }
                                    catch (Exception var6_9) {
                                        throw new WCMException(0, I18NMessage.get(ViewDocument.class, "ViewDocument.label14", "\u8f7d\u5165Document\u6570\u636e\u5931\u8d25"), var6_9);
                                    }
                                }
                                catch (Throwable var8_17) {
                                    var9_12 = null;
                                    try {
                                        if (var4_4 != null) {
                                            var4_4.close();
                                        }
                                    }
                                    catch (Exception var10_15) {
                                        // empty catch block
                                    }
                                    try {
                                        if (var3_3 != null) {
                                            var3_3.close();
                                        }
                                    }
                                    catch (Exception var10_15) {
                                        var10_15.printStackTrace();
                                    }
                                    if (var2_2 == null) throw var8_17;
                                    this.getDBManager().freeConnection(var2_2);
                                    throw var8_17;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [7 : 228->243)] { 
lbl50:
                            // 1 sources

                            if (var4_4 != null) {
                                var4_4.close();
                            }
                            break block25;
lbl53:
                            // 1 sources

                            catch (Exception var10_13) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [8 : 245->258)] { 
lbl57:
                        // 1 sources

                        if (var3_3 != null) {
                            var3_3.close();
                        }
                        break block26;
lbl60:
                        // 1 sources

                        catch (Exception var10_13) {
                            var10_13.printStackTrace();
                        }
                    }
                    if (var2_2 == null) return var6_6;
                    this.getDBManager().freeConnection(var2_2);
                    return var6_6;
                }
                var9_11 = null;
                ** try [egrp 2[TRYBLOCK] [7 : 228->243)] { 
lbl69:
                // 1 sources

                if (var4_4 != null) {
                    var4_4.close();
                }
                break block27;
lbl72:
                // 1 sources

                catch (Exception var10_14) {
                    // empty catch block
                }
            }
            ** try [egrp 3[TRYBLOCK] [8 : 245->258)] { 
lbl76:
            // 1 sources

            if (var3_3 != null) {
                var3_3.close();
            }
            break block28;
lbl79:
            // 1 sources

            catch (Exception var10_14) {
                var10_14.printStackTrace();
            }
        }
        if (var2_2 == null) return var7_16;
        this.getDBManager().freeConnection(var2_2);
        return var7_16;
    }

    public final void readChnlDocPropertyFromRs(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws WCMException {
        try {
            if (resultSet == null) {
                return;
            }
            Object object = null;
            ResultSetMetaData resultSetMetaData2 = resultSetMetaData != null ? resultSetMetaData : resultSet.getMetaData();
            int n = resultSetMetaData2.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                String string = resultSetMetaData2.getColumnLabel(i).toUpperCase();
                if (string.equalsIgnoreCase(ID_FIELD_NAME)) {
                    this.setDocId(resultSet.getInt(i));
                    continue;
                }
                object = null;
                switch (resultSetMetaData2.getColumnType(i)) {
                    case 2: 
                    case 3: {
                        if (resultSetMetaData2.getScale(i) <= 0) {
                            long l = resultSet.getLong(i);
                            if (resultSet.wasNull()) break;
                            object = new Long(l);
                            break;
                        }
                        Double d = new Double(resultSet.getDouble(i));
                        if (resultSet.wasNull()) break;
                        object = d;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        long l = resultSet.getLong(i);
                        if (resultSet.wasNull()) break;
                        object = new Long(l);
                        break;
                    }
                    case 12: {
                        object = resultSet.getString(i);
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        object = new CMyDateTime();
                        ((CMyDateTime)object).setDateTimeWithRs(resultSet, i);
                        break;
                    }
                    case -1: 
                    case 2005: {
                        object = new CDBText(this.getDBManager().getDBType());
                        ((CDBText)object).readFromRs(resultSet, i);
                        break;
                    }
                    case 8: {
                        double d = resultSet.getDouble(i);
                        if (resultSet.wasNull()) break;
                        object = new Double(d);
                        break;
                    }
                    default: {
                        object = resultSet.getObject(i);
                    }
                }
                if (object == null) continue;
                this.setChnlDocProperty(string, object);
            }
            this.id = this.getChnlDocProperty("RECID", 0);
        }
        catch (SQLException sQLException) {
            throw new WCMException(40, I18NMessage.get(ViewDocument.class, "ViewDocument.label15", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08") + this.getClass().getName() + ".readChnlDocPropertyFromRs).", sQLException);
        }
        catch (CMyException cMyException) {
            throw new WCMException(1, I18NMessage.get(ViewDocument.class, "ViewDocument.label15", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08") + this.getClass().getName() + ".readChnlDocPropertyFromRs).", cMyException);
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(ViewDocument.class, "ViewDocument.label15", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08") + this.getClass().getName() + ".readChnlDocPropertyFromRs).", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument() throws WCMException {
        if (this.m_oDocument == null) {
            ViewDocument viewDocument = this;
            synchronized (viewDocument) {
                if (this.m_oDocument != null) {
                    return this.m_oDocument;
                }
                this.m_oDocument = Document.createNewInstance();
                this.m_oDocument.setMyDocId(this.m_nDocId);
                this.m_oDocument.setProperties(this.m_hProperties);
            }
        }
        return this.m_oDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChnlDoc getChnlDoc() throws WCMException {
        if (this.m_oChnlDoc == null) {
            ViewDocument viewDocument = this;
            synchronized (viewDocument) {
                if (this.m_oChnlDoc != null) {
                    return this.m_oChnlDoc;
                }
                this.m_oChnlDoc = ChnlDoc.createNewInstance();
                this.m_oChnlDoc.setId(this.getId());
                this.m_oChnlDoc.setProperties(this.m_hChnlDocProperties);
            }
        }
        return this.m_oChnlDoc;
    }
}

