/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.auth;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.domain.IRightObj;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.common.WCMException;

public class WebSiteRightObjImpl
implements IRightObj {
    private WebSite m_oSite = null;

    public boolean hasRight(User user, int n) throws WCMException {
        if (n == -1) {
            return true;
        }
        if (user.isAdministrator() || user.getName().equalsIgnoreCase(this.m_oSite.getCrUserName())) {
            return true;
        }
        IObjectMemberMgr iObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
        if (n == 64 || n == 14) {
            return iObjectMemberMgr.isVisible(user, this.m_oSite.getWCMType(), this.m_oSite.getId());
        }
        if (!iObjectMemberMgr.canOperate(user, this.m_oSite.getWCMType(), this.m_oSite.getId())) {
            return false;
        }
        return AuthServer.hasRightOnSelf(user, this.m_oSite, n);
    }

    public int getId() {
        return this.m_oSite == null ? 0 : this.m_oSite.getId();
    }

    public String getInfo() {
        if (this.m_oSite == null) {
            return null;
        }
        return this.m_oSite.toString();
    }

    public CMSObj getSubstance() {
        return this.m_oSite;
    }

    public int getType() {
        return 103;
    }

    public boolean loadById(int n) throws WCMException {
        this.m_oSite = WebSite.findById(n);
        return true;
    }

    public void makeFrom(CMSObj cMSObj) throws WCMException {
        this.m_oSite = (WebSite)cMSObj;
    }

    public void setSubstance(CMSObj cMSObj) {
        this.m_oSite = (WebSite)cMSObj;
    }
}

