/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.advisor.OptionGroup;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;

public class Option
extends CMSObj {
    public static final int OBJ_TYPE = 1705862168;
    public static final String DB_TABLE_NAME = "XWCMOPTION";
    public static final String DB_ID_NAME = "OPTIONID";
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 1705862168;
    }

    public String getOptionName() {
        return this.getPropertyAsString("OPTIONNAME");
    }

    public boolean setOptionName(String string) throws WCMException {
        return this.setProperty("OPTIONNAME", string);
    }

    public String getOptionDesc() {
        return this.getPropertyAsString("OPTIONDESC");
    }

    public boolean setOptionDesc(String string) throws WCMException {
        return this.setProperty("OPTIONDESC", string);
    }

    public String getPicFileName() {
        return this.getPropertyAsString("PICTRUE");
    }

    public boolean setPicFileName(String string) throws WCMException {
        return this.setProperty("PICTRUE", string);
    }

    public String getLastOptions() {
        return this.getPropertyAsString("LASTOPTIONS");
    }

    public boolean setLastOptions(String string) throws WCMException {
        return this.setProperty("LASTOPTIONS", string);
    }

    public String getSearchCondition() {
        return this.getPropertyAsString("SEARCHCONDITION");
    }

    public boolean setSearchCondition(String string) throws WCMException {
        return this.setProperty("SEARCHCONDITION", string);
    }

    public String getNotAllowedSelectOptions() {
        return this.getPropertyAsString("NOTALLOWEDSELECTOPTIONS");
    }

    public boolean setNotAllowedSelectOptions(String string) throws WCMException {
        return this.setProperty("NOTALLOWEDSELECTOPTIONS", string);
    }

    public int getGroupId() {
        return this.getPropertyAsInt("GROUPID", 0);
    }

    public boolean setGroupId(int n) throws WCMException {
        return this.setProperty("GROUPID", n);
    }

    public int getStepId() {
        return this.getPropertyAsInt("STEPID", 0);
    }

    public boolean setStepId(int n) throws WCMException {
        return this.setProperty("STEPID", n);
    }

    public int getOrder() {
        return this.getPropertyAsInt("AORDER", 0);
    }

    public boolean setOrder(int n) throws WCMException {
        return this.setProperty("AORDER", n);
    }

    public boolean isValid() throws WCMException {
        Object object;
        int n = 0;
        if (this.isAddMode()) {
            if (this.getProperty("OPTIONNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(Option.class, "Option.label1", "\u5c5e\u6027OptionName\u6ca1\u6709\u8bbe\u7f6e(Option.isValid)"));
            }
            if (this.getProperty("GROUPID") == null) {
                throw new WCMException(1106, I18NMessage.get(Option.class, "Option.label2", "\u5c5e\u6027GroupId\u6ca1\u6709\u8bbe\u7f6e(Option.isValid)"));
            }
            n = this.getGroupId();
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Option.class, "Option.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Option.isValid)"));
            }
            if (this.isChangeProperty("GROUPID")) {
                n = this.getNewPropertyAsInt("GROUPID", 0);
            }
            if (this.isChangeProperty("PICTRUE")) {
                object = FilesMan.getFilesMan();
                String string = this.getPicFileName();
                if (!CMyString.isEmpty(string)) {
                    String string2 = ((FilesMan)object).mapFilePath(string, 0) + string;
                    CMyFile.deleteFile(string2);
                }
            }
        }
        if (n > 0) {
            object = OptionGroup.findById(n);
            if (object == null) {
                throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(266112697)}));
            }
            this.setStepId(((OptionGroup)object).getStepId());
        }
        this.changeOrder();
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(user);
        }
    }

    public int delete() throws WCMException {
        this.deleteRelationFiles();
        return super.delete();
    }

    public int delete(User user) throws WCMException {
        this.deleteRelationFiles();
        return super.delete(user);
    }

    private void deleteRelationFiles() throws WCMException {
        String string = this.getPicFileName();
        if (!CMyString.isEmpty(string)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            String string2 = filesMan.mapFilePath(string, 0) + string;
            CMyFile.deleteFile(string2);
        }
    }

    private void changeOrder() throws WCMException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.isAddMode()) {
            n2 = this.getOrder();
            n = this.getMaxOrder();
            if (n2 == -1) {
                n2 = n + 1;
                this.setOrder(n2);
                return;
            }
            n5 = 1;
            n4 = n;
            n3 = n2;
        } else {
            if (!this.isChangeProperty("AORDER")) {
                return;
            }
            n2 = this.getNewPropertyAsInt("AORDER", -1);
            if (n2 == -1) {
                n = this.getMaxOrder();
                if (n == this.getOrder()) {
                    n2 = this.getOrder();
                } else {
                    n5 = -1;
                    n4 = n;
                    n3 = this.getOrder() + 1;
                    n2 = n;
                }
            } else if (n2 > this.getOrder()) {
                n5 = -1;
                n4 = n2;
                n3 = this.getOrder() + 1;
            } else {
                n5 = 1;
                n4 = this.getOrder() - 1;
                n3 = n2;
            }
        }
        String string = "AORDER>=" + n3 + " AND AORDER <= " + n4 + " and GROUPID=" + this.getGroupId();
        String string2 = "UPDATE XWCMOPTION SET AORDER = AORDER+(" + n5 + ") WHERE " + string;
        DBManager.getDBManager().sqlExecuteUpdate(string2);
        this.setOrder(n2);
    }

    private int getMaxOrder() throws WCMException {
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(AORDER) from XWCMOPTION where GROUPID=?", new int[]{this.getGroupId()});
    }

    public static final Option findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Option)BaseObj.findById(Option.class, n);
    }

    public static final Option createNewInstance() throws WCMException {
        return (Option)BaseObj.createNewInstance(Option.class);
    }

    public static final Option findByKey(Object object) throws WCMException {
        return (Option)BaseObj.findByKey(Option.class, object);
    }
}

