/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.components.stat.BaseStatHandler;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.DebugTimer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DocStatHandler4UserDept
extends BaseStatHandler {
    private static Logger logger = Logger.getLogger(DocStatHandler4UserDept.class);
    private HashMap m_hRelGroupsOfUser = new HashMap();

    public void visitStatItem(ResultSet resultSet, int n) throws WCMException {
        try {
            String string = resultSet.getString(2);
            int n2 = resultSet.getInt(1);
            if (n2 == 0) {
                return;
            }
            DebugTimer debugTimer = new DebugTimer();
            debugTimer.start();
            Groups groups = this.makeCurrRelGroups(string);
            debugTimer.stop();
            logger.debug((Object)("makeCurrRelGroups of " + string + " use[" + debugTimer.getTime() + "]ms"));
            debugTimer.start();
            int n3 = groups.size();
            for (int i = 0; i < n3; ++i) {
                Group group = (Group)groups.getAt(i);
                if (group == null) continue;
                String string2 = group.getId() + "";
                String string3 = this.makePrivateKey(string2, resultSet);
                int n4 = this.getValue(n, string3);
                int n5 = n2;
                this.setValue(n, string3, n5 += n4);
                this.addMajorObject(string2);
            }
            debugTimer.stop();
            logger.debug((Object)("merge datacount of " + string + " use[" + debugTimer.getTime() + "]ms"));
        }
        catch (SQLException sQLException) {
            logger.debug((Object)"\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)sQLException);
            throw new WCMException("\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", sQLException);
        }
    }

    private String makePrivateKey(String string, ResultSet resultSet) throws SQLException {
        int n = resultSet.getMetaData().getColumnCount();
        String[] stringArray = new String[n - 1];
        stringArray[0] = string;
        for (int i = 2; i < n; ++i) {
            stringArray[i - 1] = resultSet.getString(i + 1);
        }
        return this.makeKey(stringArray);
    }

    private Groups makeCurrRelGroups(String string) throws WCMException {
        Groups groups = (Groups)this.m_hRelGroupsOfUser.get(string);
        if (groups != null) {
            return groups;
        }
        groups = new Groups(null);
        User user = User.findByName(string);
        if (user == null) {
            return groups;
        }
        Groups groups2 = user.getGroups();
        int n = groups2.size();
        for (int i = 0; i < n; ++i) {
            Group group = (Group)groups2.getAt(i);
            if (group == null) continue;
            for (Group group2 = group; group2 != null; group2 = group2.getParent()) {
                groups.addElement(group2);
            }
        }
        this.m_hRelGroupsOfUser.put(user.getKey(), groups);
        return groups;
    }
}

