/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.components.govinfo.GovInfoViewFinder;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.service.IDefaultChannelMaker;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import org.apache.log4j.Logger;

public class UserRelateInfoMaker
implements IDefaultChannelMaker {
    private static Logger logger = Logger.getLogger(UserRelateInfoMaker.class);
    private static final String WHERE_QUERY_GROUP_ID_BY_PATH = "CName=? and exists(select 1 from XWCMClassInfo b where b.CName=? and b.ClassInfoId=a.ParentId) and RootId in(select ClassInfoId from XWCMClassInfo where ParentId=0 and CName=?)";

    public static ClassInfo makeDefaultClassInfo(String string, User user) throws WCMException {
        IDepartmentMgr iDepartmentMgr = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
        Groups groups = iDepartmentMgr.getDeptGroupTree(user);
        if (groups.size() < 2) {
            return null;
        }
        WCMFilter wCMFilter = new WCMFilter("XWCMClassInfo a", WHERE_QUERY_GROUP_ID_BY_PATH, "");
        wCMFilter.addSearchValues(((Group)groups.getAt(0)).getName());
        wCMFilter.addSearchValues(((Group)groups.getAt(1)).getName());
        wCMFilter.addSearchValues(string);
        wCMFilter.setMaxRowNumber(1);
        ClassInfos classInfos = ClassInfos.openWCMObjs(null, wCMFilter);
        if (classInfos.isEmpty()) {
            return null;
        }
        return (ClassInfo)classInfos.getAt(0);
    }

    public Channel makeDefaultChannel(User user, int n) throws WCMException {
        IDepartmentMgr iDepartmentMgr = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
        Groups groups = iDepartmentMgr.getDeptGroupTree(user);
        if (groups.isEmpty()) {
            return UserRelateInfoMaker.findByDefaultChannel();
        }
        Group group = (Group)groups.getAt(groups.size() - 1);
        WebSite webSite = UserRelateInfoMaker.findSiteByName(group.getName());
        if (webSite == null) {
            return UserRelateInfoMaker.findByDefaultChannel();
        }
        int n2 = groups.size() - 1;
        for (int i = 0; i < n2; ++i) {
            Group group2 = (Group)groups.getAt(i);
            if (group2 == null) continue;
            String string = group2.getName();
            Channel channel = Channel.findByName(webSite.getId(), string);
            if (channel == null) {
                string = string + group2.getId();
                channel = Channel.findByName(webSite.getId(), string);
            }
            if (channel == null) continue;
            return channel;
        }
        return UserRelateInfoMaker.findByDefaultChannel();
    }

    public int[] registerViewIds() {
        MetaView metaView = null;
        int n = 39;
        try {
            metaView = GovInfoViewFinder.findMetaViewOfGovInfo(null);
            if (metaView != null) {
                n = metaView.getId();
            }
        }
        catch (WCMException wCMException) {
            logger.error((Object)"\u83b7\u53d6\u653f\u5e9c\u4fe1\u606f\u516c\u5f00\u89c6\u56fe\u51fa\u73b0\u9519\u8bef\u3002", (Throwable)wCMException);
        }
        return new int[]{n};
    }

    private static Channel findByDefaultChannel() throws WCMException {
        String string = ConfigServer.getServer().getSysConfigValue("DEFAULT_CHANNEL", "0");
        int n = Integer.parseInt(string);
        Channel channel = Channel.findById(n);
        if (channel == null) {
            logger.error((Object)I18NMessage.get(UserRelateInfoMaker.class, "UserRelateInfoMaker.label1", "\u6ca1\u6709\u6307\u5b9a\u9ed8\u8ba4\u680f\u76ee"));
        }
        return channel;
    }

    private static WebSite findSiteByName(String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "SiteName=?", "");
        wCMFilter.addSearchValues(string);
        WebSites webSites = WebSites.openWCMObjs(null, wCMFilter);
        if (webSites.isEmpty()) {
            return null;
        }
        return (WebSite)webSites.getAt(0);
    }
}

