/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.right;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaView;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class AuthServerMgr {
    public static boolean hasRight(User user, MetaDBTable metaDBTable) throws WCMException {
        if (user.isAdministrator()) {
            return true;
        }
        if (metaDBTable == null) {
            return false;
        }
        CMSObj cMSObj = AuthServerMgr.findOwner(metaDBTable.getOwnerType(), metaDBTable.getOwnerId());
        return AuthServerMgr.hasRight(user, cMSObj);
    }

    public static boolean hasRight(User user, MetaView metaView) throws WCMException {
        if (user.isAdministrator()) {
            return true;
        }
        if (metaView == null) {
            return false;
        }
        CMSObj cMSObj = AuthServerMgr.findOwner(metaView.getOwnerType(), metaView.getOwnerId());
        return AuthServerMgr.hasRight(user, cMSObj);
    }

    private static CMSObj findOwner(int n, int n2) throws WCMException {
        switch (n) {
            case 1: {
                return new WCMSystemObject(n2);
            }
        }
        CMSObj cMSObj = (CMSObj)BaseObj.findById(n, n2);
        if (cMSObj == null) {
            throw new WCMException(I18NMessage.get(AuthServerMgr.class, "AuthServerMgr.label1", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u5bf9\u8c61\uff01[Type=") + n + ", Id=" + n2 + "]");
        }
        return cMSObj;
    }

    private static boolean hasRight(User user, CMSObj cMSObj) throws WCMException {
        if (user.isAdministrator()) {
            return true;
        }
        int n = -1;
        switch (cMSObj.getWCMType()) {
            case 101: {
                n = 13;
                break;
            }
            case 1: {
                n = -1;
                break;
            }
            default: {
                throw new WCMException(I18NMessage.get(AuthServerMgr.class, "AuthServerMgr.label2", "\u672a\u77e5\u7684Owner Type\uff01[Type=") + cMSObj.getWCMType() + "]");
            }
        }
        return !(n >= 0 ? !AuthServer.hasRight(user, cMSObj, n) : !user.isAdministrator());
    }
}

